package com.biz.crm.tpm.business.payment.receipt.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.payment.receipt.local.entity.PaymentReceiptFile;
import com.biz.crm.tpm.business.payment.receipt.local.entity.PaymentReceiptPay;
import com.biz.crm.tpm.business.payment.receipt.local.entity.PaymentReceiptShould;
import com.biz.crm.tpm.business.payment.receipt.local.repository.PaymentReceiptFileRepository;
import com.biz.crm.tpm.business.payment.receipt.local.service.PaymentReceiptFileService;
import com.biz.crm.tpm.business.payment.receipt.sdk.dto.PaymentReceiptFileDto;
import com.biz.crm.tpm.business.payment.receipt.sdk.dto.PaymentReceiptShouldDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

/**
 * @author: chenlong
 * @date: 2022/12/6 20:11
 * @description: 付款单-附件信息表(PaymentReceiptAuditItem)表服务接口实现类
 */
@Service("PaymentReceiptFileService")
public class PaymentReceiptFileServiceImpl implements PaymentReceiptFileService {

    @Autowired(required = false)
    private PaymentReceiptFileRepository paymentReceiptFileRepository;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 批量修改付款单-核销明细
     *
     * @param dtoList            核销明细列表
     * @param paymentReceiptCode 主键结合
     * @param tenantCode         租户编号
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void batchEdit(List<PaymentReceiptFileDto> dtoList, String paymentReceiptCode, String tenantCode) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        List<PaymentReceiptFileDto> newFileDtoList = new ArrayList<>();
        List<String> idList = new ArrayList<>();
        for (PaymentReceiptFileDto item : dtoList) {
            if (StringUtils.isBlank(item.getId())) {
                item.setPaymentReceiptCode(paymentReceiptCode);
                item.setTenantCode(tenantCode);
                item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                item.setId(null);
                newFileDtoList.add(item);
            } else {
                idList.add(item.getId());
            }
        }
        //删除数据
        if (!CollectionUtils.isEmpty(idList)) {
            this.paymentReceiptFileRepository.lambdaUpdate()
                    .eq(PaymentReceiptFile::getTenantCode, tenantCode)
                    .eq(PaymentReceiptFile::getPaymentReceiptCode, paymentReceiptCode)
                    .notIn(PaymentReceiptFile::getId, idList)
                    .set(PaymentReceiptFile::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                    .update();
        }
        //修改数据
        dtoList.removeAll(newFileDtoList);
        if (!CollectionUtils.isEmpty(dtoList)) {
            Collection<PaymentReceiptFile> auditItems = this.nebulaToolkitService.copyCollectionByBlankList(
                    dtoList, PaymentReceiptFileDto.class, PaymentReceiptFile.class, LinkedHashSet.class, ArrayList.class);
            this.paymentReceiptFileRepository.updateBatchByIdAndTenantCode(auditItems, tenantCode);
        }
        //保存新数据
        if (!CollectionUtils.isEmpty(newFileDtoList)) {
            Collection<PaymentReceiptFile> auditItems = this.nebulaToolkitService.copyCollectionByBlankList(
                    newFileDtoList, PaymentReceiptFileDto.class, PaymentReceiptFile.class, LinkedHashSet.class, ArrayList.class);
            this.paymentReceiptFileRepository.saveBatch(auditItems);
        }
    }

    @Transactional
    @Override
    public void replace(List<PaymentReceiptFileDto> dtoList, String paymentReceiptCode) {
        this.paymentReceiptFileRepository.lambdaUpdate()
                .eq(PaymentReceiptFile::getTenantCode, TenantUtils.getTenantCode())
                .eq(PaymentReceiptFile::getPaymentReceiptCode, paymentReceiptCode)
//                .set(PaymentReceiptFile::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .remove();
        Collection<PaymentReceiptFile> list = this.nebulaToolkitService.copyCollectionByBlankList(dtoList, PaymentReceiptFileDto.class, PaymentReceiptFile.class, LinkedHashSet.class, ArrayList.class);
        this.paymentReceiptFileRepository.saveBatch(list);
    }
}
