package com.biz.crm.tpm.business.payment.receipt.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.payment.receipt.local.entity.PaymentReceiptPay;
import com.biz.crm.tpm.business.payment.receipt.local.entity.PaymentReceiptShould;
import com.biz.crm.tpm.business.payment.receipt.local.repository.PaymentReceiptPayRepository;
import com.biz.crm.tpm.business.payment.receipt.local.service.PaymentReceiptPayService;
import com.biz.crm.tpm.business.payment.receipt.sdk.dto.PaymentReceiptPayDto;
import com.biz.crm.tpm.business.payment.receipt.sdk.dto.PaymentReceiptShouldDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: chenlong
 * @date: 2022/12/5 19:50
 * @description: 付款单-支付明细表(PaymentReceiptPay)表服务接口实现类
 */
@Service("PaymentReceiptPayService")
public class PaymentReceiptPayServiceImpl implements PaymentReceiptPayService {

    @Autowired(required = false)
    private PaymentReceiptPayRepository paymentReceiptPayRepository;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 批量修改付款单-支付明细
     *
     * @param dtoList            支付明细列表
     * @param paymentReceiptCode 主键结合
     * @param tenantCode         租户编号
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void batchEdit(List<PaymentReceiptPayDto> dtoList, String paymentReceiptCode, String tenantCode) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        List<PaymentReceiptPayDto> newPayDtoList = new ArrayList<>();
        List<PaymentReceiptPay> list = this.paymentReceiptPayRepository.lambdaQuery()
                .eq(PaymentReceiptPay::getTenantCode, tenantCode)
                .eq(PaymentReceiptPay::getPaymentReceiptCode, paymentReceiptCode)
                .eq(PaymentReceiptPay::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(PaymentReceiptPay::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
                .list();
        List<String> idList = list.stream().map(o -> o.getId()).collect(Collectors.toList());

        for (int i = 0; i < dtoList.size(); i++) {
            PaymentReceiptPayDto item = dtoList.get(i);
            item.setSortNo(i+1);
            item.setPaymentReceiptCode(paymentReceiptCode);
            item.setTenantCode(tenantCode);
            item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            item.setId(null);
            newPayDtoList.add(item);
        }

        //删除数据
        if (!CollectionUtils.isEmpty(idList)) {
            this.paymentReceiptPayRepository.lambdaUpdate()
                    .eq(PaymentReceiptPay::getTenantCode, tenantCode)
                    .eq(PaymentReceiptPay::getPaymentReceiptCode, paymentReceiptCode)
                    .in(PaymentReceiptPay::getId, idList)
                    .set(PaymentReceiptPay::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                    .update();
        }
        //修改数据
//        dtoList.removeAll(newPayDtoList);
//        if (!CollectionUtils.isEmpty(dtoList)) {
//            Collection<PaymentReceiptPay> pays = this.nebulaToolkitService.copyCollectionByBlankList(
//                    dtoList, PaymentReceiptPayDto.class, PaymentReceiptPay.class, LinkedHashSet.class, ArrayList.class);
//            this.paymentReceiptPayRepository.updateBatchByIdAndTenantCode(pays, tenantCode);
//        }
        //保存新数据
        if (!CollectionUtils.isEmpty(newPayDtoList)) {
            Collection<PaymentReceiptPay> pays = this.nebulaToolkitService.copyCollectionByBlankList(
                    newPayDtoList, PaymentReceiptPayDto.class, PaymentReceiptPay.class, LinkedHashSet.class, ArrayList.class);
            this.paymentReceiptPayRepository.saveBatch(pays);
        }
    }

    @Transactional
    @Override
    public void replace(List<PaymentReceiptPayDto> dtoList, String paymentReceiptCode) {
        this.paymentReceiptPayRepository.lambdaUpdate()
                .eq(PaymentReceiptPay::getTenantCode, TenantUtils.getTenantCode())
                .eq(PaymentReceiptPay::getPaymentReceiptCode, paymentReceiptCode)
//                .set(PaymentReceiptPay::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .remove();
        Collection<PaymentReceiptPay> list = this.nebulaToolkitService.copyCollectionByBlankList(dtoList, PaymentReceiptPayDto.class, PaymentReceiptPay.class, LinkedHashSet.class, ArrayList.class);
        this.paymentReceiptPayRepository.saveBatch(list);
    }
}
