package com.biz.crm.tpm.business.payment.receipt.local.service.internal;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.supplier.sdk.service.SupplierVoService;
import com.biz.crm.mdm.business.supplier.sdk.vo.SupplierVo;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.mn.third.system.sap.fi.sdk.dto.AccountingVoucherDto;
import com.biz.crm.mn.third.system.sap.fi.sdk.vo.SapAccountingVoucherVo;
import com.biz.crm.mn.third.system.sd.sdk.dto.*;
import com.biz.crm.mn.third.system.sd.sdk.service.SapSdApiService;
import com.biz.crm.mn.third.system.sd.sdk.vo.PaymentReceiptResultVo;
import com.biz.crm.mn.third.system.sd.sdk.vo.PaymentReceiptStatusResultVo;
import com.biz.crm.tpm.business.audit.local.entity.AuditCustomerDetail;
import com.biz.crm.tpm.business.audit.local.entity.AuditCustomerDetailCollection;
import com.biz.crm.tpm.business.audit.local.repository.AuditCustomerDetailCollectionRepository;
import com.biz.crm.tpm.business.audit.local.repository.AuditCustomerDetailRepository;
import com.biz.crm.tpm.business.audit.sdk.enumeration.CustomerSupplierTypeEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.SuccessAndFailEnum;
import com.biz.crm.tpm.business.audit.sdk.service.AuditService;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditSupplierDetailVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditVo;
import com.biz.crm.tpm.business.audit.sdk.vo.UpAccountVo;
import com.biz.crm.tpm.business.payment.receipt.local.entity.*;
import com.biz.crm.tpm.business.payment.receipt.local.enums.CommitStatusEnum;
import com.biz.crm.tpm.business.payment.receipt.local.enums.RequestCERespCodeEnum;
import com.biz.crm.tpm.business.payment.receipt.local.enums.SaveStateEnum;
import com.biz.crm.tpm.business.payment.receipt.local.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.payment.receipt.local.repository.*;
import com.biz.crm.tpm.business.payment.receipt.local.service.PaymentReceiptFileService;
import com.biz.crm.tpm.business.payment.receipt.local.service.PaymentReceiptPayService;
import com.biz.crm.tpm.business.payment.receipt.local.service.PaymentReceiptService;
import com.biz.crm.tpm.business.payment.receipt.local.service.PaymentReceiptShouldService;
import com.biz.crm.tpm.business.payment.receipt.sdk.constant.PaymentReceiptConstants;
import com.biz.crm.tpm.business.payment.receipt.sdk.dto.PaymentReceiptFileDto;
import com.biz.crm.tpm.business.payment.receipt.sdk.dto.*;
import com.biz.crm.tpm.business.payment.receipt.sdk.enums.DateUnitTypeEnum;
import com.biz.crm.tpm.business.payment.receipt.sdk.enums.MerchantsTypeEnum;
import com.biz.crm.tpm.business.payment.receipt.sdk.enums.PaymentNatureTypeEnum;
import com.biz.crm.tpm.business.payment.receipt.sdk.event.log.PaymentReceiptEventListener;
import com.biz.crm.tpm.business.payment.receipt.sdk.service.PaymentReceiptSdkService;
import com.biz.crm.tpm.business.payment.receipt.sdk.vo.*;
import com.biz.crm.tpm.business.third.system.sdk.service.SAPCenterService;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;

import static com.biz.crm.tpm.business.payment.receipt.sdk.constant.PaymentReceiptConstants.*;

/**
 * @author: chenlong
 * @date: 2022/12/5 11:36
 * @description: 付款单表(PaymentReceipt)表服务接口实现类
 */
@Service("PaymentReceiptSdkService")
@Slf4j
public class PaymentReceiptSdkServiceImpl implements PaymentReceiptSdkService {
    @Autowired
    private SapSdApiService sapSdApiService;
    @Autowired(required = false)
    private PaymentReceiptRepository paymentReceiptRepository;

    @Autowired(required = false)
    private PaymentReceiptPayRepository paymentReceiptPayRepository;
    @Autowired(required = false)
    private PaymentReceiptShouldRepository paymentReceiptShouldRepository;
    @Autowired(required = false)
    private PaymentReceiptFileRepository paymentReceiptFileRepository;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired(required = false)
    private PaymentReceiptPayService paymentReceiptPayService;
    @Autowired(required = false)
    private PaymentReceiptShouldService paymentReceiptShouldService;
    @Autowired(required = false)
    private PaymentReceiptFileService paymentReceiptFileService;

    @Autowired(required = false)
    private AuditService auditService;
    @Autowired(required = false)
    private SupplierVoService supplierVoService;
    @Autowired
    private RedisLockService redisLockService;
    @Autowired
    private PaymentReceiptService paymentReceiptService;
    @Resource
    private SAPCenterService sapCenterService;

    @Resource
    private LoginUserService loginUserService;

    @Resource
    private RedisTemplate redisTemplate;

    @Resource
    private RocketMqProducer rocketMqProducer;

    @Value("${rocketmq.environment}")
    private String rocketmqEnvironment;

    @Autowired(required = false)
    private AuditCustomerDetailRepository auditCustomerDetailRepository;

    @Autowired(required = false)
    private AuditCustomerDetailCollectionRepository auditCustomerDetailCollectionRepository;

    @Autowired(required = false)
    private PaymentReceiptShouldAuditRelationsRepository paymentReceiptShouldAuditRelationsRepository;

    @Autowired(required = false)
    private ReimburseFundsReasonMappingRepository reimburseFundsReasonMappingRepository;

    @Autowired(required = false)
    private DictToolkitService dictToolkitService;

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param dto      查询dto
     * @return 所有数据
     */
    @Override
    public Page<PaymentReceiptVo> findByConditions(Pageable pageable, PaymentReceiptDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(dto)) {
            dto = new PaymentReceiptDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.paymentReceiptRepository.findByConditions(pageable, dto);
    }

    /**
     * 通过编码查询单条数据
     *
     * @param code 编码
     * @return 单条数据
     */
    @Override
    public PaymentReceiptVo findByCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        PaymentReceipt receipt = this.paymentReceiptRepository.lambdaQuery()
                .eq(PaymentReceipt::getTenantCode, TenantUtils.getTenantCode())
                .eq(PaymentReceipt::getPaymentReceiptCode, code).one();
        if (null == receipt) {
            return null;
        }
        return getDetail(receipt);
    }

    @Override
    public PaymentReceiptVo findByAuditCode(String auditCode) {

        String paymentReceiptCode = "";

        List<PaymentReceiptShould> list = this.paymentReceiptShouldRepository
                .lambdaQuery()
                .eq(PaymentReceiptShould::getAuditCode, auditCode).list();

        if (CollUtil.isNotEmpty(list)) {
            paymentReceiptCode = list.get(0).getPaymentReceiptCode();
        }
        return findByCode(paymentReceiptCode);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @Override
    public PaymentReceiptVo findById(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }
        PaymentReceipt receipt = this.paymentReceiptRepository.lambdaQuery()
                .eq(PaymentReceipt::getTenantCode, TenantUtils.getTenantCode())
                .eq(PaymentReceipt::getId, id).one();
        if (null == receipt) {
            return null;
        }
        return getDetail(receipt);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param ids 主键
     * @return 单条数据
     */
    @Override
    public List<PaymentReceiptVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        List<PaymentReceipt> receiptList = this.paymentReceiptRepository.lambdaQuery()
                .eq(PaymentReceipt::getTenantCode, TenantUtils.getTenantCode())
                .in(PaymentReceipt::getId, ids).list();
        if (CollectionUtils.isEmpty(receiptList)) {
            return null;
        }
        List<PaymentReceiptVo> paymentReceiptVos = new ArrayList<>();
        for (PaymentReceipt paymentReceipt : receiptList) {
            paymentReceiptVos.add(getDetail(paymentReceipt));
        }
        return paymentReceiptVos;
    }

    @Override
    public List<PaymentReceiptVo> findByCodes(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return null;
        }
        List<PaymentReceipt> receiptList = this.paymentReceiptRepository.lambdaQuery()
                .eq(PaymentReceipt::getTenantCode, TenantUtils.getTenantCode())
                .in(PaymentReceipt::getPaymentReceiptCode, codeList).list();
        if (CollectionUtils.isEmpty(receiptList)) {
            return null;
        }
        List<PaymentReceiptVo> paymentReceiptVos = new ArrayList<>();
        for (PaymentReceipt paymentReceipt : receiptList) {
            paymentReceiptVos.add(getDetail(paymentReceipt));
        }
        return paymentReceiptVos;
    }

    /**
     * 组装数据详情
     *
     * @return 单条数据
     */
    public PaymentReceiptVo getDetail(PaymentReceipt receipt) {
        PaymentReceiptVo receiptVo = this.nebulaToolkitService.copyObjectByWhiteList(receipt, PaymentReceiptVo.class, null, null);
        if (StringUtils.isBlank(receiptVo.getPaymentReceiptCode())) {
            return receiptVo;
        }
        //获取支付明细
        List<PaymentReceiptPay> pays = paymentReceiptPayRepository.lambdaQuery()
                .eq(PaymentReceiptPay::getTenantCode, receiptVo.getTenantCode())
                .eq(PaymentReceiptPay::getPaymentReceiptCode, receiptVo.getPaymentReceiptCode())
                .eq(PaymentReceiptPay::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .orderByAsc(PaymentReceiptPay::getSortNo)
                .list();
        if (!CollectionUtils.isEmpty(pays)) {
            Collection<PaymentReceiptPayVo> payVos = this.nebulaToolkitService.copyCollectionByBlankList(
                    pays, PaymentReceiptPay.class, PaymentReceiptPayVo.class, HashSet.class, ArrayList.class);
            LinkedList<PaymentReceiptPayVo> payLink = new LinkedList<>(payVos.stream().sorted(Comparator.comparing(PaymentReceiptPayVo::getSortNo)).collect(Collectors.toList()));
            for (PaymentReceiptPayVo paymentReceiptPayVo : payLink) {
                List<ReimburseFundsReasonMappingVo> mappingVos = this.paymentReceiptShouldRepository.findAuditReimburseMapping(paymentReceiptPayVo.getAuditPayCode(), receipt.getPaymentReceiptCode());
                paymentReceiptPayVo.setReimburseFundsReasonMappingVos(mappingVos);
            }
            receiptVo.setPayList(payLink);
        }
        //获取应付明细
        List<PaymentReceiptShould> shoulds = paymentReceiptShouldRepository.lambdaQuery()
                .eq(PaymentReceiptShould::getTenantCode, receiptVo.getTenantCode())
                .eq(PaymentReceiptShould::getPaymentReceiptCode, receiptVo.getPaymentReceiptCode())
                .eq(PaymentReceiptShould::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .orderByAsc(PaymentReceiptShould::getSortNo)
                .list();

        List<PaymentReceiptShouldAuditRelations> listByByShouldCodeList = this.paymentReceiptShouldAuditRelationsRepository.findListByByPaymentReceiptCode(receiptVo.getPaymentReceiptCode());

        Map<String, List<PaymentReceiptShouldAuditRelations>> relationShouldMap = listByByShouldCodeList.stream().collect(Collectors.groupingBy(PaymentReceiptShouldAuditRelations::getShouldCode));

        if (!CollectionUtils.isEmpty(shoulds)) {
            Collection<PaymentReceiptShouldVo> shouldVos = this.nebulaToolkitService.copyCollectionByBlankList(
                    shoulds, PaymentReceiptShould.class, PaymentReceiptShouldVo.class, HashSet.class, ArrayList.class);
            LinkedList<PaymentReceiptShouldVo> shouldLink = new LinkedList<>(shouldVos.stream().sorted(Comparator.comparing(PaymentReceiptShouldVo::getSortNo))
                    .collect(Collectors.toList()));
            for (PaymentReceiptShouldVo receiptShouldVo : shouldLink) {
                List<PaymentReceiptShouldAuditRelations> relations = relationShouldMap.get(receiptShouldVo.getShouldCode());
                Collection<PaymentReceiptShouldAuditRelationsVo> relationsVos = this.nebulaToolkitService.copyCollectionByWhiteList(relations, PaymentReceiptShouldAuditRelations.class, PaymentReceiptShouldAuditRelationsVo.class, HashSet.class, ArrayList.class);
                receiptShouldVo.setPaymentReceiptShouldAuditRelationsVos(new ArrayList<>(relationsVos));
//                List<String> ids = relations.stream().map(o -> o.getAuditDetailId()).collect(Collectors.toList());
//                receiptShouldVo.setRelationAuditDetailIds(ids);
//
//                Map<String, BigDecimal> auditDetailAmountRelationMap = new HashMap<>();
//                for (PaymentReceiptShouldAuditRelations auditRelations : relations) {
//                    auditDetailAmountRelationMap.put(auditRelations.getAuditDetailId(),auditRelations.getNowShouldPayMoney());
//                }
//                receiptShouldVo.setAuditDetailAmountRelationMap(auditDetailAmountRelationMap);
                receiptShouldVo.setReimburseItem(receiptShouldVo.getReimbursementItemCode());
                receiptShouldVo.setReimburseItemName(receiptShouldVo.getReimbursementItemName());
            }
            receiptVo.setShouldList(shouldLink);
            //更新已付金额 根据应付明细组装核销明细


            Map<String, List<PaymentReceiptShouldAuditRelations>> relationMap = listByByShouldCodeList.stream().collect(Collectors.groupingBy(PaymentReceiptShouldAuditRelations::getAuditDetailId));

            List<PaymentReceiptShouldVo> auditPayList = paymentReceiptShouldRepository.findAuditPayByAuditPayCode(receiptVo.getTenantCode(), new ArrayList<>(relationMap.keySet()));

            Map<String, PaymentReceiptShouldVo> shouldVoMap = receiptVo.getShouldList().stream().collect(Collectors.toMap(PaymentReceiptShouldVo::getShouldCode, Function.identity()));


//            Map<String, PaymentReceiptShouldVo> auditPayMap = new HashMap<>();
//            Map<String, List<PaymentReceiptShouldVo>> shouldVoListMap = new HashMap<>();
//            if (!CollectionUtils.isEmpty(auditPayList)) {
//                auditPayMap = auditPayList.stream().collect(Collectors.toMap(PaymentReceiptShouldVo::getAuditPayCode, Function.identity()));
//
//                shouldVoListMap = auditPayList.stream().collect(Collectors.groupingBy(o -> o.getReimburseItem() + o.getSuppliersCode()));
//
//            }

            LinkedList<PaymentReceiptAuditItemVo> itemVos = new LinkedList<>();
            int sortNo = 1;
            for (PaymentReceiptShouldVo receiptShouldVo : auditPayList) {
                List<PaymentReceiptShouldAuditRelations> auditRelations = relationMap.get(receiptShouldVo.getAuditPayCode());
                for (PaymentReceiptShouldAuditRelations auditRelation : auditRelations) {
                    PaymentReceiptShouldVo shouldVo = shouldVoMap.get(auditRelation.getShouldCode());
                    //更新已付金额
                    shouldVo.setAlreadyMoney(receiptShouldVo.getAlreadyMoney());
                    PaymentReceiptAuditItemVo auditItemVo = new PaymentReceiptAuditItemVo();
                    auditItemVo.setSortNo(sortNo);
                    auditItemVo.setAuditCode(receiptShouldVo.getAuditCode());
                    auditItemVo.setAuditName(receiptShouldVo.getAuditName());
                    auditItemVo.setAuditItemCode(auditRelation.getAuditItemCode());
                    auditItemVo.setAuditPayCode(receiptShouldVo.getAuditPayCode());
                    auditItemVo.setSupplierCode(shouldVo.getSuppliersCode());
                    auditItemVo.setSupplierName(shouldVo.getSuppliersName());
                    auditItemVo.setFactoringCode(shouldVo.getFactoringCode());
                    auditItemVo.setFactoringName(shouldVo.getFactoringName());
                    auditItemVo.setAuditMoney(receiptShouldVo.getShouldPayMoney());
                    auditItemVo.setShouldPayMoney(receiptShouldVo.getShouldPayMoney());
                    auditItemVo.setPrepaidMoney(receiptShouldVo.getPrepaidMoney());
                    auditItemVo.setAlreadyMoney(receiptShouldVo.getAlreadyMoney());
                    auditItemVo.setPendingMoney(auditItemVo.getShouldPayMoney().subtract(auditItemVo.getPrepaidMoney()).subtract(auditItemVo.getAlreadyMoney()));
                    auditItemVo.setNowShouldPayMoney(auditRelation.getNowShouldPayMoney());
//                    auditItemVo.setSortNo(shouldVo.getSortNo());
                    auditItemVo.setReimbursementItemCode(receiptShouldVo.getReimburseItem());
                    auditItemVo.setReimbursementItemName(receiptShouldVo.getReimburseItemName());
                    auditItemVo.setReimburseItem(receiptShouldVo.getReimburseItem());
                    auditItemVo.setReimburseItemName(receiptShouldVo.getReimburseItemName());
                    auditItemVo.setReimburseFundsReasonMappingVos(receiptShouldVo.getReimburseFundsReasonMappingVos());
                    auditItemVo.setMerchantsType(MerchantsTypeEnum.SUPPLIER.getCode());
                    auditItemVo.setPaymentNature(PaymentNatureTypeEnum.OTHER.getCode());
                    auditItemVo.setSuppliersCode(auditItemVo.getSupplierCode());
                    auditItemVo.setSuppliersName(auditItemVo.getSupplierName());

                    //查询核销明细中的付款方式
                    AuditCustomerDetail auditCustomerDetail = auditCustomerDetailRepository.findByAuditDetailCode(auditRelation.getAuditItemCode());
                    if (auditCustomerDetail != null) {
                        auditItemVo.setPayWayCode(auditCustomerDetail.getPayWayCode());
                        auditItemVo.setPayWayName(auditCustomerDetail.getPayWayName());
                    }
                    itemVos.add(auditItemVo);
                    sortNo++;
                }

            }
            receiptVo.setAuditItemList(itemVos);
        }
        //获取附件信息
        List<PaymentReceiptFile> files = paymentReceiptFileRepository.lambdaQuery()
                .eq(PaymentReceiptFile::getTenantCode, receiptVo.getTenantCode())
                .eq(PaymentReceiptFile::getPaymentReceiptCode, receiptVo.getPaymentReceiptCode())
                .eq(PaymentReceiptFile::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .orderByAsc(PaymentReceiptFile::getId)
                .list();
        if (!CollectionUtils.isEmpty(files)) {
            Collection<PaymentReceiptFileVo> fileVos = this.nebulaToolkitService.copyCollectionByBlankList(
                    files, PaymentReceiptFile.class, PaymentReceiptFileVo.class, HashSet.class, ArrayList.class);
            receiptVo.setFileList((List<PaymentReceiptFileVo>) fileVos);
        }

        //核销明细ID集合
        return receiptVo;
    }

    /**
     * 新增数据
     *
     * @param dto dto对象
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public PaymentReceiptVo create(PaymentReceiptDto dto) {
        this.createValidate(dto);
        //租户编码
        String tenantCode = TenantUtils.getTenantCode();
        if (StringUtils.isBlank(dto.getOrgCode())) {
            FacturerUserDetails loginUserDetails = loginUserService.getLoginDetails(FacturerUserDetails.class);
            Validate.notNull(loginUserDetails, "更据当前登录人，未查询到组织！");
            dto.setOrgCode(loginUserDetails.getOrgCode());
            dto.setOrgName(loginUserDetails.getOrgName());
        }
        List<String> auditPayCodeList = new ArrayList<>();
        boolean lockSuccess = false;

        try {
            //提交前加锁一个小时
            LinkedList<PaymentReceiptAuditItemDto> auditItemList = dto.getAuditItemList();
            auditPayCodeList.addAll(auditItemList.stream().filter(k -> StringUtils.isNotEmpty(k.getAuditPayCode()))
                    .map(PaymentReceiptAuditItemDto::getAuditPayCode)
                    .distinct().collect(Collectors.toList()));
            lockSuccess = redisLockService.batchLock(PaymentReceiptConstants.LOCK_PAYMENT_RECEIPT_AUDIT_PAY,
                    auditPayCodeList, TimeUnit.MINUTES, 3);
            Assert.isTrue(lockSuccess, "其他人正在操作数据,加锁失败,请稍后重试!");
            List<String> auditCodeList = auditItemList.stream()
                    .filter(k -> StringUtils.isNotEmpty(k.getAuditCode()))
                    .map(PaymentReceiptAuditItemDto::getAuditCode)
                    .distinct().collect(Collectors.toList());
            List<PaymentReceiptShouldVo> auditPayList = new ArrayList<>();
            auditCodeList.forEach(auditCode -> {
                AuditVo auditVo = this.auditService.findByAuditCode(auditCode);
                String processStatus = auditVo.getProcessStatus();
                if (CharSequenceUtil.equals(ProcessStatusEnum.PASS.getKey(), processStatus)) {
                    //获取核销付款信息和已付金额
                    List<PaymentReceiptShouldVo> list = paymentReceiptShouldRepository.findAuditPayByAuditPayCode(tenantCode, auditPayCodeList);
                    auditPayList.addAll(list);
                } else {
                    List<PaymentReceiptShouldVo> list = this.paymentReceiptShouldRepository.findAuditPaymentByCode(auditCode);
                    auditPayList.addAll(list);
                }
            });
            log.info("auditPayList:{}", JSONUtil.toJsonStr(auditPayList));
            Validate.notEmpty(auditPayList, "未获取到核销付款信息");
            //循环判断本次应付金额是否超出 并计算总金额
            for (PaymentReceiptShouldVo record : auditPayList) {
                record.setId(record.getAuditPayCode());
                record.setMerchantsType(MerchantsTypeEnum.SUPPLIER.getCode());
                record.setPaymentNature(PaymentNatureTypeEnum.OTHER.getCode());
                record.setSuppliersCode(record.getMerchantsCode());
                record.setSuppliersName(record.getMerchantsName());
                record.setMerchantsTwoCode(record.getMerchantsCode());
                record.setMerchantsTwoName(record.getMerchantsName());
                record.setDateUnit(DateUnitTypeEnum.DAY.getCode());
                record.setNowShouldPayMoney(record.getShouldPayMoney().subtract(record.getPrepaidMoney()).subtract(record.getAlreadyMoney()));
                record.setPendingMoney(record.getShouldPayMoney().subtract(record.getPrepaidMoney()).subtract(record.getAlreadyMoney()));
                record.setAuditMoney(record.getShouldPayMoney());
            }
            //汇总
            Collection<PaymentReceiptShouldVo> shouldVos = summaryShouldInfoVo(auditPayList);
            BigDecimal total = BigDecimal.ZERO;
            Map<String, PaymentReceiptShouldVo> auditPayMap = shouldVos.stream().collect(Collectors.toMap(o -> o.getSuppliersCode() + o.getReimburseItem(), Function.identity()));
            for (PaymentReceiptShouldDto shouldDto : dto.getShouldList()) {
                Validate.isTrue(auditPayMap.containsKey(shouldDto.getSuppliersCode() + shouldDto.getReimburseItem()), "[%s]的核销付款信息,未查找到数据或已完全付款", shouldDto.getMerchantsName());
                PaymentReceiptShouldVo sVo = auditPayMap.get(shouldDto.getSuppliersCode() + shouldDto.getReimburseItem());
                BigDecimal b = sVo.getShouldPayMoney().subtract(sVo.getPrepaidMoney()).subtract(sVo.getAlreadyMoney());
                Validate.isTrue(b.compareTo(shouldDto.getNowShouldPayMoney()) >= 0, "[%s]本次应付金额[%s]超过剩余应付金额[%s]",
                        shouldDto.getMerchantsName(), shouldDto.getNowShouldPayMoney(), b);
                shouldDto.setShouldPayMoney(sVo.getShouldPayMoney());
                shouldDto.setPrepaidMoney(sVo.getPrepaidMoney());
                shouldDto.setAlreadyMoney(sVo.getAlreadyMoney());
                total = total.add(shouldDto.getNowShouldPayMoney());
            }
            //付款单主表
            dto.setTenantCode(tenantCode);
//            String ruleCode = StringUtils.join(PaymentReceiptConstants.PAYMENT_RECEIPT_CODE_PREFIX, DateFormatUtils.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY_NO_CH));
            String code = this.generateCodeService.generateCode(PaymentReceiptConstants.PAYMENT_RECEIPT_CODE_PREFIX, 1, 5, 2, TimeUnit.DAYS).get(0);
            dto.setPaymentReceiptCode(code);
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            dto.setId(null);
            dto.setProcessState(ProcessStatusEnum.PREPARE.getDictCode());

            //保存支付明细
            List<PaymentReceiptPayDto> payDtoList = dto.getPayList();
            if (!CollectionUtils.isEmpty(payDtoList)) {
//                String ruleCode2 = StringUtils.join(PaymentReceiptConstants.PAYMENT_RECEIPT_PAY_CODE_PREFIX, DateFormatUtils.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY_NO_CH));
                List<String> codes2 = this.generateCodeService.generateCode(PaymentReceiptConstants.PAYMENT_RECEIPT_PAY_CODE_PREFIX, payDtoList.size(), 5, 2, TimeUnit.DAYS);
                for (int i = 0; i < payDtoList.size(); i++) {
                    PaymentReceiptPayDto payDto = payDtoList.get(i);
                    payDto.setSortNo(i + 1);
                    payDto.setPaymentReceiptCode(code);
                    payDto.setPayCode(codes2.get(i));
                    payDto.setTenantCode(tenantCode);
                    payDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    payDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                    payDto.setId(null);
                }
                Collection<PaymentReceiptPay> pays = this.nebulaToolkitService.copyCollectionByBlankList(payDtoList, PaymentReceiptPayDto.class, PaymentReceiptPay.class, LinkedHashSet.class, ArrayList.class);
                this.paymentReceiptPayRepository.saveBatch(pays);
            }
            //保存应付明细
            List<PaymentReceiptShouldDto> shouldDtoList = dto.getShouldList();
            Map<String, PaymentReceiptShouldDto> sumMap = dto.getShouldList().stream().collect(Collectors.toMap(e -> e.getSuppliersCode() + e.getReimburseItem(), Function.identity()));
            Map<String, List<PaymentReceiptShouldAuditRelationsVo>> sumRMap = new HashMap<>();
            sumMap.forEach((k, vo) -> {
                List<PaymentReceiptShouldAuditRelationsVo> rList = new ArrayList<>(vo.getPaymentReceiptShouldAuditRelationsVos());
                if (sumRMap.containsKey(k)) {
                    sumRMap.get(k).addAll(rList);
                } else {
                    sumRMap.put(k, rList);
                }
            });

            if (!CollectionUtils.isEmpty(shouldDtoList)) {
//                String ruleCode3 = StringUtils.join(PaymentReceiptConstants.PAYMENT_RECEIPT_SHOULD_CODE_PREFIX, DateFormatUtils.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY_NO_CH));
                List<String> codes3 = this.generateCodeService.generateCode(PaymentReceiptConstants.PAYMENT_RECEIPT_SHOULD_CODE_PREFIX, shouldDtoList.size(), 5, 2, TimeUnit.DAYS);
                for (int i = 0; i < shouldDtoList.size(); i++) {
                    PaymentReceiptShouldDto shouldDto = shouldDtoList.get(i);
                    shouldDto.setSortNo(i + 1);
                    shouldDto.setReimbursementItemName(shouldDto.getReimburseItemName());
                    shouldDto.setReimbursementItemCode(shouldDto.getReimburseItem());
                    shouldDto.setPaymentReceiptCode(code);
                    shouldDto.setShouldCode(codes3.get(i));
                    shouldDto.setTenantCode(tenantCode);
                    shouldDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    shouldDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                    shouldDto.setId(null);
                }
                Collection<PaymentReceiptShould> shoulds = this.nebulaToolkitService.copyCollectionByBlankList(shouldDtoList, PaymentReceiptShouldDto.class, PaymentReceiptShould.class, LinkedHashSet.class, ArrayList.class);
                this.paymentReceiptShouldRepository.saveBatch(shoulds);

            }

            //保存应付明细与核销明细关联关系
            List<PaymentReceiptShouldAuditRelations> relations = new ArrayList<>();
            for (PaymentReceiptShouldDto shouldDto : shouldDtoList) {
//                List<PaymentReceiptShouldAuditRelationsVo> relationsVos = shouldDto.getPaymentReceiptShouldAuditRelationsVos();
                List<PaymentReceiptShouldAuditRelationsVo> relationsVos = sumRMap.get(shouldDto.getSuppliersCode() + shouldDto.getReimburseItem());
                for (PaymentReceiptShouldAuditRelationsVo paymentReceiptShouldAuditRelations : relationsVos) {
                    paymentReceiptShouldAuditRelations.setShouldCode(shouldDto.getShouldCode());
                    paymentReceiptShouldAuditRelations.setPaymentReceiptCode(shouldDto.getPaymentReceiptCode());
                    paymentReceiptShouldAuditRelations.setCreateTime(new Date());
                    paymentReceiptShouldAuditRelations.setTenantCode(TenantUtils.getTenantCode());
                    paymentReceiptShouldAuditRelations.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    paymentReceiptShouldAuditRelations.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                }
                relations.addAll(this.nebulaToolkitService.copyCollectionByWhiteList(relationsVos, PaymentReceiptShouldAuditRelationsVo.class, PaymentReceiptShouldAuditRelations.class, HashSet.class, ArrayList.class));
            }
            this.paymentReceiptShouldAuditRelationsRepository.saveBatch(relations);

            //保存附件信息
            List<PaymentReceiptFileDto> fileDtoList = dto.getFileList();
            if (!CollectionUtils.isEmpty(fileDtoList)) {
                fileDtoList.forEach(item -> {
                    item.setPaymentReceiptCode(code);
                    item.setTenantCode(tenantCode);
                    item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                    item.setId(null);
                });
                Collection<PaymentReceiptFile> files = this.nebulaToolkitService.copyCollectionByBlankList(fileDtoList, PaymentReceiptFileDto.class, PaymentReceiptFile.class, LinkedHashSet.class, ArrayList.class);
                this.paymentReceiptFileRepository.saveBatch(files);
            }

            PaymentReceipt receipt = this.nebulaToolkitService.copyObjectByWhiteList(dto, PaymentReceipt.class, null, null);

            //新增业务日志
            PaymentReceiptLogEventDto logEventDto = new PaymentReceiptLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer<PaymentReceiptEventListener, PaymentReceiptLogEventDto> onCreate =
                    PaymentReceiptEventListener::onCreate;
            this.nebulaNetEventClient.publish(logEventDto, PaymentReceiptEventListener.class, onCreate);
            if (StringUtils.equals(YesOrNoEnum.YES.getCode(), dto.getIsFactoring())) {
                receipt.setSapTransferCommitStatus(CommitStatusEnum.TO_BE_COMMIT.getCode());
            }
            receipt.setCeCommitStatus(CommitStatusEnum.TO_BE_COMMIT.getCode());
            Integer accId = 1;
            if (redisTemplate.hasKey(PaymentReceiptConstants.PAYMENT_RECEIPT_ACC_ID)) {
                Object o = redisTemplate.opsForValue().get(PaymentReceiptConstants.PAYMENT_RECEIPT_ACC_ID);
                accId = (Integer) o;
                accId = accId + 1;
                redisTemplate.opsForValue().set(PaymentReceiptConstants.PAYMENT_RECEIPT_ACC_ID, accId);
            } else {
                redisTemplate.opsForValue().set(PaymentReceiptConstants.PAYMENT_RECEIPT_ACC_ID, accId);
            }
            receipt.setSapTransferCertCode(Integer.toString(accId));
            this.paymentReceiptRepository.save(receipt);
//            如果是提交，则发起审批工作流
            this.createOrUpdateAndSubmit(dto, receipt);
            return this.nebulaToolkitService.copyObjectByWhiteList(receipt, PaymentReceiptVo.class, null, null);
        } finally {
            if (lockSuccess
                    && CollectionUtil.isNotEmpty(auditPayCodeList)) {
                redisLockService.batchUnLock(PaymentReceiptConstants.LOCK_PAYMENT_RECEIPT_AUDIT_PAY, auditPayCodeList);
            }
        }
    }


    public void createOrUpdateAndSubmit(PaymentReceiptDto dto, PaymentReceipt receipt) {
        //            如果是提交，则发起审批工作流
        if (StringUtils.equals(SaveStateEnum.SUBMIT.getCode(), dto.getSaveState())) {
            List<PaymentReceiptDto> list = new ArrayList<>();
            PaymentReceiptDto receiptDto = new PaymentReceiptDto();
            PaymentReceiptProcessDto processDto = new PaymentReceiptProcessDto();
            BeanUtils.copyProperties(receipt, receiptDto);
            processDto.setProcessBusiness(dto.getProcessBusiness());
            list.add(receiptDto);
            processDto.setPaymentReceiptDtos(list);
            paymentReceiptService.submitApproval(processDto);
            this.paymentReceiptRepository.updateProcessStatus(receipt.getPaymentReceiptCode(), ProcessStatusEnum.COMMIT.getDictCode());
        }
    }

    private List<PaymentReceiptShouldVo> summaryShouldInfoVo(List<PaymentReceiptShouldVo> shouldVos) {
        if (CollectionUtils.isEmpty(shouldVos)) {
            return new LinkedList<>();
        }
        List<PaymentReceiptShouldVo> paymentReceiptShouldVos = new LinkedList<>();
        Map<String, List<PaymentReceiptShouldVo>> listMap = shouldVos.stream().collect(Collectors.groupingBy(o -> o.getSuppliersCode() + o.getReimburseItem()));
        for (Map.Entry<String, List<PaymentReceiptShouldVo>> entry : listMap.entrySet()) {
            //汇总计算金额
            PaymentReceiptShouldVo summary = new PaymentReceiptShouldVo();
            BigDecimal totalAmount = BigDecimal.ZERO;
            BigDecimal preAmount = BigDecimal.ZERO;
            BigDecimal already = BigDecimal.ZERO;
            BigDecimal shouldPay = BigDecimal.ZERO;
            BigDecimal auditMoney = BigDecimal.ZERO;
            List<PaymentReceiptShouldVo> groupShouldVos = entry.getValue();
            List<String> ids = new ArrayList<>();
            Map<String, BigDecimal> auditDetailAmountRelationMap = new HashMap<>();
            List<PaymentReceiptShouldAuditRelationsVo> relationsVos = new ArrayList<>();
            for (PaymentReceiptShouldVo shouldVo : groupShouldVos) {
                totalAmount = totalAmount.add(shouldVo.getNowShouldPayMoney());
                preAmount = preAmount.add(shouldVo.getPrepaidMoney());
                already = already.add(shouldVo.getAlreadyMoney());
                shouldPay = shouldPay.add(shouldVo.getShouldPayMoney());
                auditMoney = auditMoney.add(Optional.ofNullable(shouldVo.getAuditMoney()).orElse(BigDecimal.ZERO));
                ids.add(shouldVo.getAuditPayCode());
                auditDetailAmountRelationMap.put(shouldVo.getAuditPayCode(), shouldVo.getNowShouldPayMoney());

                PaymentReceiptShouldAuditRelationsVo relationsVo = new PaymentReceiptShouldAuditRelationsVo();
                relationsVo.setAuditDetailId(shouldVo.getAuditPayCode());
                relationsVo.setAuditItemCode(shouldVo.getAuditItemCode());
                relationsVo.setNowShouldPayMoney(shouldVo.getNowShouldPayMoney());
                relationsVo.setAuditItemCode(shouldVo.getAuditItemCode());
                relationsVos.add(relationsVo);
            }
            //汇总,取第一个写入除金额以外的其他属性
            PaymentReceiptShouldVo first = groupShouldVos.get(0);
            BeanUtils.copyProperties(first, summary);
            summary.setPaymentReceiptShouldAuditRelationsVos(relationsVos);
            summary.setNowShouldPayMoney(totalAmount);
            summary.setPrepaidMoney(preAmount);
            summary.setAlreadyMoney(already);
            summary.setShouldPayMoney(shouldPay);
            summary.setAuditMoney(auditMoney);
            summary.setRelationAuditDetailIds(ids);
            summary.setAuditDetailAmountRelationMap(auditDetailAmountRelationMap);
            summary.setReimburseFundsReasonMappingVos(first.getReimburseFundsReasonMappingVos());
            paymentReceiptShouldVos.add(summary);
        }
        return paymentReceiptShouldVos;
    }


    /**
     * 汇总应付信息
     *
     * @param shouldDtoList
     * @return
     */
    public List<PaymentReceiptShouldDto> summaryShouldInfo(List<PaymentReceiptShouldDto> shouldDtoList) {
        if (CollectionUtils.isEmpty(shouldDtoList)) {
            return null;
        }
        List<PaymentReceiptShouldDto> shouldDtoListNew = new LinkedList<>();
        Map<String, List<PaymentReceiptShouldDto>> listMap = shouldDtoList.stream().collect(Collectors.groupingBy(o -> o.getSuppliersCode() + o.getReimburseItem()));
        for (Map.Entry<String, List<PaymentReceiptShouldDto>> entry : listMap.entrySet()) {
            PaymentReceiptShouldDto paymentReceiptShouldDto = new PaymentReceiptShouldDto();
            BigDecimal totalAmount = BigDecimal.ZERO;
            BigDecimal preAmount = BigDecimal.ZERO;
            BigDecimal already = BigDecimal.ZERO;
            BigDecimal shouldPay = BigDecimal.ZERO;
            BigDecimal auditMoney = BigDecimal.ZERO;

            List<PaymentReceiptShouldDto> shouldDtos = entry.getValue();
            List<PaymentReceiptShouldAuditRelationsVo> relationsVos = new ArrayList<>();
            for (PaymentReceiptShouldDto shouldDto : shouldDtos) {
                totalAmount = totalAmount.add(shouldDto.getNowShouldPayMoney());
                preAmount = preAmount.add(shouldDto.getPrepaidMoney());
                already = already.add(shouldDto.getAlreadyMoney());
                shouldPay = shouldPay.add(shouldDto.getShouldPayMoney());
                auditMoney = auditMoney.add(shouldDto.getAuditMoney());

                PaymentReceiptShouldAuditRelationsVo relationsVo = new PaymentReceiptShouldAuditRelationsVo();
                relationsVo.setAuditDetailId(shouldDto.getAuditPayCode());
                relationsVo.setNowShouldPayMoney(shouldDto.getNowShouldPayMoney());
                relationsVo.setAuditItemCode(shouldDto.getAuditItemCode());
                relationsVos.add(relationsVo);

            }
            PaymentReceiptShouldDto paymentReceiptShouldDto1 = shouldDtos.get(0);
            BeanUtils.copyProperties(paymentReceiptShouldDto1, paymentReceiptShouldDto);
            paymentReceiptShouldDto.setNowShouldPayMoney(totalAmount);
            paymentReceiptShouldDto.setMerchantsCode(paymentReceiptShouldDto.getSuppliersCode());
            paymentReceiptShouldDto.setMerchantsName(paymentReceiptShouldDto.getSuppliersName());
            paymentReceiptShouldDto.setMerchantsTwoCode(paymentReceiptShouldDto.getSuppliersCode());
            paymentReceiptShouldDto.setMerchantsTwoName(paymentReceiptShouldDto.getSuppliersName());
            paymentReceiptShouldDto.setPrepaidMoney(preAmount);
            paymentReceiptShouldDto.setAlreadyMoney(already);
            paymentReceiptShouldDto.setShouldPayMoney(shouldPay);
            paymentReceiptShouldDto.setAuditMoney(auditMoney);

            paymentReceiptShouldDto.setReimburseFundsReasonMappingVos(paymentReceiptShouldDto1.getReimburseFundsReasonMappingVos());
            paymentReceiptShouldDto.setPaymentReceiptShouldAuditRelationsVos(relationsVos);

            shouldDtoListNew.add(paymentReceiptShouldDto);
        }

        return shouldDtoListNew;
    }

    /**
     * 新增数据数据校验
     *
     * @param dto dto对象
     */
    public void createValidate(PaymentReceiptDto dto) {
        Validate.notBlank(dto.getBusinessFormatCode(), "业态不能为空！");
        Validate.notBlank(dto.getBusinessUnitCode(), "业务单元不能为空！");
//        Validate.notBlank(dto.getApplyWorkNo(), "申请人工号不能为空！");
        Validate.notBlank(dto.getApplyPerson(), "申请人不能为空！");
        Validate.notBlank(dto.getApplyDepartCode(), "申请人部门编码不能为空！");
        Validate.notBlank(dto.getApplyDepartName(), "申请人部门不能为空！");
//        Validate.notBlank(dto.getCompanyCode(), "公司编码不能为空！");
//        Validate.notBlank(dto.getCompanyName(), "公司名称不能为空！");
        Validate.notBlank(dto.getProfitCenterCode(), "利润中心编码不能为空！");
//        Validate.notBlank(dto.getProfitCenterName(), "利润中心名称不能为空！");
        Validate.notBlank(dto.getPayType(), "付款类型不能为空！");
        Validate.notBlank(dto.getPayItemType(), "付款细类不能为空！");
        Validate.notBlank(dto.getTradeCurrency(), "交易货币不能为空！");
        Validate.notBlank(dto.getExchangeRate(), "汇率不能为空！");
        Validate.notBlank(dto.getPayWay(), "付款方式不能为空！");
        Validate.notBlank(dto.getAuditDepart(), "FSSC审核部门不能为空！");
        Validate.notBlank(dto.getIsHaveContract(), "是否有合同不能为空！");
        Validate.notBlank(dto.getIsFactoring(), "是否挂账保理不能为空！");
        Validate.notEmpty(dto.getAuditItemList(), "核销明细列表不能为空！");
        int i = 0;
        Map<String, PaymentReceiptAuditItemDto> sortMap = new HashMap<>();
        for (PaymentReceiptAuditItemDto itemDto : dto.getAuditItemList()) {
            Validate.notBlank(itemDto.getAuditPayCode(), "核销付款信息编码不能为空！");
            Validate.notBlank(itemDto.getSupplierCode(), "供应商编码不能为空！");
            Validate.notBlank(itemDto.getSupplierName(), "供应商名称不能为空！");
            if (StringUtils.equals(YesOrNoEnum.YES.getCode(), dto.getIsFactoring())) {
                Validate.notBlank(itemDto.getFactoringCode(), "保理客户编码不能为空！");
                Validate.notBlank(itemDto.getFactoringName(), "保理客户名称不能为空！");
            }
            i++;
            itemDto.setSortNo(i);
            sortMap.put(itemDto.getAuditPayCode(), itemDto);
        }
        Validate.notEmpty(dto.getShouldList(), "应付明细列表不能为空！");
//        Validate.isTrue(dto.getShouldList().size() == i, "核销明细列表与应付明细列表条数不一致");
        for (PaymentReceiptShouldDto shouldDto : dto.getShouldList()) {
            Validate.notBlank(shouldDto.getAuditPayCode(), "核销付款信息编码不能为空！");
            Validate.notNull(shouldDto.getExpectPayDate(), "期望付款日期不能为空");
//            Validate.isTrue(sortMap.containsKey(shouldDto.getAuditPayCode()), "应付明细与核销明细数据没有一一对应");
            if (StringUtils.equals(YesOrNoEnum.YES.getCode(), dto.getIsHaveContract())) {
                Validate.notBlank(shouldDto.getContractCode(), "有合同时，必须填写合同编码");
                Validate.notBlank(shouldDto.getContractName(), "有合同时，必须填写合同名称");
            }
            PaymentReceiptAuditItemDto item = sortMap.get(shouldDto.getAuditPayCode());
            shouldDto.setSortNo(item.getSortNo());
            shouldDto.setSuppliersCode(item.getSupplierCode());
            shouldDto.setSuppliersName(item.getSupplierName());
            shouldDto.setFactoringCode(item.getFactoringCode());
            shouldDto.setFactoringName(item.getFactoringName());
            shouldDto.setReimbursementItemCode(item.getReimbursementItemCode());
            shouldDto.setReimbursementItemName(item.getReimbursementItemName());
        }
        Validate.notEmpty(dto.getPayList(), "支付明细列表不能为空！");
//        Validate.isTrue(dto.getShouldList().size() == i, "核销明细列表与支付明细列表条数不一致");
        for (PaymentReceiptPayDto payDto : dto.getPayList()) {
            Validate.notBlank(payDto.getAuditPayCode(), "核销付款信息编码不能为空！");
//            Validate.isTrue(sortMap.containsKey(payDto.getAuditPayCode()), "支付明细与核销明细数据没有一一对应");
//            payDto.setSortNo(sortMap.get(payDto.getAuditPayCode()).getSortNo());
        }
        Validate.notBlank(dto.getPayTotalMoney(), "付款总金额不能为空！");
        Validate.notEmpty(dto.getSaveState(), "保存状态不能为空！");
    }

    /**
     * 修改数据
     *
     * @param dto dto对象
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public PaymentReceiptVo update(PaymentReceiptDto dto) {
        this.updateValidate(dto);
        //租户编码
        String tenantCode = TenantUtils.getTenantCode();
        //付款单主表
        PaymentReceiptVo oldVo = this.findById(dto.getId());
        Validate.notNull(oldVo, "未查找到到付款单数据或数据已删除");
        if (StringUtils.isNotBlank(oldVo.getProcessState())) {
            if (ProcessStatusEnum.COMMIT.getDictCode().equals(oldVo.getProcessState())
                    || ProcessStatusEnum.PASS.getDictCode().equals(oldVo.getProcessState())) {
                Validate.isTrue(false, "审批状态为[%s]不允许编辑",
                        ProcessStatusEnum.getStatusNameByKey(oldVo.getProcessState()));
            }
        }

        List<String> auditPayCodeList = new ArrayList<>();
        boolean lockSuccess = false;

        try {
            auditPayCodeList.addAll(dto.getAuditItemList().stream()
                    .filter(k -> StringUtils.isNotEmpty(k.getAuditPayCode()))
                    .map(PaymentReceiptAuditItemDto::getAuditPayCode)
                    .distinct().collect(Collectors.toList()));
            lockSuccess = redisLockService.batchLock(PaymentReceiptConstants.LOCK_PAYMENT_RECEIPT_AUDIT_PAY,
                    auditPayCodeList, TimeUnit.MINUTES, 3);
            Assert.isTrue(lockSuccess, "其他人正在操作数据,加锁失败,请稍后重试!");
            List<String> auditCodeList  = dto.getAuditItemList().stream()
                    .filter(k -> StringUtils.isNotEmpty(k.getAuditCode()))
                    .map(PaymentReceiptAuditItemDto::getAuditCode)
                    .distinct().collect(Collectors.toList());
            List<PaymentReceiptShouldVo> auditPayList = new ArrayList<>();
            auditCodeList.forEach(auditCode -> {
                AuditVo auditVo = this.auditService.findByAuditCode(auditCode);
                String processStatus = auditVo.getProcessStatus();
                if (CharSequenceUtil.equals(ProcessStatusEnum.PASS.getKey(), processStatus)) {
                    //获取核销付款信息和已付金额
                    List<PaymentReceiptShouldVo> list = paymentReceiptShouldRepository.findAuditPayByAuditPayCode(tenantCode, auditPayCodeList);
                    auditPayList.addAll(list);
                } else {
                    List<PaymentReceiptShouldVo> list = this.paymentReceiptShouldRepository.findAuditPaymentByCode(auditCode);
                    auditPayList.addAll(list);
                }
            });
            log.info("auditPayList:{}", JSONUtil.toJsonStr(auditPayList));
            Validate.notEmpty(auditPayList, "未获取到核销付款信息");

            //循环判断本次应付金额是否超出 并计算总金额
            for (PaymentReceiptShouldVo record : auditPayList) {
                record.setId(record.getAuditPayCode());
                record.setMerchantsType(MerchantsTypeEnum.SUPPLIER.getCode());
                record.setPaymentNature(PaymentNatureTypeEnum.OTHER.getCode());
                record.setSuppliersCode(record.getMerchantsCode());
                record.setSuppliersName(record.getMerchantsName());
                record.setMerchantsTwoCode(record.getMerchantsCode());
                record.setMerchantsTwoName(record.getMerchantsName());
                record.setDateUnit(DateUnitTypeEnum.DAY.getCode());
                record.setNowShouldPayMoney(record.getShouldPayMoney().subtract(record.getPrepaidMoney()).subtract(record.getAlreadyMoney()));
                record.setPendingMoney(record.getShouldPayMoney().subtract(record.getPrepaidMoney()).subtract(record.getAlreadyMoney()));
                record.setAuditMoney(record.getShouldPayMoney());
            }
            //汇总
            Collection<PaymentReceiptShouldVo> shouldVos = summaryShouldInfoVo(auditPayList);
            BigDecimal total = BigDecimal.ZERO;
            Map<String, PaymentReceiptShouldVo> auditPayMap = shouldVos.stream().collect(Collectors.toMap(o -> o.getSuppliersCode() + o.getReimburseItem(), Function.identity()));
            for (PaymentReceiptShouldDto shouldDto : dto.getShouldList()) {
                Validate.isTrue(auditPayMap.containsKey(shouldDto.getSuppliersCode() + shouldDto.getReimburseItem()), "[%s]的核销付款信息,未查找到数据或已完全付款", shouldDto.getMerchantsName());
                PaymentReceiptShouldVo sVo = auditPayMap.get(shouldDto.getSuppliersCode() + shouldDto.getReimburseItem());
                BigDecimal b = sVo.getShouldPayMoney().subtract(sVo.getPrepaidMoney()).subtract(sVo.getAlreadyMoney());
                Validate.isTrue(b.compareTo(shouldDto.getNowShouldPayMoney()) >= 0, "[%s]本次应付金额[%s]超过剩余应付金额[%s]",
                        shouldDto.getMerchantsName(), shouldDto.getNowShouldPayMoney(), b);
                shouldDto.setShouldPayMoney(sVo.getShouldPayMoney());
                shouldDto.setPrepaidMoney(sVo.getPrepaidMoney());
                shouldDto.setAlreadyMoney(sVo.getAlreadyMoney());
                total = total.add(shouldDto.getNowShouldPayMoney());
            }
            //付款单主表
            String code = oldVo.getPaymentReceiptCode();
            dto.setPaymentReceiptCode(code);
            dto.setProcessState(ProcessStatusEnum.PREPARE.getDictCode());

            //保存支付明细
            List<PaymentReceiptPayDto> payDtoList = dto.getPayList();
            if (!CollectionUtils.isEmpty(payDtoList)) {
                List<String> codes2 = this.generateCodeService.generateCode(PaymentReceiptConstants.PAYMENT_RECEIPT_PAY_CODE_PREFIX, payDtoList.size(), 5, 2, TimeUnit.DAYS);
                for (int i = 0; i < payDtoList.size(); i++) {
                    PaymentReceiptPayDto payDto = payDtoList.get(i);
                    payDto.setSortNo(i + 1);
                    payDto.setPaymentReceiptCode(code);
                    payDto.setPayCode(codes2.get(i));
                    payDto.setTenantCode(tenantCode);
                    payDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    payDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                    payDto.setId(null);
                }
                this.paymentReceiptPayService.replace(payDtoList, code);
            }
            //保存应付明细
            List<PaymentReceiptShouldDto> shouldDtoList = dto.getShouldList();
            Map<String, PaymentReceiptShouldDto> sumMap = dto.getShouldList().stream().collect(Collectors.toMap(e -> e.getSuppliersCode() + e.getReimburseItem(), Function.identity()));
            Map<String, List<PaymentReceiptShouldAuditRelationsVo>> sumRMap = new HashMap<>();
            sumMap.forEach((k, vo) -> {
                List<PaymentReceiptShouldAuditRelationsVo> rList = new ArrayList<>(vo.getPaymentReceiptShouldAuditRelationsVos());
                if (sumRMap.containsKey(k)) {
                    sumRMap.get(k).addAll(rList);
                } else {
                    sumRMap.put(k, rList);
                }
            });

            if (!CollectionUtils.isEmpty(shouldDtoList)) {
                List<String> codes3 = this.generateCodeService.generateCode(PaymentReceiptConstants.PAYMENT_RECEIPT_SHOULD_CODE_PREFIX, shouldDtoList.size(), 5, 2, TimeUnit.DAYS);
                for (int i = 0; i < shouldDtoList.size(); i++) {
                    PaymentReceiptShouldDto shouldDto = shouldDtoList.get(i);
                    shouldDto.setSortNo(i + 1);
                    shouldDto.setReimbursementItemName(shouldDto.getReimburseItemName());
                    shouldDto.setReimbursementItemCode(shouldDto.getReimburseItem());
                    shouldDto.setPaymentReceiptCode(code);
                    shouldDto.setShouldCode(codes3.get(i));
                    shouldDto.setTenantCode(tenantCode);
                    shouldDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    shouldDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                    shouldDto.setId(null);
                }
                this.paymentReceiptShouldService.replace(shouldDtoList, code);
            }

            //保存应付明细与核销明细关联关系
            List<PaymentReceiptShouldAuditRelations> relations = new ArrayList<>();
            for (PaymentReceiptShouldDto shouldDto : shouldDtoList) {
//                List<PaymentReceiptShouldAuditRelationsVo> relationsVos = shouldDto.getPaymentReceiptShouldAuditRelationsVos();
                List<PaymentReceiptShouldAuditRelationsVo> relationsVos = sumRMap.get(shouldDto.getSuppliersCode() + shouldDto.getReimburseItem());
                for (PaymentReceiptShouldAuditRelationsVo paymentReceiptShouldAuditRelations : relationsVos) {
                    paymentReceiptShouldAuditRelations.setShouldCode(shouldDto.getShouldCode());
                    paymentReceiptShouldAuditRelations.setPaymentReceiptCode(shouldDto.getPaymentReceiptCode());
                    paymentReceiptShouldAuditRelations.setCreateTime(new Date());
                    paymentReceiptShouldAuditRelations.setTenantCode(TenantUtils.getTenantCode());
                    paymentReceiptShouldAuditRelations.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    paymentReceiptShouldAuditRelations.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                }
                relations.addAll(this.nebulaToolkitService.copyCollectionByWhiteList(relationsVos, PaymentReceiptShouldAuditRelationsVo.class, PaymentReceiptShouldAuditRelations.class, HashSet.class, ArrayList.class));
            }
            this.paymentReceiptShouldAuditRelationsRepository.replace(relations, code);

            //保存附件信息
            List<PaymentReceiptFileDto> fileDtoList = dto.getFileList();
            if (!CollectionUtils.isEmpty(fileDtoList)) {
                fileDtoList.forEach(item -> {
                    item.setPaymentReceiptCode(code);
                    item.setTenantCode(tenantCode);
                    item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                    item.setId(null);
                });
                this.paymentReceiptFileService.replace(fileDtoList, code);
            }

            PaymentReceipt newReceipt = this.nebulaToolkitService.copyObjectByWhiteList(dto, PaymentReceipt.class, null, null);
            newReceipt.setProcessState(ProcessStatusEnum.PREPARE.getDictCode());
            this.paymentReceiptRepository.updateById(newReceipt);

            //编辑业务日志
            PaymentReceiptLogEventDto logEventDto = new PaymentReceiptLogEventDto();
            logEventDto.setOriginal(oldVo);
            logEventDto.setNewest(dto);
            SerializableBiConsumer<PaymentReceiptEventListener, PaymentReceiptLogEventDto> onUpdate =
                    PaymentReceiptEventListener::onUpdate;
            this.nebulaNetEventClient.publish(logEventDto, PaymentReceiptEventListener.class, onUpdate);

            PaymentReceipt receipt = this.nebulaToolkitService.copyObjectByWhiteList(dto, PaymentReceipt.class, null, null);
            if (StringUtils.equals(YesOrNoEnum.YES.getCode(), dto.getIsFactoring())) {
                receipt.setSapTransferCommitStatus(CommitStatusEnum.TO_BE_COMMIT.getCode());
            }
            receipt.setCeCommitStatus(CommitStatusEnum.TO_BE_COMMIT.getCode());
            Integer accId = 1;
            if (redisTemplate.hasKey(PaymentReceiptConstants.PAYMENT_RECEIPT_ACC_ID)) {
                Object o = redisTemplate.opsForValue().get(PaymentReceiptConstants.PAYMENT_RECEIPT_ACC_ID);
                accId = (Integer) o;
                accId = accId + 1;
                redisTemplate.opsForValue().set(PaymentReceiptConstants.PAYMENT_RECEIPT_ACC_ID, accId);
            } else {
                redisTemplate.opsForValue().set(PaymentReceiptConstants.PAYMENT_RECEIPT_ACC_ID, accId);
            }
            receipt.setSapTransferCertCode(Integer.toString(accId));
            this.createOrUpdateAndSubmit(dto, newReceipt);
            return this.nebulaToolkitService.copyObjectByWhiteList(newReceipt, PaymentReceiptVo.class, null, null);
        } finally {
            if (lockSuccess
                    && CollectionUtil.isNotEmpty(auditPayCodeList)) {
                redisLockService.batchUnLock(PaymentReceiptConstants.LOCK_PAYMENT_RECEIPT_AUDIT_PAY, auditPayCodeList);
            }
        }
    }

    /**
     * 新增数据数据校验
     *
     * @param dto dto对象
     */
    public void updateValidate(PaymentReceiptDto dto) {
        Validate.notBlank(dto.getId(), "id不能为空！");
        Validate.notBlank(dto.getBusinessFormatCode(), "业态不能为空！");
        Validate.notBlank(dto.getBusinessUnitCode(), "业务单元不能为空！");
//        Validate.notBlank(dto.getApplyWorkNo(), "申请人工号不能为空！");
        Validate.notBlank(dto.getApplyPerson(), "申请人不能为空！");
        Validate.notBlank(dto.getApplyDepartCode(), "申请人部门编码不能为空！");
        Validate.notBlank(dto.getApplyDepartName(), "申请人部门不能为空！");
//        Validate.notBlank(dto.getCompanyCode(), "公司编码不能为空！");
//        Validate.notBlank(dto.getCompanyName(), "公司名称不能为空！");
        Validate.notBlank(dto.getProfitCenterCode(), "利润中心编码不能为空！");
//        Validate.notBlank(dto.getProfitCenterName(), "利润中心名称不能为空！");
        Validate.notBlank(dto.getPayType(), "付款类型不能为空！");
        Validate.notBlank(dto.getPayItemType(), "付款细类不能为空！");
        Validate.notBlank(dto.getTradeCurrency(), "交易货币不能为空！");
        Validate.notBlank(dto.getExchangeRate(), "汇率不能为空！");
        Validate.notBlank(dto.getPayWay(), "付款方式不能为空！");
        Validate.notBlank(dto.getAuditDepart(), "FSSC审核部门不能为空！");
        Validate.notBlank(dto.getIsHaveContract(), "是否有合同不能为空！");
        Validate.notBlank(dto.getIsFactoring(), "是否挂账保理不能为空！");
        Validate.notEmpty(dto.getAuditItemList(), "核销明细列表不能为空！");
        int i = 0;
        Map<String, PaymentReceiptAuditItemDto> sortMap = new HashMap<>();
        for (PaymentReceiptAuditItemDto itemDto : dto.getAuditItemList()) {
            Validate.notBlank(itemDto.getAuditPayCode(), "核销付款信息编码不能为空！");
            Validate.notBlank(itemDto.getSupplierCode(), "供应商编码不能为空！");
            Validate.notBlank(itemDto.getSupplierName(), "供应商名称不能为空！");
            if (StringUtils.equals(YesOrNoEnum.YES.getCode(), dto.getIsFactoring())) {
                Validate.notBlank(itemDto.getFactoringCode(), "保理客户编码不能为空！");
                Validate.notBlank(itemDto.getFactoringName(), "保理客户名称不能为空！");
            }
            i++;
            itemDto.setSortNo(i);
            sortMap.put(itemDto.getAuditPayCode(), itemDto);
        }
        Validate.notEmpty(dto.getShouldList(), "应付明细列表不能为空！");
//        Validate.isTrue(dto.getShouldList().size() == i, "核销明细列表与应付明细列表条数不一致");
        for (PaymentReceiptShouldDto shouldDto : dto.getShouldList()) {
            Validate.notBlank(shouldDto.getAuditPayCode(), "核销付款信息编码不能为空！");
//            Validate.isTrue(sortMap.containsKey(shouldDto.getAuditPayCode()), "应付明细与核销明细数据没有一一对应");
            Validate.notNull(shouldDto.getExpectPayDate(), "期望付款日期不能为空");
            if (StringUtils.equals(YesOrNoEnum.YES.getCode(), dto.getIsHaveContract())) {
                Validate.notBlank(shouldDto.getContractCode(), "有合同时，必须填写合同编码");
                Validate.notBlank(shouldDto.getContractName(), "有合同时，必须填写合同名称");
            }
            PaymentReceiptAuditItemDto item = sortMap.get(shouldDto.getAuditPayCode());
            shouldDto.setSortNo(item.getSortNo());
            shouldDto.setSuppliersCode(item.getSupplierCode());
            shouldDto.setSuppliersName(item.getSupplierName());
            shouldDto.setFactoringCode(item.getFactoringCode());
            shouldDto.setFactoringName(item.getFactoringName());
            shouldDto.setReimbursementItemCode(item.getReimbursementItemCode());
            shouldDto.setReimbursementItemName(item.getReimbursementItemName());
        }
        Validate.notEmpty(dto.getPayList(), "支付明细列表不能为空！");
//        Validate.isTrue(dto.getShouldList().size() == i, "核销明细列表与支付明细列表条数不一致");
        for (PaymentReceiptPayDto payDto : dto.getPayList()) {
            Validate.notBlank(payDto.getAuditPayCode(), "核销付款信息编码不能为空！");
//            Validate.isTrue(sortMap.containsKey(payDto.getAuditPayCode()), "支付明细与核销明细数据没有一一对应");
//            payDto.setSortNo(sortMap.get(payDto.getAuditPayCode()).getSortNo());
        }
        Validate.notBlank(dto.getPayTotalMoney(), "付款总金额不能为空！");
    }

    /**
     * 删除数据
     *
     * @param ids 主键结合
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void delete(List<String> ids) {
        Validate.isTrue(!CollectionUtils.isEmpty(ids), "删除数据时，主键集合不能为空！");
        List<PaymentReceipt> entityList = this.paymentReceiptRepository.lambdaQuery()
                .eq(PaymentReceipt::getTenantCode, TenantUtils.getTenantCode())
                .in(PaymentReceipt::getId, ids)
                .list();
        if (CollectionUtils.isEmpty(entityList)) {
            return;
        }
        entityList.forEach(item -> {
            if (ProcessStatusEnum.COMMIT.getKey().equals(item.getProcessState())) {
                throw new IllegalArgumentException("单据[" + item.getPaymentReceiptCode() + "]"
                        + ProcessStatusEnum.COMMIT.getValue() + ",不能删除!");
            }
            if (ProcessStatusEnum.PASS.getKey().equals(item.getProcessState())) {
                throw new IllegalArgumentException("单据[" + item.getPaymentReceiptCode() + "]"
                        + ProcessStatusEnum.PASS.getValue() + ",不能删除!");
            }
            if (CommitStatusEnum.COMMIT_SUCCESS.getCode().equals(item.getCeCommitStatus())) {
                throw new IllegalArgumentException("单据[" + item.getPaymentReceiptCode() + "]"
                        + "推送CE成功,不能删除!");
            }
            if (CommitStatusEnum.COMMIT_SUCCESS.getCode().equals(item.getSapTransferCommitStatus())) {
                throw new IllegalArgumentException("单据[" + item.getPaymentReceiptCode() + "]"
                        + "推送SAP成功,不能删除!");
            }
        });

        this.paymentReceiptRepository.updateDelStatusById(ids, DelFlagStatusEnum.DELETE.getCode());
        AbstractCrmUserIdentity userIdentity = loginUserService.getAbstractLoginUser();
        entityList.forEach(item -> {
            //删除业务日志
            PaymentReceiptLogEventDto logEventDto = new PaymentReceiptLogEventDto();
            PaymentReceiptVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(item, PaymentReceiptVo.class, null, null);
            logEventDto.setOriginal(oldVo);
            PaymentReceiptDto newDto = this.nebulaToolkitService.copyObjectByWhiteList(item, PaymentReceiptDto.class, null, null);
            newDto.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            newDto.setModifyName(userIdentity.getRealName());
            newDto.setModifyAccount(userIdentity.getUsername());
            newDto.setModifyTime(new Date());
            logEventDto.setNewest(newDto);
            SerializableBiConsumer<PaymentReceiptEventListener, PaymentReceiptLogEventDto> onDelete =
                    PaymentReceiptEventListener::onDelete;
            this.nebulaNetEventClient.publish(logEventDto, PaymentReceiptEventListener.class, onDelete);
        });
    }

    /**
     * 启用
     *
     * @param ids 主键列表
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void enableBatch(List<String> ids) {
        Validate.isTrue(!CollectionUtils.isEmpty(ids), "请选择要操作的数据");
        List<PaymentReceipt> entityList = this.paymentReceiptRepository.lambdaQuery()
                .eq(PaymentReceipt::getTenantCode, TenantUtils.getTenantCode())
                .in(PaymentReceipt::getId, ids)
                .list();
        if (CollectionUtils.isEmpty(entityList)) {
            return;
        }
        ArrayList<PaymentReceipt> entitys = new ArrayList<>();
        entityList.forEach(item -> {
            PaymentReceipt entity = new PaymentReceipt();
            entity.setId(item.getId());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            entitys.add(entity);

            //启用业务日志
            PaymentReceiptLogEventDto logEventDto = new PaymentReceiptLogEventDto();
            PaymentReceiptVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(item, PaymentReceiptVo.class, null, null);
            logEventDto.setOriginal(oldVo);
            PaymentReceiptDto newDto = this.nebulaToolkitService.copyObjectByWhiteList(item, PaymentReceiptDto.class, null, null);
            newDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            logEventDto.setNewest(newDto);
            SerializableBiConsumer<PaymentReceiptEventListener, PaymentReceiptLogEventDto> onEnable =
                    PaymentReceiptEventListener::onEnable;
            this.nebulaNetEventClient.publish(logEventDto, PaymentReceiptEventListener.class, onEnable);
        });
        this.paymentReceiptRepository.updateBatchById(entitys);
    }

    /**
     * 禁用
     *
     * @param ids 主键列表
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void disableBatch(List<String> ids) {
        Validate.isTrue(!CollectionUtils.isEmpty(ids), "请选择要操作的数据");
        List<PaymentReceipt> entityList = this.paymentReceiptRepository.lambdaQuery()
                .eq(PaymentReceipt::getTenantCode, TenantUtils.getTenantCode())
                .in(PaymentReceipt::getId, ids)
                .list();
        if (CollectionUtils.isEmpty(entityList)) {
            return;
        }
        ArrayList<PaymentReceipt> entitys = new ArrayList<>();
        entityList.forEach(item -> {
            PaymentReceipt entity = new PaymentReceipt();
            entity.setId(item.getId());
            entity.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            entitys.add(entity);

            //启用业务日志
            PaymentReceiptLogEventDto logEventDto = new PaymentReceiptLogEventDto();
            PaymentReceiptVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(item, PaymentReceiptVo.class, null, null);
            logEventDto.setOriginal(oldVo);
            PaymentReceiptDto newDto = this.nebulaToolkitService.copyObjectByWhiteList(item, PaymentReceiptDto.class, null, null);
            newDto.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            logEventDto.setNewest(newDto);
            SerializableBiConsumer<PaymentReceiptEventListener, PaymentReceiptLogEventDto> onDisable =
                    PaymentReceiptEventListener::onDisable;
            this.nebulaNetEventClient.publish(logEventDto, PaymentReceiptEventListener.class, onDisable);
        });
        this.paymentReceiptRepository.updateBatchById(entitys);
    }

    /**
     * 根据核销明细编码,获取应付明细详细数据
     *
     * @param codeList 主键列表
     * @return 应付明细详细数据列表
     */
    @Override
    public LinkedList<PaymentReceiptShouldVo> getShouldDetailData(LinkedList<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Lists.newLinkedList();
        }
        //获取核销明细数据
        List<AuditSupplierDetailVo> auditList = auditService.getSupplierDetailByCodes(codeList);
        if (CollectionUtils.isEmpty(auditList)) {
            return Lists.newLinkedList();
        }
        Map<String, AuditSupplierDetailVo> auditMap = auditList.stream().filter(i -> StringUtils.isNotBlank(i.getSupplierCode()))
                .collect(Collectors.toMap(AuditSupplierDetailVo::getSupplierCode, Function.identity()));
        List<String> supplierCodes = new ArrayList<>(auditMap.keySet());
        //获取供应商基本信息
        List<SupplierVo> supplierVoList = supplierVoService.findBySupplierCodes(supplierCodes);
        Map<String, SupplierVo> supplierVoMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(supplierVoList)) {
            supplierVoMap = supplierVoList.stream().filter(i -> StringUtils.isNotBlank(i.getSupplierCode()))
                    .collect(Collectors.toMap(SupplierVo::getSupplierCode, Function.identity()));
        }

        //组装数据，根据编码顺序组装
        LinkedList<PaymentReceiptShouldVo> voLinkedList = new LinkedList<>();
        for (String s : codeList) {
            if (!auditMap.containsKey(s)) {
                continue;
            }
            PaymentReceiptShouldVo shouldVo = new PaymentReceiptShouldVo();
            AuditSupplierDetailVo audit = auditMap.get(s);
            shouldVo.setAuditCode(audit.getAuditCode());
            if (null == audit.getThisEndCaseTaxAmount()) {
                shouldVo.setShouldPayMoney(BigDecimal.ZERO);
            } else {
                shouldVo.setShouldPayMoney(audit.getThisEndCaseTaxAmount());
            }

            if (supplierVoMap.containsKey(audit.getSupplierCode())) {
                SupplierVo sVo = supplierVoMap.get(audit.getSupplierCode());
                shouldVo.setMerchantsCode(sVo.getSupplierCode());
                shouldVo.setMerchantsName(sVo.getSupplierName());
                shouldVo.setMerchantsTwoCode(sVo.getSupplierCode());
                shouldVo.setMerchantsTwoName(sVo.getSupplierName());
                shouldVo.setAccountName(sVo.getContactName());
                shouldVo.setCollectionAccount(sVo.getBankCard());
                shouldVo.setAccountBank(sVo.getBankAccount());
                shouldVo.setUnionPayAccount(sVo.getUnionPayBankCard());
            }
//            shouldVo.setAssessDeductionMoney(checkMap.getOrDefault(audit.getSupplierCode(), BigDecimal.ZERO));
            shouldVo.setPrepaidMoney(BigDecimal.ZERO);
            shouldVo.setNowShouldPayMoney(shouldVo.getShouldPayMoney().subtract(shouldVo.getPrepaidMoney()));

            shouldVo.setMerchantsType("供应商");
            shouldVo.setPaymentNature("退款");
            shouldVo.setMailNoticePerson("测试接收人");
            shouldVo.setDateUnit("天");
            voLinkedList.add(shouldVo);
        }
        return voLinkedList;
    }

    /**
     * 分页查询可付款的核销付款信息
     *
     * @param pageable 分页对象
     * @param dto      查询dto
     * @return 所有数据
     */
    @Override
    public Page<PaymentReceiptShouldVo> findAuditPayByConditions(Pageable pageable, PaymentReceiptAuditPayDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(dto)) {
            dto = new PaymentReceiptAuditPayDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<PaymentReceiptShouldVo> result = this.paymentReceiptShouldRepository.findAuditPayByConditions(pageable, dto);
        if (CollectionUtils.isEmpty(result.getRecords())) {
            return result;
        }
        for (PaymentReceiptShouldVo record : result.getRecords()) {
            record.setShouldPayMoney(Optional.ofNullable(record.getShouldPayMoney()).orElse(BigDecimal.ZERO));
            record.setPrepaidMoney(Optional.ofNullable(record.getPrepaidMoney()).orElse(BigDecimal.ZERO));
            record.setAlreadyMoney(Optional.ofNullable(record.getAlreadyMoney()).orElse(BigDecimal.ZERO));
            record.setId(record.getAuditPayCode());
            record.setMerchantsType(MerchantsTypeEnum.SUPPLIER.getCode());
            record.setPaymentNature(PaymentNatureTypeEnum.OTHER.getCode());
            record.setSuppliersCode(record.getMerchantsCode());
            record.setSuppliersName(record.getMerchantsName());
            record.setMerchantsTwoCode(record.getMerchantsCode());
            record.setMerchantsTwoName(record.getMerchantsName());
            record.setDateUnit(DateUnitTypeEnum.DAY.getCode());
            record.setNowShouldPayMoney(record.getShouldPayMoney().subtract(record.getPrepaidMoney()).subtract(record.getAlreadyMoney()));
            record.setPendingMoney(record.getShouldPayMoney().subtract(record.getPrepaidMoney()).subtract(record.getAlreadyMoney()));
            record.setAuditMoney(record.getShouldPayMoney());
        }
        return result;
    }

    /**
     * 分页查询可付款的核销付款信息
     *
     * @param pageable 分页对象
     * @param dto      查询dto
     * @return 所有数据
     */
    @Override
    public Page<PaymentReceiptShouldVo> findAuditPayByConditionsWithoutPayType(Pageable pageable, PaymentReceiptAuditPayDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(dto)) {
            dto = new PaymentReceiptAuditPayDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<PaymentReceiptShouldVo> result = this.paymentReceiptShouldRepository.findAuditPayByConditionsWithoutPayType(pageable, dto);
        if (CollectionUtils.isEmpty(result.getRecords())) {
            return result;
        }
        for (PaymentReceiptShouldVo record : result.getRecords()) {
            record.setShouldPayMoney(Optional.ofNullable(record.getShouldPayMoney()).orElse(BigDecimal.ZERO));
            record.setPrepaidMoney(Optional.ofNullable(record.getPrepaidMoney()).orElse(BigDecimal.ZERO));
            record.setAlreadyMoney(Optional.ofNullable(record.getAlreadyMoney()).orElse(BigDecimal.ZERO));
            record.setId(record.getAuditPayCode());
            record.setMerchantsType(MerchantsTypeEnum.SUPPLIER.getCode());
            record.setPaymentNature(PaymentNatureTypeEnum.OTHER.getCode());
            record.setSuppliersCode(record.getMerchantsCode());
            record.setSuppliersName(record.getMerchantsName());
            record.setMerchantsTwoCode(record.getMerchantsCode());
            record.setMerchantsTwoName(record.getMerchantsName());
            record.setDateUnit(DateUnitTypeEnum.DAY.getCode());
            record.setNowShouldPayMoney(record.getShouldPayMoney().subtract(record.getPrepaidMoney()).subtract(record.getAlreadyMoney()));
            record.setPendingMoney(record.getShouldPayMoney().subtract(record.getPrepaidMoney()).subtract(record.getAlreadyMoney()));
            record.setAuditMoney(record.getShouldPayMoney());
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Result<String> pushPaymentReceiptToCe(PaymentReceiptVo paymentReceiptVo) {

        PaymentReceiptApplyDto paymentReceiptApplyDto = new PaymentReceiptApplyDto();

        //抬头构建
        PaymentReceiptHeadDto headDto = new PaymentReceiptHeadDto();
        //        //数据来源 固定4
        headDto.setDataFrom(DATA_FROM);
        headDto.setIsStartProcess(BooleanEnum.FALSE.getCapital());
        headDto.setOutDocument(paymentReceiptVo.getPaymentReceiptCode());
        headDto.setBukrs(paymentReceiptVo.getCompanyCode());
        //业务大类   付款单固定 300203
        headDto.setTitle(TITLE);
        //利润中心
        String profitCenterCode = paymentReceiptVo.getProfitCenterCode();
        if (StringUtils.isNotBlank(profitCenterCode) && profitCenterCode.startsWith(PROFIT_CENTER_PREFIX)) {
            profitCenterCode = profitCenterCode.replace(PROFIT_CENTER_PREFIX, "");
        }
        headDto.setPrctr(profitCenterCode);
        //业务细类
        headDto.setExpItem(paymentReceiptVo.getPayItemType());
        headDto.setExpItemTxt(paymentReceiptVo.getPayItemType());
        //交易货币
        headDto.setCurrency(paymentReceiptVo.getTradeCurrency());
        headDto.setRate(new BigDecimal(paymentReceiptVo.getExchangeRate()).setScale(2, BigDecimal.ROUND_DOWN));
        //经办人工号
        headDto.setCreatedBy(paymentReceiptVo.getCreateAccount());
        //报账人工号
        headDto.setApplicantNo(paymentReceiptVo.getCreateAccount());
        //付款方式
        headDto.setPayType(paymentReceiptVo.getPayWay());
        //审核部门
        headDto.setUseamtDept(paymentReceiptVo.getAuditDepart());
        headDto.setApprAmount(new BigDecimal(paymentReceiptVo.getPayTotalMoney()).setScale(2, BigDecimal.ROUND_DOWN));
        //是否有合同
        headDto.setHasContract(paymentReceiptVo.getIsHaveContract());
        //合同编码
        headDto.setDescription(paymentReceiptVo.getSpendingContent());

        paymentReceiptApplyDto.setHead(headDto);


        //费用明细列表
        List<PaymentReceiptFeeDetailDto> fees = new ArrayList<>();
        if (CollectionUtil.isNotEmpty(paymentReceiptVo.getShouldList())) {
            for (int i = 0; i < paymentReceiptVo.getShouldList().size(); i++) {
                PaymentReceiptFeeDetailDto paymentReceiptFeeDetailDto = new PaymentReceiptFeeDetailDto();
                PaymentReceiptShouldVo paymentReceiptShouldVo = paymentReceiptVo.getShouldList().get(i);
                paymentReceiptFeeDetailDto.setSeq(i + 1);
                paymentReceiptFeeDetailDto.setReserve(paymentReceiptShouldVo.getId());
                paymentReceiptFeeDetailDto.setAccountType(PaymentReceiptConstants.ACCOUNT_TYPE);
                paymentReceiptFeeDetailDto.setLifnr(paymentReceiptShouldVo.getMerchantsCode());
                paymentReceiptFeeDetailDto.setLifnrTxt(paymentReceiptShouldVo.getMerchantsName());
                paymentReceiptFeeDetailDto.setBankl(paymentReceiptShouldVo.getUnionPayAccount());
                paymentReceiptFeeDetailDto.setBanka(paymentReceiptShouldVo.getAccountBank());
                paymentReceiptFeeDetailDto.setBankn(paymentReceiptShouldVo.getCollectionAccount());
                paymentReceiptFeeDetailDto.setKoinh(paymentReceiptShouldVo.getAccountName());
                paymentReceiptFeeDetailDto.setLifnr1(paymentReceiptShouldVo.getMerchantsTwoCode());
                paymentReceiptFeeDetailDto.setLifnrTxt1(paymentReceiptShouldVo.getMerchantsTwoName());
                paymentReceiptFeeDetailDto.setCutAmt(paymentReceiptShouldVo.getAssessDeductionMoney() == null ? null : paymentReceiptShouldVo.getAssessDeductionMoney().setScale(2, BigDecimal.ROUND_DOWN));
                paymentReceiptFeeDetailDto.setPayAmount(paymentReceiptShouldVo.getNowShouldPayMoney() == null ? null : paymentReceiptShouldVo.getNowShouldPayMoney().setScale(2, BigDecimal.ROUND_DOWN));
                paymentReceiptFeeDetailDto.setHopePayDate(paymentReceiptShouldVo.getExpectPayDate() == null ? null : DateUtil.formatDate(paymentReceiptShouldVo.getExpectPayDate()));
                paymentReceiptFeeDetailDto.setContract(paymentReceiptShouldVo.getContractCode());
                paymentReceiptFeeDetailDto.setContractName(paymentReceiptShouldVo.getContractName());
                paymentReceiptFeeDetailDto.setBanpiaots(paymentReceiptShouldVo.getBillDate());
                fees.add(paymentReceiptFeeDetailDto);
            }
        }

        paymentReceiptApplyDto.setFees(fees);

        //付款明细列表
        List<PaymentReceiptDetailDto> details = new ArrayList<>();
        if (CollectionUtil.isNotEmpty(paymentReceiptVo.getPayList())) {

            for (int i = 0; i < paymentReceiptVo.getPayList().size(); i++) {
                PaymentReceiptPayVo paymentReceiptPayVo = paymentReceiptVo.getPayList().get(i);

                PaymentReceiptDetailDto paymentReceiptDetailDto = new PaymentReceiptDetailDto();
                paymentReceiptDetailDto.setSeq(i + 1);
                paymentReceiptDetailDto.setPaymentDesc(paymentReceiptPayVo.getPaymentDigest());
                paymentReceiptDetailDto.setPaymentDescTxt(paymentReceiptPayVo.getPaymentDigestName());
                paymentReceiptDetailDto.setAmount(paymentReceiptPayVo.getNowShouldPayMoney() == null ? BigDecimal.ZERO : paymentReceiptPayVo.getNowShouldPayMoney().setScale(2, BigDecimal.ROUND_DOWN));
                String profitCenterCodeDetail = paymentReceiptPayVo.getProfitCenter();
                if (StringUtils.isNotBlank(profitCenterCodeDetail) && profitCenterCodeDetail.startsWith(PROFIT_CENTER_PREFIX)) {
                    profitCenterCodeDetail = profitCenterCodeDetail.replace(PROFIT_CENTER_PREFIX, "");
                }
                paymentReceiptDetailDto.setPrctr(profitCenterCodeDetail);
                paymentReceiptDetailDto.setFundOutputProject(paymentReceiptPayVo.getCapitalOutflowProject());
                paymentReceiptDetailDto.setFundOutputProjectTxt(paymentReceiptPayVo.getCapitalOutflowProjectName());
                paymentReceiptDetailDto.setReason(paymentReceiptPayVo.getReasonCode());
                paymentReceiptDetailDto.setReasonTxt(paymentReceiptPayVo.getReasonName());
                paymentReceiptDetailDto.setReserve(paymentReceiptPayVo.getId());
                details.add(paymentReceiptDetailDto);
            }
        }
        paymentReceiptApplyDto.setDetails(details);


        //文件列表
        List<com.biz.crm.mn.third.system.sd.sdk.dto.PaymentReceiptFileDto> fileDtoList = new ArrayList<>();
        if (CollectionUtil.isNotEmpty(paymentReceiptVo.getFileList())) {

            for (int i = 0; i < paymentReceiptVo.getFileList().size(); i++) {
                PaymentReceiptFileVo vo = paymentReceiptVo.getFileList().get(i);

                com.biz.crm.mn.third.system.sd.sdk.dto.PaymentReceiptFileDto paymentReceiptFileDto = new com.biz.crm.mn.third.system.sd.sdk.dto.PaymentReceiptFileDto();
                paymentReceiptFileDto.setDisplayName(vo.getOriginalFileName());
                paymentReceiptFileDto.setFileName(vo.getOriginalFileName());
                fileDtoList.add(paymentReceiptFileDto);
            }
        }
        paymentReceiptApplyDto.setFiles(fileDtoList);
        Result<String> resultData = new Result<>();
        resultData.error401("SAP返回为空");
        log.info("推送CE接口开始 参数【{}】", JSON.toJSONString(paymentReceiptApplyDto));
        Result<PaymentReceiptResultVo> sapResult = sapSdApiService.pushPaymentReceipt(paymentReceiptApplyDto);
        log.info("推送CE接口结束 响应【{}】", JSON.toJSONString(sapResult));
        String paymentReceiptCode = paymentReceiptVo.getPaymentReceiptCode();
        AtomicReference<String> commitSuccessCode = new AtomicReference<>(CommitStatusEnum.COMMIT_FAIL.getCode());
        if (sapResult.isSuccess()) {
            PaymentReceiptResultVo result = sapResult.getResult();
            if (StringUtils.equals(result.getMsgCode(), RequestCERespCodeEnum.SUCCESS.getCode())) {
                log.info("推送CE接口成功[{}]", paymentReceiptCode);
                Optional<String> stringOptional = Optional.ofNullable(sapResult.getResult())
                        .map(PaymentReceiptResultVo::getProcessInstanceId);
                stringOptional.ifPresent(x -> {
                    resultData.setSuccess(true);
                    resultData.setResult(x);
                    resultData.setMessage(CommitStatusEnum.COMMIT_SUCCESS.getDesc());
                    commitSuccessCode.set(CommitStatusEnum.COMMIT_SUCCESS.getCode());
                });
            } else {
                resultData.error401(result.getMsg());
            }
        } else {
            resultData.error401(sapResult.getMessage());
        }
        log.info("推送CE接口单号[{}],结果[{}]", paymentReceiptCode, resultData);
        String msg = resultData.getMessage();
        if (StringUtils.isNotEmpty(msg)
                && msg.length() > 330) {
            msg = msg.substring(0, 330);
        }
        this.paymentReceiptRepository.lambdaUpdate()
                .eq(PaymentReceipt::getPaymentReceiptCode, paymentReceiptCode)
                .set(StringUtils.isNotEmpty(resultData.getResult()), PaymentReceipt::getCeDocumentNumber, resultData.getResult())
                .set(PaymentReceipt::getCeCommitMessage, msg)
                .set(PaymentReceipt::getCeCommitStatus, commitSuccessCode.get())
                .update();
        return resultData;
    }

    @Override
    public Map<String, String> pushPaymentReceiptToCE(List<String> ids) {
        Validate.isTrue(!CollectionUtils.isEmpty(ids), "请选择数据");
        List<PaymentReceiptVo> receiptVos = this.findByIds(ids);
        Validate.isTrue(!CollectionUtils.isEmpty(receiptVos), "付款单不存在");

        Map<String, String> failMap = new HashMap<>();
        for (PaymentReceiptVo receiptVo : receiptVos) {
            //验证单据是否审批通过
            if (!StringUtils.equals(ProcessStatusEnum.PASS.getDictCode(), receiptVo.getProcessState())) {
                failMap.put(receiptVo.getPaymentReceiptCode(), "未审批通过");
                continue;
            }
            //验证是否保理
            if (StringUtils.equals(YesOrNoEnum.YES.getCode(), receiptVo.getIsFactoring())) {
                //验证SAP推送状态
                if (StringUtils.equals(CommitStatusEnum.COMMIT_SUCCESS.getCode(), receiptVo.getSapTransferCommitStatus())) {
                    failMap.put(receiptVo.getPaymentReceiptCode(), "不需要推送CE");
                    continue;
                }
            }
            //推送CE
            Result<String> result = this.pushPaymentReceiptToCe(receiptVo);
            if (result.isSuccess()) {
                receiptVo.setCeCommitStatus(CommitStatusEnum.COMMIT_SUCCESS.getCode());
                receiptVo.setCeDocumentNumber(result.getResult());
            } else {
                receiptVo.setCeCommitStatus(CommitStatusEnum.COMMIT_FAIL.getCode());
            }
            receiptVo.setCeCommitMessage(result.getMessage());
            //业务日志
            PaymentReceiptDto paymentReceiptDto = this.nebulaToolkitService.copyObjectByWhiteList(receiptVo, PaymentReceiptDto.class, null, null);
            PaymentReceiptLogEventDto logEventDto = new PaymentReceiptLogEventDto();
            logEventDto.setOriginal(receiptVo);
            logEventDto.setNewest(paymentReceiptDto);
            SerializableBiConsumer<PaymentReceiptEventListener, PaymentReceiptLogEventDto> onUpdate =
                    PaymentReceiptEventListener::onUpdate;
            this.nebulaNetEventClient.publish(logEventDto, PaymentReceiptEventListener.class, onUpdate);
        }
        return failMap;
    }

    @Override
    public Map<String, String> pushPaymentReceiptToSAP(List<String> ids) {
        Validate.notEmpty(ids, "请选择数据");
        List<PaymentReceiptVo> receiptVos = this.findByIds(ids);
        Validate.notEmpty(receiptVos, "付款单不存在");
        Map<String, String> resultMap = new HashMap<>();
        for (PaymentReceiptVo receiptVo : receiptVos) {
            //验证单据是否审批通过
            if (!StringUtils.equals(ProcessStatusEnum.PASS.getDictCode(), receiptVo.getProcessState())) {
                resultMap.put(receiptVo.getPaymentReceiptCode(), "未审批通过");
                continue;
            }
            if (StringUtils.equals(YesOrNoEnum.NO.getCode(), receiptVo.getIsFactoring())) {
                resultMap.put(receiptVo.getPaymentReceiptCode(), "不需要推送SAP");
                continue;
            }
            if (StringUtils.equals(CommitStatusEnum.COMMIT_SUCCESS.getCode(), receiptVo.getSapTransferCommitStatus())) {
                resultMap.put(receiptVo.getPaymentReceiptCode(), "不需要推送SAP");
                continue;
            }

            PaymentReceiptDto paymentReceiptDto = this.nebulaToolkitService.copyObjectByWhiteList(receiptVo, PaymentReceiptDto.class, null, null);

            //推送SAP
            Result<String> sapResult = this.pushPaymentReceiptToSAP(receiptVo);
            receiptVo.setSapTransferCommitMessage(sapResult.getMessage());
            if (sapResult.isSuccess()) {
                paymentReceiptDto.setSapTransferBelnr(sapResult.getResult());
                paymentReceiptDto.setSapTransferCommitStatus(CommitStatusEnum.COMMIT_SUCCESS.getCode());

                //推送成功自动推送CE
                Result<String> ceResult = this.pushPaymentReceiptToCe(receiptVo);
                if (ceResult.isSuccess()) {
                    paymentReceiptDto.setCeCommitStatus(CommitStatusEnum.COMMIT_SUCCESS.getCode());
                    paymentReceiptDto.setCeDocumentNumber(sapResult.getResult());
                } else {
                    paymentReceiptDto.setCeCommitStatus(CommitStatusEnum.COMMIT_FAIL.getCode());
                    resultMap.put(receiptVo.getPaymentReceiptCode(), "推送CE失败");
                }
                paymentReceiptDto.setCeCommitMessage(ceResult.getMessage());
            } else {
                paymentReceiptDto.setSapTransferCommitStatus(CommitStatusEnum.COMMIT_FAIL.getCode());
                resultMap.put(receiptVo.getPaymentReceiptCode(), "推送SAP失败");
            }
            paymentReceiptDto.setSapTransferCommitMessage(sapResult.getMessage());

            //业务日志
            PaymentReceiptLogEventDto logEventDto = new PaymentReceiptLogEventDto();
            logEventDto.setOriginal(receiptVo);
            logEventDto.setNewest(paymentReceiptDto);
            SerializableBiConsumer<PaymentReceiptEventListener, PaymentReceiptLogEventDto> onUpdate =
                    PaymentReceiptEventListener::onUpdate;
            this.nebulaNetEventClient.publish(logEventDto, PaymentReceiptEventListener.class, onUpdate);
        }
        //更新推送状态
        return resultMap;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Result<String> pushPaymentReceiptToSAP(PaymentReceiptVo paymentReceiptVo) {
        log.info("推送SAP 参数：【{}】", JSON.toJSONString(paymentReceiptVo));
        AbstractCrmUserIdentity abstractLoginUser = loginUserService.getAbstractLoginUser();
        LinkedList<PaymentReceiptShouldVo> shouldList = paymentReceiptVo.getShouldList();
        Result<String> resultData = new Result<>();
        if (CollectionUtils.isEmpty(shouldList)) {
            resultData.error401("无可推送数据!!");
            return resultData;
        }
        log.info("应付列表 【{}】 条数:[{}]", JSON.toJSONString(shouldList), shouldList.size());
        //主体
        AccountingVoucherDto accountingVoucherDto = new AccountingVoucherDto();
        AccountingVoucherDto.ItData itData = new AccountingVoucherDto.ItData();
        accountingVoucherDto.setIT_DATA(itData);
        List<AccountingVoucherDto.ItData.Item> itemList = new ArrayList<>();
        for (PaymentReceiptShouldVo shouldVo : shouldList) {
            //item1 费用
            AccountingVoucherDto.ItData.Item item1 = new AccountingVoucherDto.ItData.Item();
            //SAP使用此字段删重
            item1.setACC_ID(paymentReceiptVo.getSapTransferCertCode());
            item1.setTPID(paymentReceiptVo.getPaymentReceiptCode());
            item1.setOBJECT_ID(paymentReceiptVo.getPaymentReceiptCode());
            //sap公司代码
            item1.setBUKRS(paymentReceiptVo.getCompanyCode());
//            发票数量
            item1.setINVOCE_NUM("1");
            //用户名
            item1.setUSNAM(abstractLoginUser.getUsername());
            //FLH的规则：费用传1 进项税传2 客户传3
            item1.setFLH("3");
            //记账代码 21 借方 31 贷方
            item1.setBSCHL("21");
            //金额
            item1.setAMOUNT(shouldVo.getNowShouldPayMoney().toPlainString());
            // 利润中心
            item1.setPRCTR(paymentReceiptVo.getProfitCenterCode());
            //客户编号
            item1.setKUNNR(shouldVo.getFactoringCode());
            itemList.add(item1);

            AccountingVoucherDto.ItData.Item item2 = new AccountingVoucherDto.ItData.Item();
            //SAP使用此字段删重
            item2.setACC_ID(paymentReceiptVo.getSapTransferCertCode());
            item2.setTPID(paymentReceiptVo.getPaymentReceiptCode());
            item2.setOBJECT_ID(paymentReceiptVo.getPaymentReceiptCode());
            //sap公司代码
            item2.setBUKRS(paymentReceiptVo.getCompanyCode());
            //            发票数量
            item2.setINVOCE_NUM("1");
            //用户名
            item2.setUSNAM(abstractLoginUser.getUsername());
            //FLH的规则：费用传1 进项税传2 客户传3
            item2.setFLH("3");
            //记账代码 40
            item2.setBSCHL("31");
            //金额 (报销含税)
            item2.setAMOUNT("-" + shouldVo.getNowShouldPayMoney().toPlainString());
            // 利润中心
            item2.setPRCTR(paymentReceiptVo.getProfitCenterCode());
            //客户编号
            item2.setKUNNR(shouldVo.getSuppliersCode());

            itemList.add(item2);
            itData.setItem(itemList);
        }
        log.info("调用推送SAP接口开始 参数【{}】", JSON.toJSONString(accountingVoucherDto));
        SapAccountingVoucherVo sapAccountingVoucherVo = sapCenterService.pushSapAccountingVoucher(accountingVoucherDto);
        log.info("调用推送SAP接口结束 响应【{}】", JSON.toJSONString(sapAccountingVoucherVo));
        StringBuilder message = new StringBuilder();
        UpAccountVo upAccountVo = new UpAccountVo();
        resultData.error401("SAP返回结果为空!");
        String paymentReceiptCode = paymentReceiptVo.getPaymentReceiptCode();
        String commitSuccessCode = CommitStatusEnum.COMMIT_FAIL.getCode();
        if (Objects.nonNull(sapAccountingVoucherVo)
                && Objects.nonNull(sapAccountingVoucherVo.getET_BELNR())) {
            if (CollectionUtil.isNotEmpty(sapAccountingVoucherVo.getET_BELNR().getItem())) {
                for (SapAccountingVoucherVo.EtBelnr.Item item : sapAccountingVoucherVo.getET_BELNR().getItem()) {
                    upAccountVo.setBelnr(item.getBELNR());
                    upAccountVo.setBukrs(item.getBUKRS());
                    upAccountVo.setGjahr(item.getGJAHR());
                }
                resultData.setSuccess(true);
                resultData.setMessage("推送SAP成功.");
                resultData.setResult(upAccountVo.getBelnr());
                commitSuccessCode = CommitStatusEnum.COMMIT_SUCCESS.getCode();
            } else if (CollectionUtil.isNotEmpty(sapAccountingVoucherVo.getET_MESSAGE().getItem())) {
                for (SapAccountingVoucherVo.EtMessage.Item item : sapAccountingVoucherVo.getET_MESSAGE().getItem()) {
                    if (SuccessAndFailEnum.FAIL.getCode().equals(item.getTYPE())) {
                        if (StringUtils.isNotEmpty(message.toString())) {
                            message.append("||");
                        }
                        message.append(item.getMESSAGE());
                    }
                }
                if (StringUtils.isEmpty(message.toString())) {
                    message.append("推送SAP失败,SAP未返回错误信息!");
                }
                log.error("付款单推送SAP失败 ========》【{}】《=========", message.toString());
                resultData.setSuccess(false);
                resultData.error401(message.toString());
            }
        }
        String msg = resultData.getMessage();
        if (StringUtils.isNotEmpty(msg)
                && msg.length() > 330) {
            msg = msg.substring(0, 330);
        }
        this.paymentReceiptRepository.lambdaUpdate()
                .eq(PaymentReceipt::getPaymentReceiptCode, paymentReceiptCode)
                .set(StringUtils.isNotEmpty(resultData.getResult()),
                        PaymentReceipt::getSapTransferBelnr, resultData.getResult())
                .set(PaymentReceipt::getSapTransferCommitStatus, commitSuccessCode)
                .set(PaymentReceipt::getSapTransferCommitMessage, msg)
                .update();
        return resultData;
    }

    @Override
    public void queryPaymentReceiptECStatus(PaymentReceiptQueryStatusDto paymentReceiptQueryStatusDto) {
        //异步推送数据
        MqMessageVo mqMessage = new MqMessageVo();
        //数据
        mqMessage.setMsgBody(JsonUtils.obj2JsonString(paymentReceiptQueryStatusDto));
        //MQ标签
        mqMessage.setTag(PaymentReceiptConstants.TPM_PAYMENT_RECEIPT_QUERY_CE_STATUS_TAG);
        mqMessage.setTopic(PaymentReceiptConstants.TPM_PAYMENT_RECEIPT_QUERY_CE_STATUS_TOPIC.concat(rocketmqEnvironment));
        rocketMqProducer.sendMqMsg(mqMessage);
    }

    @Override
    public void syncQueryPaymentReceiptECStatus(String dto) {
        log.info("付款单异步查询CE状态开始 参数【{}】", dto);
        PaymentReceiptQueryStatusDto queryStatusDto = JSONObject.parseObject(dto, PaymentReceiptQueryStatusDto.class);
        Result<PaymentReceiptStatusResultVo> paymentReceiptStatusResultVoResult = this.sapSdApiService.queryPaymentReceiptStatus(queryStatusDto);
        log.info("付款单异步查询CE状态结果 【{}】", JSON.toJSONString(paymentReceiptStatusResultVoResult));
        Validate.isTrue(Objects.nonNull(paymentReceiptStatusResultVoResult), "查询CE状态失败");
        PaymentReceiptStatusResultVo result = paymentReceiptStatusResultVoResult.getResult();
        List<PaymentReceiptStatusDetailVo> vos = JSONObject.parseArray(JSON.toJSONString(result.getDetails()), PaymentReceiptStatusDetailVo.class);
        Validate.isTrue(!CollectionUtils.isEmpty(vos), "未查询到数据");
        List<String> codes = vos.stream().map(o -> o.getProcessInstanceId()).collect(Collectors.toList());
        List<PaymentReceipt> paymentReceipts = this.paymentReceiptRepository.lambdaQuery()
                .in(PaymentReceipt::getCeDocumentNumber, codes)
                .eq(PaymentReceipt::getTenantCode, TenantUtils.getTenantCode())
                .eq(PaymentReceipt::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
        if (CollectionUtils.isEmpty(paymentReceipts)) {
            return;
        }
        Map<String, PaymentReceiptStatusDetailVo> voMap = vos.stream().collect(Collectors.toMap(PaymentReceiptStatusDetailVo::getProcessInstanceId, Function.identity()));
        for (PaymentReceipt receipt : paymentReceipts) {
            PaymentReceiptStatusDetailVo paymentReceiptStatusDetailVo = voMap.get(receipt.getCeDocumentNumber());
            if (Objects.nonNull(paymentReceiptStatusDetailVo)) {
                this.constructPaymentReceipt(receipt, paymentReceiptStatusDetailVo);
            }
        }
        this.paymentReceiptRepository.updateBatchById(paymentReceipts);
    }

    @Override
    public ReimburseFundsReasonMappingVo findReimburseFundsReasonMappingByCode(String code) {
        ReimburseFundsReasonMapping entity = this.reimburseFundsReasonMappingRepository.findReimburseFundsReasonMappingByCode(code);
        if(entity == null){
            return null;
        }
        return nebulaToolkitService.copyObjectByWhiteList(entity, ReimburseFundsReasonMappingVo.class, LinkedHashSet.class, ArrayList.class);
    }

    @Override
    public PaymentReceiptVo getPaymentReceiptByAuditCode(String auditCode) {
        Validate.notBlank(auditCode, "核销编码不能为空");
        PaymentReceiptVo paymentReceipt = getPaymentReceiptInfoByAuditCode(auditCode);
        if (ObjectUtil.isNotEmpty(paymentReceipt)) {
            return paymentReceipt;
        }

        //当前登陆信息
        AbstractCrmUserIdentity abstractLoginUser = loginUserService.getAbstractLoginUser();
        //付款信息
        paymentReceipt = new PaymentReceiptVo();
        LinkedList<PaymentReceiptAuditItemVo> auditItemList = Lists.newLinkedList();
        LinkedList<PaymentReceiptShouldVo> shouldList = Lists.newLinkedList();
        LinkedList<PaymentReceiptPayVo> payList = Lists.newLinkedList();
        //查询核销信息
        AuditVo auditVo = this.auditService.findByAuditCode(auditCode);
        Validate.notNull(auditVo, "核销信息未找到");
        //根据核销编码查询核销明细信息
        List<AuditCustomerDetailCollection> detailCollectionList = auditCustomerDetailCollectionRepository.findByAuditCode(auditCode);
        //付款单主信息
        paymentReceiptHandle(paymentReceipt, auditVo, abstractLoginUser);
        //核销明细
        paymentAuditDetailHandle(auditItemList, detailCollectionList, auditVo);
        //应付信息
        shouldList = paymentReceiptShouldHandle(auditCode);
        //支付明细
        paymentReceiptPayHandle(detailCollectionList, payList, shouldList);

        paymentReceipt.setAuditItemList(auditItemList);
        paymentReceipt.setShouldList(shouldList);
        paymentReceipt.setPayList(payList);
        StringBuilder sb = new StringBuilder();
        sb.append(paymentReceipt.getApplyDepartName());
        sb.append(abstractLoginUser.getRealName());
        sb.append("报销");
        shouldList.forEach(o -> sb.append(o.getReimburseItemName()).append("/"));
        paymentReceipt.setSpendingContent(sb.toString());
        //计算总金额
        computeTotalAmount(paymentReceipt, auditItemList);
        paymentReceiptOtherAssignment(paymentReceipt, detailCollectionList);
        return paymentReceipt;

    }


    @Override
    public void updatePaymentReceiptProcess(PaymentReceiptDto paymentReceipt) {

        PaymentReceipt paymentReceiptEntity = this.paymentReceiptRepository
                .lambdaQuery()
                .eq(PaymentReceipt::getPaymentReceiptCode, paymentReceipt.getPaymentReceiptCode())
                .one();

        paymentReceiptEntity.setProcessNo(paymentReceipt.getProcessNo());
        paymentReceiptEntity.setPaySuccessDate(paymentReceipt.getPaySuccessDate());
        paymentReceiptEntity.setProcessState(paymentReceipt.getProcessState());
        this.paymentReceiptRepository.updateById(paymentReceiptEntity);
    }

    /**
     * 推送付款单
     *
     * @param id
     */
    @Override
    @Transactional
    public void autoPushPaymentReceipt(String id) {

        Validate.notBlank(id, "付款单ID不能为空");

        //获取付款单信息
        PaymentReceiptVo paymentReceiptVo = this.findById(id);
        Validate.notNull(paymentReceiptVo, "未查询到该付款单");

        //更改审批状态
//        this.paymentReceiptRepository.updateProcessStatus(paymentReceiptVo.getPaymentReceiptCode(),ProcessStatusEnum.PASS.getDictCode());

        //推送
        Boolean isSapSuccess = Boolean.FALSE;
        Boolean isCeSuccess = Boolean.FALSE;
        if (StringUtils.equals(YesOrNoEnum.YES.getCode(), paymentReceiptVo.getIsFactoring())) {
            //是挂账保理
            //先调用SAP-FICO 【上账调用促销费用凭证接口（ZM_ITF_ACC_DOCUMENT_CREATE）】，再调用CE付款单接口【TPM180-用款业务接口】
            Result<String> sapResult = this.pushPaymentReceiptToSAP(paymentReceiptVo);
            //推送CE
            if (isSapSuccess) {
                Result<String> ceResult = this.pushPaymentReceiptToCe(paymentReceiptVo);
            }
        } else {
            //不是挂账保理
            // 直接调用CE付款单接口【TPM180-用款业务接口】
            Result<String> ceResult = this.pushPaymentReceiptToCe(paymentReceiptVo);
        }

        //更新推送状态
        this.paymentReceiptRepository.updateSapTransferCommitStatusBatch(isSapSuccess ? CommitStatusEnum.COMMIT_SUCCESS : CommitStatusEnum.COMMIT_FAIL, Lists.newArrayList(paymentReceiptVo.getId()));
        this.paymentReceiptRepository.updateCECommitStatusBatch(isCeSuccess ? CommitStatusEnum.COMMIT_SUCCESS : CommitStatusEnum.COMMIT_FAIL, Lists.newArrayList(paymentReceiptVo.getId()));
    }

    @Override
    public List<PaymentReceiptShouldVo> findPaymentReceiptByAuditCode(List<String> auditCodes) {
        return this.paymentReceiptShouldRepository.findPaymentReceiptShouldByAudit(auditCodes);
    }

    @Override
    public void updatePaymentReceiptProcess(String processNo, String processStats, String paymentReceiptCode) {
        this.paymentReceiptRepository.updatePaymentReceiptProcess(processNo, processStats, paymentReceiptCode);
    }

    @Override
    public void paymentReceiptJoinProcess(String auditId) {

        if (CharSequenceUtil.isEmpty(auditId)) {
            return;
        }

        AuditVo auditVo = this.auditService.getAuditById(auditId);

        if (ObjectUtil.isNull(auditVo)) {
            return;
        }

        String whetherPay = auditVo.getWhetherPay();
        if (CharSequenceUtil.isEmpty(whetherPay) || !CharSequenceUtil.equals(whetherPay, YesOrNoEnum.YES.getCode())) {
            return;
        }

        String auditCode = auditVo.getAuditCode();

        List<PaymentReceiptShould> shouldList = this.paymentReceiptShouldRepository.findShouldByAuditCode(auditCode);
        if (CollUtil.isEmpty(shouldList)) {
            return;
        }
        List<String> paymentReceiptCodes = shouldList
                .stream()
                .filter(item ->
                        CharSequenceUtil.isNotEmpty(item.getPaymentReceiptCode()))
                .map(PaymentReceiptShould::getPaymentReceiptCode)
                .distinct()
                .collect(Collectors.toList());

        List<PaymentReceipt> receiptList = this.paymentReceiptRepository.findByCodes(paymentReceiptCodes);
        if (CollUtil.isEmpty(receiptList)) {
            return;
        }
        receiptList.forEach(item -> {
            item.setProcessNo(auditVo.getProcessNo());
            item.setProcessState(auditVo.getProcessStatus());
            item.setProcessStatus(auditVo.getProcessStatus());
        });

        this.paymentReceiptRepository.updateBatchById(receiptList);
    }

    @Override
    public List<PaymentReceiptShouldVo> findPaymentReceiptShouldByAuditCode(List<String> auditCodes) {

        List<PaymentReceiptShouldVo> list = new ArrayList<>();

        for (String auditCode : auditCodes) {
            List<PaymentReceiptShould> shouldList = this.paymentReceiptShouldRepository.findShouldByAuditCode(auditCode);
            if (CollUtil.isEmpty(shouldList)) {
                continue;
            }
            List<PaymentReceiptShouldVo> receiptShouldVoList = this.nebulaToolkitService
                    .copyCollectionByWhiteList(shouldList
                            , PaymentReceiptShould.class
                            , PaymentReceiptShouldVo.class
                            , HashSet.class
                            , ArrayList.class).stream().collect(Collectors.toList());
            list.addAll(receiptShouldVoList);
        }
        return list;
    }

    @Override
    public void deletePaymentReceiptByAuditCode(List<String> auditCodes) {

        if (CollUtil.isEmpty(auditCodes)) {
            return;
        }

        List<PaymentReceiptShould> shouldList = this.paymentReceiptShouldRepository.findShouldByAuditCodes(auditCodes);
        if (CollUtil.isEmpty(shouldList)) {
            return;
        }
        List<String> paymentReceiptCodes = shouldList
                .stream()
                .filter(item ->
                        CharSequenceUtil.isNotEmpty(item.getPaymentReceiptCode()))
                .map(PaymentReceiptShould::getPaymentReceiptCode)
                .distinct()
                .collect(Collectors.toList());

        List<String> canDeleteCodes = Lists.newArrayList();
        List<PaymentReceipt> paymentReceiptList = this.paymentReceiptRepository.findByCodes(paymentReceiptCodes);
        if (CollUtil.isEmpty(paymentReceiptList)) {
            return;
        }
        for (PaymentReceipt paymentReceipt : paymentReceiptList) {
            String processState = paymentReceipt.getProcessState();
            if (CharSequenceUtil.equals(processState, ProcessStatusEnum.COMMIT.getDictCode())
                    || CharSequenceUtil.equals(processState, ProcessStatusEnum.PASS.getDictCode())) {
                continue;
            }
            canDeleteCodes.add(paymentReceipt.getPaymentReceiptCode());
        }

        this.paymentReceiptRepository.deleteByCode(canDeleteCodes);
        this.paymentReceiptShouldRepository.deleteShould(canDeleteCodes);
        this.paymentReceiptPayRepository.deleteByCode(canDeleteCodes);
    }

    @Override
    public List<PaymentReceiptShouldDto> summaryShouldInfo(PaymentReceiptDto dto) {
        return this.summaryShouldInfo(dto.getShouldList());
    }

    /**
     * 根据核销编码查应付明细
     *
     * @param codeSet
     * @return
     */
    @Override
    public List<PaymentReceiptShouldVo> findPaymentReceiptShouldByAuditCode(Set<String> codeSet) {
        if (CollectionUtils.isEmpty(codeSet)) {
            return new ArrayList<>();
        }
        return paymentReceiptShouldRepository.findPaymentReceiptShouldByAuditCode(codeSet);
    }

    /**
     * 根据付款单编码查支付明细
     *
     * @param paymentReceiptCodes
     * @return
     */
    @Override
    public List<PaymentReceiptPayVo> findByPaymentReceiptCodes(Set<String> paymentReceiptCodes) {
        if (CollectionUtils.isEmpty(paymentReceiptCodes)) {
            return new ArrayList<>();
        }
        List<PaymentReceiptPayVo> receiptPayVos = paymentReceiptPayRepository.findByPaymentReceiptCodes(paymentReceiptCodes);
        List<PaymentReceiptFileVo> receiptFileVos = paymentReceiptFileRepository.findByPaymentReceiptCodes(paymentReceiptCodes);
        if (!CollectionUtils.isEmpty(receiptPayVos) && !CollectionUtils.isEmpty(receiptFileVos)) {
            Map<String, Integer> integerMap = receiptFileVos.stream().collect(Collectors.toMap(PaymentReceiptFileVo::getPaymentReceiptCode, PaymentReceiptFileVo::getAppendices, (a, b) -> a));
            if (Objects.nonNull(integerMap)) {
                receiptPayVos.forEach(r -> r.setAppendices(integerMap.get(r.getPaymentReceiptCode())));
            }
        }
        return receiptPayVos;
    }

    @Override
    public List<MobilePaymentReceiptApprovedVo> mobilePaymentReceiptApproved(String processNo) {

        List<MobilePaymentReceiptApprovedVo> result = new ArrayList<>();
        if(StringUtils.isEmpty(processNo)){
            return Lists.newArrayList();
        }
        List<MobilePaymentReceiptApprovedVo> mobilePaymentReceiptApprovedVos = paymentReceiptPayRepository.mobilePaymentReceiptApproved(processNo);
        if(CollectionUtils.isEmpty(mobilePaymentReceiptApprovedVos)){
            return Lists.newArrayList();
        }
        List<String> auditItemCodes = mobilePaymentReceiptApprovedVos.stream().map(MobilePaymentReceiptApprovedVo::getAuditItemCode).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        //应付金额
        List<AuditCustomerDetailVo> auditCustomerDetailVos = auditService.findAuditCustomerDetail(auditItemCodes);
        Map<String, AuditCustomerDetailVo> auditCustomerDetailMap = auditCustomerDetailVos.stream().collect(Collectors.toMap(AuditCustomerDetailVo::getAuditDetailCode, Function.identity()));
        //已付金额
        List<MobilePaymentReceiptApprovedVo> alreadyMoneyList = paymentReceiptPayRepository.findAlreadyMoneyByAuditDetailCodes(auditItemCodes);
        Map<String, MobilePaymentReceiptApprovedVo> alreadyMoneyMap = alreadyMoneyList.stream().collect(Collectors.toMap(MobilePaymentReceiptApprovedVo::getAuditItemCode, Function.identity()));

        for (MobilePaymentReceiptApprovedVo item : mobilePaymentReceiptApprovedVos) {
            AuditCustomerDetailVo auditCustomerDetailVo = auditCustomerDetailMap.get(item.getAuditItemCode());
            item.setSupplierCode(auditCustomerDetailVo.getSupplierCode());
            item.setSupplierName(auditCustomerDetailVo.getSupplierName());
            item.setReimburseItem(auditCustomerDetailVo.getReimburseItem());
            item.setReimburseItemName(auditCustomerDetailVo.getReimburseItemName());
        }

        Map<String, List<MobilePaymentReceiptApprovedVo>> collect = mobilePaymentReceiptApprovedVos.stream().collect(Collectors.groupingBy(o->o.getAuditItemCode()+o.getSupplierCode()+o.getReimburseItem()));

        if(CollectionUtils.isEmpty(collect)) {
            collect.forEach((key, value) -> {
                AuditCustomerDetailVo auditCustomerDetailVo = auditCustomerDetailMap.get(key);
                MobilePaymentReceiptApprovedVo mobilePaymentReceiptApprovedVo1 = alreadyMoneyMap.get(key);
                MobilePaymentReceiptApprovedVo mobilePaymentReceiptApprovedVo = new MobilePaymentReceiptApprovedVo();
                mobilePaymentReceiptApprovedVo.setAuditItemCode(key);
                mobilePaymentReceiptApprovedVo.setShouldPayMoney(auditCustomerDetailVo.getThisAuditAmount());
                mobilePaymentReceiptApprovedVo.setAlreadyMoney(mobilePaymentReceiptApprovedVo1.getNowShouldPayMoney());
                mobilePaymentReceiptApprovedVo.setNowShouldPayMoney(value.stream().map(MobilePaymentReceiptApprovedVo::getNowShouldPayMoney).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                mobilePaymentReceiptApprovedVo.setPaymentSchedule(mobilePaymentReceiptApprovedVo.getAlreadyMoney().divide(mobilePaymentReceiptApprovedVo.getShouldPayMoney(), 6, RoundingMode.HALF_UP));

                result.add(mobilePaymentReceiptApprovedVo);
            });
        }
        return result;
    }

    public void constructPaymentReceipt(PaymentReceipt receipt, PaymentReceiptStatusDetailVo vo) {
        receipt.setProcessStatus(vo.getProcessStatus());
        receipt.setEasOrderId(vo.getEasOrderId());
        receipt.setFlowId(vo.getFlowId());
        receipt.setPayAccountCode(vo.getPayAccountCode());
        receipt.setEasCode(vo.getEasCode());
        receipt.setEasDesc(vo.getEasDesc());
        receipt.setEasMessage(vo.getEasMsg());
        receipt.setPaySuccessDate(vo.getPaySuccessDate());
        receipt.setSapVoucherNo(vo.getFkVoucherNo());
    }

    /**
     * 根据核销编码查询
     *
     * @param auditCode 核销编码
     */
    public PaymentReceiptVo getPaymentReceiptInfoByAuditCode(String auditCode) {


        List<PaymentReceiptShould> shouldList = this.paymentReceiptShouldRepository.findShouldByAuditCode(auditCode);
        if (CollUtil.isEmpty(shouldList)) {
            return null;
        }
        List<String> receiptCodes = shouldList
                .stream()
                .filter(should ->
                        CharSequenceUtil.isNotEmpty(should.getPaymentReceiptCode()))
                .map(PaymentReceiptShould::getPaymentReceiptCode)
                .distinct()
                .collect(Collectors.toList());

        if (CollUtil.isNotEmpty(receiptCodes) && receiptCodes.size() != 1) {
            throw new IllegalArgumentException("一个核销单下多个付款单信息");
        }

        List<PaymentReceipt> paymentReceipts = this.paymentReceiptRepository.findByCodes(receiptCodes);
        PaymentReceipt paymentReceipt = paymentReceipts.get(0);

        PaymentReceiptVo resultPaymentReceipt = this.nebulaToolkitService
                .copyObjectByWhiteList(paymentReceipt
                        , PaymentReceiptVo.class
                        , null
                        , null);

        LinkedList<PaymentReceiptShouldVo> shouldVoList = new LinkedList<>();

        shouldList.forEach(should -> {
            PaymentReceiptShouldVo paymentReceiptShouldVo = this.nebulaToolkitService.copyObjectByWhiteList(should, PaymentReceiptShouldVo.class, null, null);
            shouldVoList.add(paymentReceiptShouldVo);
        });

        resultPaymentReceipt.setShouldList(shouldVoList);

        LinkedList<PaymentReceiptPayVo> payList = paymentReceiptPayRepository.findPaymentReceiptPayByCode(receiptCodes.get(0));
        resultPaymentReceipt.setPayList(payList);

        //查询核销明细
        //查询核销信息
        LinkedList<PaymentReceiptAuditItemVo> auditItemList = Lists.newLinkedList();
        AuditVo auditVo = this.auditService.findByAuditCode(auditCode);
        Validate.notNull(auditVo, "核销信息未找到");
        //根据核销编码查询核销明细信息
        List<AuditCustomerDetailCollection> detailCollectionList = auditCustomerDetailCollectionRepository.findByAuditCode(auditCode);
        paymentAuditDetailHandle(auditItemList, detailCollectionList, auditVo);
        resultPaymentReceipt.setAuditItemList(auditItemList);

        return resultPaymentReceipt;

    }

    /**
     * 支付单信息
     *
     * @param paymentReceipt
     * @param auditVo
     * @param abstractLoginUser
     */
    private void paymentReceiptHandle(PaymentReceiptVo paymentReceipt, AuditVo auditVo, AbstractCrmUserIdentity abstractLoginUser) {
        paymentReceipt.setBusinessFormatCode(auditVo.getBusinessFormatCode());
        paymentReceipt.setBusinessUnitCode(auditVo.getBusinessUnitCode());
        paymentReceipt.setCompanyName(auditVo.getCompanyName());
        paymentReceipt.setCompanyCode(auditVo.getCompanyCode());
        paymentReceipt.setApplyWorkNo(abstractLoginUser.getUsername());
        paymentReceipt.setApplyPerson(abstractLoginUser.getAccount());
        paymentReceipt.setTradeCurrency("CNY");
        paymentReceipt.setExchangeRate("1");
        paymentReceipt.setPayType("no_ce_pay");
        paymentReceipt.setIsFactoring(YesOrNoEnum.NO.getCode());
        paymentReceipt.setIsHaveContract(YesOrNoEnum.NO.getCode());
        paymentReceipt.setApplyDepartCode(auditVo.getOrgCode());
        paymentReceipt.setApplyDepartName(auditVo.getOrgName());

    }

    /**
     * 核销明细
     */
    private void paymentAuditDetailHandle(LinkedList<PaymentReceiptAuditItemVo> auditItemList, List<AuditCustomerDetailCollection> detailCollectionList, AuditVo auditVo) {

        if (CollUtil.isEmpty(detailCollectionList)) {
            return;
        }

        for (AuditCustomerDetailCollection auditCustomerDetailCollection : detailCollectionList) {

            PaymentReceiptAuditItemVo paymentReceiptAuditItem = new PaymentReceiptAuditItemVo();

            paymentReceiptAuditItem.setAuditPayCode(auditCustomerDetailCollection.getId());

            paymentReceiptAuditItem.setAuditName(auditVo.getAuditName());
            paymentReceiptAuditItem.setAuditCode(auditVo.getAuditCode());

            paymentReceiptAuditItem.setReimbursementItemCode(auditCustomerDetailCollection.getReimburseItem());
            paymentReceiptAuditItem.setReimbursementItemName(auditCustomerDetailCollection.getReimburseItemName());
            paymentReceiptAuditItem.setReimburseItem(auditCustomerDetailCollection.getReimburseItem());
            paymentReceiptAuditItem.setReimburseItemName(auditCustomerDetailCollection.getReimburseItemName());

            paymentReceiptAuditItem.setAuditItemCode(auditCustomerDetailCollection.getAuditDetailCode());
            paymentReceiptAuditItem.setSupplierCode(auditCustomerDetailCollection.getSupplierCode());
            paymentReceiptAuditItem.setSupplierName(auditCustomerDetailCollection.getSupplierName());
            paymentReceiptAuditItem.setAlreadyMoney(BigDecimal.ZERO);
            //结案金额=报销金额含税
            paymentReceiptAuditItem.setAuditMoney(auditCustomerDetailCollection.getReimburseTaxAmount());
            //预付金额=报销冲销预付金额
            paymentReceiptAuditItem.setPrepaidMoney(auditCustomerDetailCollection.getReimburseChargeAgainstPrepayAmount());
            //应付金额=结案金额-预付金额
            BigDecimal prepaidMoney = paymentReceiptAuditItem.getPrepaidMoney();
            prepaidMoney = ObjectUtil.isNull(prepaidMoney) ? BigDecimal.ZERO : prepaidMoney;
            paymentReceiptAuditItem.setShouldPayMoney(paymentReceiptAuditItem.getAuditMoney().subtract(prepaidMoney));
            //代付款金额=应付款金额-已付金额
            paymentReceiptAuditItem.setPendingMoney(paymentReceiptAuditItem.getShouldPayMoney().subtract(paymentReceiptAuditItem.getAlreadyMoney()));
            paymentReceiptAuditItem.setNowShouldPayMoney(paymentReceiptAuditItem.getShouldPayMoney());
            paymentReceiptAuditItem.setPayWayCode(auditCustomerDetailCollection.getPayWayCode());
            paymentReceiptAuditItem.setPayWayName(auditCustomerDetailCollection.getPayWayName());

            BigDecimal reimburseChargeAgainstPrepayAmount = auditCustomerDetailCollection.getReimburseChargeAgainstPrepayAmount();
            reimburseChargeAgainstPrepayAmount = ObjectUtil.isNull(reimburseChargeAgainstPrepayAmount) ? BigDecimal.ZERO : reimburseChargeAgainstPrepayAmount;
            paymentReceiptAuditItem.setPrepaidMoney(reimburseChargeAgainstPrepayAmount);
            BigDecimal thisAuditAmount = auditCustomerDetailCollection.getThisAuditAmount();
            thisAuditAmount = ObjectUtil.isNull(thisAuditAmount) ? BigDecimal.ZERO : thisAuditAmount;
            paymentReceiptAuditItem.setShouldPayMoney(thisAuditAmount.subtract(reimburseChargeAgainstPrepayAmount));
            paymentReceiptAuditItem.setPendingMoney(paymentReceiptAuditItem.getShouldPayMoney());

            auditItemList.add(paymentReceiptAuditItem);

        }

    }

    private LinkedList<PaymentReceiptShouldVo> paymentReceiptShouldHandle(String auditCode) {
        LinkedList<PaymentReceiptShouldVo> shouldList = this.paymentReceiptShouldRepository.findAuditPaymentByCode(auditCode);

        if (CollUtil.isEmpty(shouldList)) {
            return shouldList;
        }

        int i = 0;
        for (PaymentReceiptShouldVo item : shouldList) {
            i++;
            item.setDateUnit(DateUnitTypeEnum.DAY.getCode());
            item.setPaymentNature(PaymentNatureTypeEnum.OTHER.getCode());
            item.setMerchantsType(MerchantsTypeEnum.SUPPLIER.getCode());
            item.setExpectPayDate(new Date());
            item.setNowShouldPayMoney(item.getShouldPayMoney());
            item.setSortNo(i);
        }

        //汇总
        return new LinkedList<>(summaryShouldInfoVo(shouldList));
    }

    private void paymentReceiptPayHandle(List<AuditCustomerDetailCollection> detailCollectionList
            , LinkedList<PaymentReceiptPayVo> payList
            , LinkedList<PaymentReceiptShouldVo> shouldList) {

        if (CollUtil.isEmpty(shouldList)) {
            return;
        }

        List<String> reimbursementItemCodes = detailCollectionList
                .stream()
                .filter(item ->
                        CharSequenceUtil.isNotEmpty(item.getReimburseItem()))
                .map(AuditCustomerDetailCollection::getReimburseItem)
                .distinct()
                .collect(Collectors.toList());

        Map<String, List<AuditCustomerDetailCollection>> collectionMap = detailCollectionList
                .stream()
                .collect(Collectors.groupingBy(o -> o.getSupplierCode() + o.getReimburseItem()));

        List<ReimburseFundsReasonMappingVo> auditReasonCodeFundsOutflowMappingList = this.paymentReceiptRepository
                .findAuditReasonCodeFundsOutflowMapping(reimbursementItemCodes);

        Map<String, ReimburseFundsReasonMappingVo> reimburseItemMap = auditReasonCodeFundsOutflowMappingList
                .stream()
                .collect(Collectors.toMap(ReimburseFundsReasonMappingVo::getReimburseItem
                        , Function.identity()
                        , (newValue, oldValue) -> newValue));
        int i = 0;
        for (Map.Entry<String, List<AuditCustomerDetailCollection>> entry : collectionMap.entrySet()) {
            i++;
            PaymentReceiptPayVo paymentReceiptPay = new PaymentReceiptPayVo();
            AuditCustomerDetailCollection item = entry.getValue().get(0);
            paymentReceiptPay.setAuditPayCode(item.getId());
            String reimbursementItemCode = item.getReimburseItem();
            ReimburseFundsReasonMappingVo reimburseFundsReasonMappingVo = reimburseItemMap.get(reimbursementItemCode);
            if (ObjectUtil.isNotNull(reimburseFundsReasonMappingVo)) {
                paymentReceiptPay.setReasonCode(reimburseFundsReasonMappingVo.getReasonCode());
                paymentReceiptPay.setReasonName(reimburseFundsReasonMappingVo.getReasonCodeName());
                paymentReceiptPay.setCapitalOutflowProject(reimburseFundsReasonMappingVo.getFundsOutflowItem());
                paymentReceiptPay.setCapitalOutflowProjectName(reimburseFundsReasonMappingVo.getFundsOutflowItemName());
            }
            paymentReceiptPay.setSortNo(i);
            BigDecimal nowShouldPayMoney = BigDecimal.ZERO;
            for (AuditCustomerDetailCollection auditCustomerDetailCollection : entry.getValue()) {
                BigDecimal reimburseTaxAmount = auditCustomerDetailCollection.getReimburseTaxAmount();
                BigDecimal reimburseChargeAgainstPrepayAmount = auditCustomerDetailCollection.getReimburseChargeAgainstPrepayAmount();
                nowShouldPayMoney = nowShouldPayMoney.add(reimburseTaxAmount.subtract(reimburseChargeAgainstPrepayAmount));
            }
            paymentReceiptPay.setNowShouldPayMoney(nowShouldPayMoney);
            payList.add(paymentReceiptPay);
        }

/*        for (AuditCustomerDetailCollection item : detailCollectionList) {
            i++;
            PaymentReceiptPayVo paymentReceiptPay = new PaymentReceiptPayVo();
            paymentReceiptPay.setAuditPayCode(item.getId());
            String reimbursementItemCode = item.getReimburseItem();
            ReimburseFundsReasonMappingVo reimburseFundsReasonMappingVo = reimburseItemMap.get(reimbursementItemCode);
            if (ObjectUtil.isNotNull(reimburseFundsReasonMappingVo)){
                paymentReceiptPay.setReasonCode(reimburseFundsReasonMappingVo.getReasonCode());
                paymentReceiptPay.setReasonName(reimburseFundsReasonMappingVo.getReasonCodeName());
                paymentReceiptPay.setCapitalOutflowProject(reimburseFundsReasonMappingVo.getFundsOutflowItem());
                paymentReceiptPay.setCapitalOutflowProjectName(reimburseFundsReasonMappingVo.getFundsOutflowItemName());
                paymentReceiptPay.setSortNo(i);
            }
            AuditCustomerDetailCollection auditCustomerDetailCollection = collectionMap.get(item.getId());
            if (ObjectUtil.isNotNull(auditCustomerDetailCollection)){
                paymentReceiptPay.setProfitCenter(auditCustomerDetailCollection.getProfitCenter());
            }
            BigDecimal reimburseTaxAmount = auditCustomerDetailCollection.getReimburseTaxAmount();
            BigDecimal reimburseChargeAgainstPrepayAmount = auditCustomerDetailCollection.getReimburseChargeAgainstPrepayAmount();
            paymentReceiptPay.setNowShouldPayMoney(reimburseTaxAmount.subtract(reimburseChargeAgainstPrepayAmount));
            payList.add(paymentReceiptPay);
        }*/
    }

    private void shouldPayInfoSummary(LinkedList<PaymentReceiptShouldVo> receiptShouldList, LinkedList<PaymentReceiptShouldVo> shouldList, String auditId) {

        if (CollUtil.isNotEmpty(shouldList)) {
            //根据客户编码进行汇总
            Map<String, List<PaymentReceiptShouldVo>> shouldMap = shouldList
                    .stream()
                    .filter(item ->
                            CharSequenceUtil.isNotEmpty(item.getMerchantsCode()))
                    .collect(Collectors.groupingBy(PaymentReceiptShouldVo::getMerchantsCode));
            if (ObjectUtil.isNotNull(shouldMap)) {
                shouldMap.forEach((key, value) -> {

                    PaymentReceiptShouldVo paymentReceiptShouldVo = value.get(0);
                    paymentReceiptShouldVo.setAuditPayCode(auditId);
                    BigDecimal totalAssessDeductionMoney = BigDecimal.ZERO;
                    BigDecimal totalAuditMoney = BigDecimal.ZERO;
                    BigDecimal totalShouldPayMoney = BigDecimal.ZERO;

                    for (PaymentReceiptShouldVo receiptShouldVo : value) {
                        BigDecimal assessDeductionMoney = receiptShouldVo.getAssessDeductionMoney();
                        assessDeductionMoney = ObjectUtil.isNotNull(assessDeductionMoney) ? assessDeductionMoney : BigDecimal.ZERO;
                        totalAssessDeductionMoney = totalAssessDeductionMoney.add(assessDeductionMoney);
                        BigDecimal auditMoney = receiptShouldVo.getAuditMoney();
                        auditMoney = ObjectUtil.isNotNull(auditMoney) ? auditMoney : BigDecimal.ZERO;
                        totalAuditMoney = totalAuditMoney.add(auditMoney);
                        BigDecimal shouldPayMoney = receiptShouldVo.getShouldPayMoney();
                        shouldPayMoney = ObjectUtil.isNotNull(shouldPayMoney) ? shouldPayMoney : BigDecimal.ZERO;
                        totalShouldPayMoney = totalShouldPayMoney.add(shouldPayMoney);
                    }
                    //客户类型
                    paymentReceiptShouldVo.setMerchantsType(CustomerSupplierTypeEnum.SUPPLIER.getValue());
                    paymentReceiptShouldVo.setNowShouldPayMoney(totalShouldPayMoney);
                    paymentReceiptShouldVo.setShouldPayMoney(totalShouldPayMoney);
                    paymentReceiptShouldVo.setAuditMoney(totalAuditMoney);
                    paymentReceiptShouldVo.setAssessDeductionMoney(totalAssessDeductionMoney);
                    paymentReceiptShouldVo.setExpectPayDate(new Date());
                    paymentReceiptShouldVo.setDateUnit(DateUnitTypeEnum.DAY.getCode());
                    paymentReceiptShouldVo.setPaymentNature(PaymentNatureTypeEnum.OTHER.getCode());

                    receiptShouldList.add(paymentReceiptShouldVo);
                });
            }
        }
    }

    private void payInfoSummary(List<AuditCustomerDetailVo> auditCustomerDetailList, LinkedList<PaymentReceiptPayVo> payLinkedList, List<String> codes, String auditId) {

        Map<String, List<AuditCustomerDetailVo>> detailMap = auditCustomerDetailList
                .stream().filter(item ->
                        CharSequenceUtil.isNotEmpty(item.getSupplierCode()))
                .collect(Collectors.groupingBy(AuditCustomerDetailVo::getSupplierCode));
        if (CollUtil.isEmpty(detailMap)) {
            return;
        }

        List<ReimburseFundsReasonMappingVo> auditReasonCodeFundsOutflowMappingList = this.paymentReceiptRepository.findAuditReasonCodeFundsOutflowMapping(codes);
        Map<String, ReimburseFundsReasonMappingVo> reimburseItemMap = auditReasonCodeFundsOutflowMappingList
                .stream()
                .collect(Collectors.toMap(ReimburseFundsReasonMappingVo::getReimburseItem
                        , Function.identity()
                        , (newValue, oldValue) -> newValue));

        detailMap.forEach((key, value) -> {
            PaymentReceiptPayVo paymentReceiptPay = new PaymentReceiptPayVo();
            paymentReceiptPay.setAuditPayCode(auditId);
            AuditCustomerDetailVo auditCustomerDetailVo = value.get(0);
            String reimburseItem = auditCustomerDetailVo.getReimburseItem();
            ReimburseFundsReasonMappingVo reimburseFundsReasonMappingVo = reimburseItemMap.get(reimburseItem);
            if (ObjectUtil.isNotNull(reimburseFundsReasonMappingVo)) {
                paymentReceiptPay.setReasonCode(reimburseFundsReasonMappingVo.getReasonCode());
                paymentReceiptPay.setReasonName(reimburseFundsReasonMappingVo.getReasonCodeName());
                paymentReceiptPay.setCapitalOutflowProject(reimburseFundsReasonMappingVo.getFundsOutflowItem());
                paymentReceiptPay.setCapitalOutflowProjectName(reimburseFundsReasonMappingVo.getFundsOutflowItemName());
            }
            paymentReceiptPay.setProfitCenter(auditCustomerDetailVo.getProfitCenter());
            BigDecimal totalNowShouldPayMoney = BigDecimal.ZERO;
            for (AuditCustomerDetailVo customerDetailVo : value) {
                BigDecimal thisAuditAmount = customerDetailVo.getThisAuditAmount();
                totalNowShouldPayMoney = totalNowShouldPayMoney.add(ObjectUtil.isNotNull(thisAuditAmount) ? thisAuditAmount : BigDecimal.ZERO);
            }
            paymentReceiptPay.setNowShouldPayMoney(totalNowShouldPayMoney);
            payLinkedList.add(paymentReceiptPay);
        });
    }

    private void computeTotalAmount(PaymentReceiptVo paymentReceipt, LinkedList<PaymentReceiptAuditItemVo> auditItemList) {
        if (CollUtil.isEmpty(auditItemList)) {
            return;
        }
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (PaymentReceiptAuditItemVo paymentReceiptAuditItemVo : auditItemList) {
            BigDecimal nowShouldPayMoney = paymentReceiptAuditItemVo.getNowShouldPayMoney();
            nowShouldPayMoney = ObjectUtil.isNull(nowShouldPayMoney) ? BigDecimal.ZERO : nowShouldPayMoney;
            totalAmount = totalAmount.add(nowShouldPayMoney);
        }
        paymentReceipt.setPayTotalMoney(totalAmount.toString());
    }

    private void paymentReceiptOtherAssignment(PaymentReceiptVo paymentReceipt, List<AuditCustomerDetailCollection> collectionList) {
        if (CollUtil.isEmpty(collectionList)) {
            return;
        }

        //利润中心字典
        Map<String, String> profitDictMap = this.dictToolkitService.findMapByDictTypeCode(TPM_PROFIT_CENTER);

        Map<String, AuditCustomerDetailCollection> collectMap = collectionList
                .stream()
                .filter(item ->
                        CharSequenceUtil.isNotEmpty(item.getProfitCenter()))
                .collect(Collectors.toMap(AuditCustomerDetailCollection::getProfitCenter
                        , Function.identity()
                        , (newValue, oldValue) -> newValue));
        if (CollUtil.isNotEmpty(collectMap) && collectMap.size() == 1) {
            collectMap.forEach((key, value) -> {
                paymentReceipt.setProfitCenterCode(value.getProfitCenter());
                paymentReceipt.setProfitCenterName(profitDictMap.get(value.getProfitCenter()));
            });
        }

        Map<String, AuditCustomerDetailCollection> collectPayWayMap = collectionList
                .stream()
                .filter(item ->
                        CharSequenceUtil.isNotEmpty(item.getPayWayCode()))
                .collect(Collectors.toMap(AuditCustomerDetailCollection::getPayWayCode
                        , Function.identity()
                        , (newValue, oldValue) -> newValue));
        if (CollUtil.isNotEmpty(collectPayWayMap) && collectPayWayMap.size() == 1) {
            collectPayWayMap.forEach((key, value) -> {
                paymentReceipt.setPayWay(value.getPayWayCode());
            });
        }
    }

}
