package com.biz.crm.tpm.business.payment.receipt.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.payment.receipt.local.entity.PaymentReceiptPay;
import com.biz.crm.tpm.business.payment.receipt.local.entity.PaymentReceiptShould;
import com.biz.crm.tpm.business.payment.receipt.local.entity.PaymentReceiptShouldAuditRelations;
import com.biz.crm.tpm.business.payment.receipt.local.repository.PaymentReceiptShouldAuditRelationsRepository;
import com.biz.crm.tpm.business.payment.receipt.local.repository.PaymentReceiptShouldRepository;
import com.biz.crm.tpm.business.payment.receipt.local.service.PaymentReceiptShouldService;
import com.biz.crm.tpm.business.payment.receipt.sdk.constant.PaymentReceiptConstants;
import com.biz.crm.tpm.business.payment.receipt.sdk.dto.PaymentReceiptPayDto;
import com.biz.crm.tpm.business.payment.receipt.sdk.dto.PaymentReceiptShouldDto;
import com.biz.crm.tpm.business.payment.receipt.sdk.vo.PaymentReceiptShouldAuditRelationsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * @author: chenlong
 * @date: 2022/12/5 19:51
 * @description: 付款单-应付明细表(PaymentReceiptShould)表服务接口实现类
 */
@Service("PaymentReceiptShouldService")
public class PaymentReceiptShouldServiceImpl implements PaymentReceiptShouldService {

    @Autowired(required = false)
    private PaymentReceiptShouldRepository paymentReceiptShouldRepository;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required = false)
    private PaymentReceiptShouldAuditRelationsRepository paymentReceiptShouldAuditRelationsRepository;
    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    /**
     * 批量修改付款单-核销明细
     *
     * @param dtoList            核销明细列表
     * @param paymentReceiptCode 主键结合
     * @param tenantCode         租户编号
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void batchEdit(List<PaymentReceiptShouldDto> dtoList, String paymentReceiptCode, String tenantCode) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        List<PaymentReceiptShouldDto> newShouldDtoList = new ArrayList<>();
        List<PaymentReceiptShould> list = this.paymentReceiptShouldRepository.lambdaQuery()
                .eq(PaymentReceiptShould::getTenantCode, tenantCode)
                .eq(PaymentReceiptShould::getPaymentReceiptCode, paymentReceiptCode)
                .eq(PaymentReceiptShould::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(PaymentReceiptShould::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
                .list();
        List<String> idList = list.stream().map(o -> o.getId()).collect(Collectors.toList());
        List<String> shouldCodeList = list.stream().map(o -> o.getShouldCode()).collect(Collectors.toList());
//        String ruleCode3 = StringUtils.join(PaymentReceiptConstants.PAYMENT_RECEIPT_SHOULD_CODE_PREFIX, DateFormatUtils.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY_NO_CH));
        List<String> codes3 = this.generateCodeService.generateCode(PaymentReceiptConstants.PAYMENT_RECEIPT_SHOULD_CODE_PREFIX, dtoList.size(), 5, 2, TimeUnit.DAYS);

        for (int i = 0; i < dtoList.size(); i++) {
            PaymentReceiptShouldDto item = dtoList.get(i);
            item.setPaymentReceiptCode(paymentReceiptCode);
            item.setShouldCode(codes3.get(i));
            item.setTenantCode(tenantCode);
            item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            item.setId(null);
            newShouldDtoList.add(item);
        }


        //删除数据
        if (!CollectionUtils.isEmpty(idList)) {
            this.paymentReceiptShouldRepository.lambdaUpdate()
                    .in(PaymentReceiptShould::getId, idList)
                    .set(PaymentReceiptShould::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                    .update();
        }

        //删除关联关系
        if (!CollectionUtils.isEmpty(shouldCodeList)){
            this.paymentReceiptShouldAuditRelationsRepository.deleteByShouldCodeList(shouldCodeList);
        }

        //新增关联关系
        if (!CollectionUtils.isEmpty(dtoList)){
            List<PaymentReceiptShouldAuditRelations> relations = new ArrayList<>();
            for (PaymentReceiptShouldDto shouldDto : dtoList) {
                List<PaymentReceiptShouldAuditRelationsVo> relationsVos = shouldDto.getPaymentReceiptShouldAuditRelationsVos();
                for (PaymentReceiptShouldAuditRelationsVo relationsVo : relationsVos) {
                    relationsVo.setPaymentReceiptCode(shouldDto.getPaymentReceiptCode());
                    relationsVo.setShouldCode(shouldDto.getShouldCode());
                    relationsVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    relationsVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                    relationsVo.setTenantCode(TenantUtils.getTenantCode());
                }
                Collection<PaymentReceiptShouldAuditRelations> auditRelations = this.nebulaToolkitService.copyCollectionByWhiteList(relationsVos, PaymentReceiptShouldAuditRelationsVo.class, PaymentReceiptShouldAuditRelations.class, HashSet.class, ArrayList.class);
                relations.addAll(new ArrayList<>(auditRelations));
            }
            this.paymentReceiptShouldAuditRelationsRepository.saveBatch(relations);
        }
        //保存新数据
        if (!CollectionUtils.isEmpty(newShouldDtoList)) {
            Collection<PaymentReceiptShould> shoulds = this.nebulaToolkitService.copyCollectionByBlankList(
                    newShouldDtoList, PaymentReceiptShouldDto.class, PaymentReceiptShould.class, LinkedHashSet.class, ArrayList.class);
            this.paymentReceiptShouldRepository.saveBatch(shoulds);
        }
    }

    @Transactional
    @Override
    public void replace(List<PaymentReceiptShouldDto> dtoList, String paymentReceiptCode) {
        this.paymentReceiptShouldRepository.lambdaUpdate()
                .eq(PaymentReceiptShould::getTenantCode, TenantUtils.getTenantCode())
                .eq(PaymentReceiptShould::getPaymentReceiptCode, paymentReceiptCode)
//                .set(PaymentReceiptShould::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .remove();
        Collection<PaymentReceiptShould> list = this.nebulaToolkitService.copyCollectionByBlankList(dtoList, PaymentReceiptShouldDto.class, PaymentReceiptShould.class, LinkedHashSet.class, ArrayList.class);
        this.paymentReceiptShouldRepository.saveBatch(list);
    }
}
