package com.biz.crm.tpm.business.payment.receipt.sdk.constant;

/**
 * @author: chenlong
 * @date: 2022/12/6 16:39
 * @description: 付款单常量池
 */
public interface PaymentReceiptConstants {

    /**
     * 付款单编码前缀
     */
    String PAYMENT_RECEIPT_CODE_PREFIX = "FK";

    /**
     * 付款单应付明细编码前缀
     */
    String PAYMENT_RECEIPT_SHOULD_CODE_PREFIX = "YF";

    /**
     * 付款单支付明细编码前缀
     */
    String PAYMENT_RECEIPT_PAY_CODE_PREFIX = "ZF";


    /**
     * 付款单流程业务编码
     */
    String PROCESS_NAME_PAYMENT_RECEIPT = "payment_receipt";

    /**
     * 付款单审批锁前缀
     */
    String PAYMENT_RECEIPT_LOCK_APPROVE = "payment_receipt:lock:approve:";

    /**
     * 付款单-核销付款信息锁
     */
    String LOCK_PAYMENT_RECEIPT_AUDIT_PAY = "payment_receipt:lock:audit_pay";

    /**
     * 付款单据accID
     */
    String PAYMENT_RECEIPT_ACC_ID = "PAYMENT_RECEIPT:ACC_ID";

    /**
     * 付款单推送第三方数据TOPIC
     */
    String TPM_PAYMENT_RECEIPT_PUSH_DATA_TOPIC = "TPM_PAYMENT_RECEIPT_PUSH_DATA_TOPIC";

    /**
     * 付款单推送第三方数据TAG
     */
    String TPM_PAYMENT_RECEIPT_PUSH_DATA_TAG = "TPM_PAYMENT_RECEIPT_PUSH_DATA_TAG";

    /**
     * 付款单查询CE状态TOPIC
     */
    String TPM_PAYMENT_RECEIPT_QUERY_CE_STATUS_TOPIC = "TPM_PAYMENT_RECEIPT_QUERY_CE_STATUS_TOPIC";

    /**
     * 付款单查询CE状态TAG
     */
    String TPM_PAYMENT_RECEIPT_QUERY_CE_STATUS_TAG = "TPM_PAYMENT_RECEIPT_QUERY_CE_STATUS_TAG";

    /**
     * 付款单 客商类型 固定
     */
    String ACCOUNT_TYPE = "K";


    /**
     * 利润中心前缀
     */
    String PROFIT_CENTER_PREFIX = "000000";

    /**
     * 业务大类 付款单固定
     */
    String TITLE = "300203";

    /**
     * 数据来源 固定4
     */
    String DATA_FROM = "4";

    /**
     * SAP利润中心
     */
    String TPM_PROFIT_CENTER = "tpm_profit_center";


}
