package com.biz.crm.tpm.business.payment.receipt.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * @author: chenlong
 * @date: 2022/12/6 9:48
 * @description: 付款单-核销明细Dto
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "PaymentReceiptAuditItemDto", description = "付款单-核销明细Dto")
public class PaymentReceiptAuditItemDto extends TenantFlagOpDto {

    @ApiModelProperty(name = "付款单编码", notes = "付款单编码")
    private String paymentReceiptCode;

    @ApiModelProperty(name = "核销编码", notes = "核销编码")
    private String auditCode;

    @ApiModelProperty(name = "核销明细编码", notes = "核销明细编码")
    private String auditItemCode;

    @ApiModelProperty(name = "核销申请名称", notes = "核销申请名称")
    private String auditName;

    @ApiModelProperty(name = "核销付款信息编码", notes = "核销付款信息编码")
    private String auditPayCode;

    @ApiModelProperty(name = "供应商编码", notes = "供应商编码")
    private String supplierCode;

    @ApiModelProperty(name = "供应商名称", notes = "供应商名称")
    private String supplierName;

    @ApiModelProperty(name = "保理客户编码", notes = "保理客户编码")
    private String factoringCode;

    @ApiModelProperty(name = "保理客户名称", notes = "保理客户名称")
    private String factoringName;

    @ApiModelProperty(name = "结案金额（元）", notes = "结案金额（元）")
    private BigDecimal auditMoney;

    @ApiModelProperty(name = "应付金额（元）", notes = "应付金额（元）")
    private BigDecimal shouldPayMoney;

    @ApiModelProperty(name = "预付金额（元）", notes = "预付金额（元）")
    private BigDecimal prepaidMoney;

    @ApiModelProperty(name = "已付金额（含审批中）", notes = "已付金额（含审批中）")
    private BigDecimal alreadyMoney;

    @ApiModelProperty(name = "本次应付金额（元）", notes = "本次应付金额（元）")
    private BigDecimal nowShouldPayMoney;

    @ApiModelProperty(name = "序号", notes = "序号")
    private Integer sortNo;

    @ApiModelProperty(name = "reimbursementItemCode", notes = "报销项目编码")
    private String reimbursementItemCode;

    @ApiModelProperty(name = "reimbursementItemName", notes = "报销项目名称")
    private String reimbursementItemName;
}
