package com.biz.crm.tpm.business.payment.receipt.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: chenlong
 * @date: 2022/12/6 10:02
 * @description: 付款单-核销付款Dto
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "PaymentReceiptAuditPayDto", description = "付款单-核销付款Dto")
public class PaymentReceiptAuditPayDto extends TenantFlagOpDto {
    

    @ApiModelProperty(name = "核销编码", notes = "核销编码")
    private String auditCode;

    @ApiModelProperty(name = "核销明细编码", notes = "核销明细编码")
    private String auditItemCode;

    @ApiModelProperty(name = "核销申请名称", notes = "核销申请名称")
    private String auditName;

    @ApiModelProperty(name = "付款方式", notes = "付款方式")
    private String payType;

    @ApiModelProperty(name = "核销付款信息编码", notes = "核销付款信息编码")
    private String auditPayCode;

    @ApiModelProperty(name = "客商编码", notes = "客商编码")
    private String merchantsCode;

    @ApiModelProperty(name = "客商名称", notes = "客商名称")
    private String merchantsName;

    @ApiModelProperty(name = "应付金额（元）", notes = "应付金额（元）")
    private BigDecimal shouldPayMoney;

    @ApiModelProperty(name = "预付金额（元）", notes = "预付金额（元）")
    private BigDecimal prepaidMoney;

    @ApiModelProperty(name = "已付金额（含审批中）", notes = "已付金额（含审批中）")
    private BigDecimal alreadyMoney;

    @ApiModelProperty(name = "本次应付金额（元）", notes = "本次应付金额（元）")
    private BigDecimal nowShouldPayMoney;

    @ApiModelProperty(name = "reimbursementItemCode", notes = "报销项目编码")
    private String reimbursementItemCode;

    @ApiModelProperty(name = "reimbursementItemName", notes = "报销项目名称")
    private String reimbursementItemName;

    @ApiModelProperty(name = "业态", notes = "业态")
    private String businessFormatCode;

    @ApiModelProperty(name = "业务单元", notes = "业务单元")
    private String businessUnitCode;

    @ApiModelProperty("付款方式")
    private String payWayCode;
}
