package com.biz.crm.tpm.business.payment.receipt.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

/**
 * @author: chenlong
 * @date: 2022/12/5 20:19
 * @description: 付款单Dto
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "PaymentReceiptDto", description = "付款单Dto")
public class PaymentReceiptDto extends TenantFlagOpDto {

    @ApiModelProperty(name = "付款单编码", notes = "付款单编码")
    private String paymentReceiptCode;

    @ApiModelProperty(name = "付款单状态", notes = "付款单状态")
    private String paymentReceiptState;

    @ApiModelProperty(name = "审批状态", notes = "审批状态")
    private String processState;

    @ApiModelProperty(value = "processNo",notes = "流程编号")
    private String processNo;

    @ApiModelProperty(name = "保存状态", notes = "保存状态")
    private String saveState;

    @ApiModelProperty(name = "业态", notes = "业态")
    private String businessFormatCode;

    @ApiModelProperty(name = "业务单元", notes = "业务单元")
    private String businessUnitCode;

    @ApiModelProperty(name = "申请人工号", notes = "申请人工号")
    private String applyWorkNo;

    @ApiModelProperty(name = "申请人", notes = "申请人")
    private String applyPerson;

    @ApiModelProperty(name = "申请人部门", notes = "申请人部门")
    private String applyDepartName;

    @ApiModelProperty(name = "申请人部门编码", notes = "申请人部门编码")
    private String applyDepartCode;

    @ApiModelProperty(name = "公司名称", notes = "公司名称")
    private String companyName;

    @ApiModelProperty(name = "公司编码", notes = "公司编码")
    private String companyCode;

    @ApiModelProperty(name = "利润中心名称", notes = "利润中心名称")
    private String profitCenterName;

    @ApiModelProperty(name = "利润中心编码", notes = "利润中心")
    private String profitCenterCode;

    @ApiModelProperty(name = "付款类型", notes = "付款类型")
    private String payType;

    @ApiModelProperty(name = "付款细类", notes = "付款细类")
    private String payItemType;

    @ApiModelProperty(name = "交易货币", notes = "交易货币")
    private String tradeCurrency;

    @ApiModelProperty(name = "汇率", notes = "汇率")
    private String exchangeRate;

    @ApiModelProperty(name = "付款方式", notes = "付款方式")
    private String payWay;

    @ApiModelProperty(name = "FSSC审核部门", notes = "FSSC审核部门")
    private String auditDepart;

    @ApiModelProperty(name = "是否有合同", notes = "是否有合同")
    private String isHaveContract;

    @ApiModelProperty(name = "是否挂账保理", notes = "是否挂账保理")
    private String isFactoring;

    @ApiModelProperty(name = "付款总金额", notes = "付款总金额")
    private String payTotalMoney;

    @ApiModelProperty(name = "开支内容", notes = "开支内容")
    private String spendingContent;

    @ApiModelProperty("CE提交状态")
    private String ceCommitStatus;

    @ApiModelProperty(name = "ceDocumentNumber", notes = "ce单据单号")
    private String ceDocumentNumber;

    @ApiModelProperty("SAP转款提交状态")
    private String sapTransferCommitStatus;

    @ApiModelProperty("SAP转款凭证编码")
    private String sapTransferCertCode;

    @ApiModelProperty("付款编码")
    private String easOrderId;

    @ApiModelProperty("付款流水号")
    private String flowId;

    @ApiModelProperty("付款账号")
    private String payAccountCode;

    @ApiModelProperty("付款编码")
    private String easCode;

    @ApiModelProperty("付款描述")
    private String easDesc;

    @ApiModelProperty("EAS返回信息")
    private String easMessage;

    @ApiModelProperty("付款成功日期")
    private String paySuccessDate;

    @ApiModelProperty("SAP付款凭证号")
    private String sapVoucherNo;

    @ApiModelProperty("流程状态")
    private String processStatus;

    @ApiModelProperty("SAP转款提交信息")
    private String sapTransferCommitMessage;

    @ApiModelProperty("SAP会计凭证号")
    private String sapTransferBelnr;


    @ApiModelProperty(name = "核销明细列表", notes = "核销明细列表")
    private LinkedList<PaymentReceiptAuditItemDto> auditItemList;

    @ApiModelProperty(name = "应付明细列表", notes = "应付明细列表")
    private LinkedList<PaymentReceiptShouldDto> shouldList;

    @ApiModelProperty(name = "支付明细列表", notes = "支付明细列表")
    private LinkedList<PaymentReceiptPayDto> payList;

    @ApiModelProperty(name = "附件列表", notes = "附件列表")
    private List<PaymentReceiptFileDto> fileList;

    /**
     * 工作流参数
     */
    @ApiModelProperty("工作流参数")
    private ProcessBusinessDto processBusiness;

    @ApiModelProperty("CE提交信息")
    private String ceCommitMessage;

    @ApiModelProperty("数据来源")
    private String dataSource;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("组织编码")
    private String orgName;

}
