package com.biz.crm.tpm.business.payment.receipt.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author: chenlong
 * @date: 2022/12/6 14:08
 * @description: 付款单-附件信息Dto
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "PaymentReceiptFileDto", description = "付款单-附件信息Dto")
public class PaymentReceiptFileDto extends TenantFlagOpDto {

    @ApiModelProperty(name = "付款单编码", notes = "付款单编码")
    private String paymentReceiptCode;

    @ApiModelProperty("文件唯一识别号")
    private String fileCode;

    @ApiModelProperty(name = "originalFileName", value = "原始文件名")
    private String originalFileName;
}
