package com.biz.crm.tpm.business.payment.receipt.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author: chenlong
 * @date: 2022/12/6 9:59
 * @description: 付款单-支付明细Dto
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "PaymentReceiptPayDto", description = "付款单-支付明细Dto")
public class PaymentReceiptPayDto extends TenantFlagOpDto {

    @ApiModelProperty(name = "付款单编码", notes = "付款单编码")
    private String paymentReceiptCode;

    @ApiModelProperty(name = "支付明细编码", notes = "支付明细编码")
    private String payCode;

    @ApiModelProperty(name = "核销付款信息编码", notes = "核销付款信息编码")
    private String auditPayCode;

    @ApiModelProperty(name = "应付明细编码", notes = "应付明细编码")
    private String shouldCode;

    @ApiModelProperty(name = "支付摘要", notes = "支付摘要")
    private String paymentDigest;

    @ApiModelProperty(name = "利润中心", notes = "利润中心")
    private String profitCenter;

    @ApiModelProperty(name = "资金流出项目", notes = "资金流出项目")
    private String capitalOutflowProject;

    @ApiModelProperty(name = "原因代码", notes = "原因代码")
    private String reasonCode;

    @ApiModelProperty(name = "原因代码名称", notes = "原因代码名称")
    private String reasonName;

    @ApiModelProperty(name = "资金流出项目名称", notes = "资金流出项目名称")
    private String capitalOutflowProjectName;

    @ApiModelProperty(name = "序号", notes = "序号")
    private Integer sortNo;

    @ApiModelProperty(name = "本次应付金额", notes = "本次应付金额")
    private BigDecimal nowShouldPayMoney;
}
