package com.biz.crm.tpm.business.payment.receipt.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.tpm.business.payment.receipt.sdk.vo.PaymentReceiptShouldAuditRelationsVo;
import com.biz.crm.tpm.business.payment.receipt.sdk.vo.ReimburseFundsReasonMappingVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author: chenlong
 * @date: 2022/12/6 10:02
 * @description: 付款单-应付明细Dto
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "PaymentReceiptShouldDto", description = "付款单-应付明细Dto")
public class PaymentReceiptShouldDto extends TenantFlagOpDto {

    @ApiModelProperty(name = "付款单编码", notes = "付款单编码")
    private String paymentReceiptCode;

    @ApiModelProperty(name = "应付明细编码", notes = "应付明细编码")
    private String shouldCode;

    @ApiModelProperty(name = "核销编码", notes = "核销编码")
    private String auditCode;

    @ApiModelProperty(name = "核销付款信息编码", notes = "核销付款信息编码")
    private String auditPayCode;

    @ApiModelProperty(name = "核销名称", notes = "核销名称")
    private String auditName;

    @ApiModelProperty(name = "核销明细编码", notes = "核销明细编码")
    private String auditItemCode;

    @ApiModelProperty(name = "结案金额", notes = "结案金额")
    private BigDecimal auditMoney;

    @ApiModelProperty(name = "供应商编码", notes = "供应商编码")
    private String suppliersCode;

    @ApiModelProperty(name = "供应商名称", notes = "供应商名称")
    private String suppliersName;

    @ApiModelProperty(name = "保理客户编码", notes = "保理客户编码")
    private String factoringCode;

    @ApiModelProperty(name = "保理客户名称", notes = "保理客户名称")
    private String factoringName;

    @ApiModelProperty(name = "客商类型", notes = "客商类型")
    private String merchantsType;

    @ApiModelProperty(name = "款项性质", notes = "款项性质")
    private String paymentNature;

    @ApiModelProperty(name = "客商编码", notes = "客商编码")
    private String merchantsCode;

    @ApiModelProperty(name = "客商名称", notes = "客商名称")
    private String merchantsName;

    @ApiModelProperty(name = "收款信息id", notes = "收款信息id")
    private String accountId;

    @ApiModelProperty(name = "户名", notes = "户名")
    private String accountName;

    @ApiModelProperty(name = "收款账号", notes = "收款账号")
    private String collectionAccount;

    @ApiModelProperty(name = "开户行", notes = "开户行")
    private String accountBank;

    @ApiModelProperty(name = "银联行号", notes = "银联行号")
    private String unionPayAccount;

    @ApiModelProperty(name = "客商编码2", notes = "客商编码2")
    private String merchantsTwoCode;

    @ApiModelProperty(name = "客商名称2", notes = "客商名称2")
    private String merchantsTwoName;

    @ApiModelProperty(name = "考核扣款金额（元）", notes = "考核扣款金额（元）")
    private BigDecimal assessDeductionMoney;

    @ApiModelProperty(name = "应付金额（元）", notes = "应付金额（元）")
    private BigDecimal shouldPayMoney;

    @ApiModelProperty(name = "预付金额（元）", notes = "预付金额（元）")
    private BigDecimal prepaidMoney;

    @ApiModelProperty(name = "已付金额（含审批中）", notes = "已付金额（含审批中）")
    private BigDecimal alreadyMoney;

    @ApiModelProperty(name = "本次应付金额（元）", notes = "本次应付金额（元）")
    private BigDecimal nowShouldPayMoney;

    @ApiModelProperty(name = "期望付款日期", notes = "期望付款日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date expectPayDate;

    @ApiModelProperty(name = "邮件通知人", notes = "邮件通知人")
    private String mailNoticePerson;

    @ApiModelProperty(name = "汇票期限", notes = "汇票期限")
    private Integer billDate;

    @ApiModelProperty(name = "单位", notes = "单位")
    private String dateUnit;

    @ApiModelProperty(name = "合同编码", notes = "合同编码")
    private String contractCode;

    @ApiModelProperty(name = "合同名称", notes = "合同名称")
    private String contractName;

    @ApiModelProperty(name = "序号", notes = "序号")
    private Integer sortNo;

    @ApiModelProperty(name = "reimbursementItemCode", notes = "报销项目编码")
    private String reimbursementItemCode;

    @ApiModelProperty(name = "reimbursementItemName", notes = "报销项目名称")
    private String reimbursementItemName;

    @ApiModelProperty("报销项目编码")
    private String reimburseItem;

    @ApiModelProperty("报销项目编码")
    private String reimburseItemName;


    /**
     * 关联核销明细ID集合
     */
    @ApiModelProperty("关联核销明细ID集合")
    List<String> relationAuditDetailIds;

    /**
     * 核销明细与应付金额关联
     */
    @ApiModelProperty("核销明细与应付金额关联")
    Map<String,BigDecimal> auditDetailAmountRelationMap;

    @ApiModelProperty("报销项目所对应的流出资金和原因代码")
    private List<ReimburseFundsReasonMappingVo> reimburseFundsReasonMappingVos;

    @ApiModelProperty("付款单应付明细与核销明细关联集合")
    private List<PaymentReceiptShouldAuditRelationsVo> paymentReceiptShouldAuditRelationsVos;

}
