package com.biz.crm.tpm.business.payment.receipt.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * @author: chenlong
 * @date: 2022/12/6 20:00
 * @description: 付款单应付明细单位枚举
 */
public enum DateUnitTypeEnum {

    /**
     * 天
     */
    DAY("day", "天");

    @EnumValue
    @JsonValue
    private String code;
    private String des;

    DateUnitTypeEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return this.code;
    }

    public String getDes() {
        return this.des;
    }

    public static DateUnitTypeEnum codeToEnum(String code) {
        DateUnitTypeEnum unitTypeEnum = null;
        DateUnitTypeEnum[] var2 = values();

        for (DateUnitTypeEnum typeEnum : var2) {
            if (typeEnum.code.equals(code)) {
                unitTypeEnum = typeEnum;
            }
        }

        return unitTypeEnum;
    }
}
