package com.biz.crm.tpm.business.payment.receipt.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * @author: chenlong
 * @date: 2022/12/6 20:00
 * @description: 客商类型枚举
 */
public enum MerchantsTypeEnum {

    /**
     * 供应商
     */
    SUPPLIER("supplier", "供应商");

    @EnumValue
    @JsonValue
    private String code;
    private String des;

    MerchantsTypeEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return this.code;
    }

    public String getDes() {
        return this.des;
    }

    public static MerchantsTypeEnum codeToEnum(String code) {
        MerchantsTypeEnum merchantsTypeEnum = null;
        MerchantsTypeEnum[] var2 = values();

        for (MerchantsTypeEnum typeEnum : var2) {
            if (typeEnum.code.equals(code)) {
                merchantsTypeEnum = typeEnum;
            }
        }

        return merchantsTypeEnum;
    }
}
