package com.biz.crm.tpm.business.payment.receipt.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * @author: chenlong
 * @date: 2022/12/6 20:00
 * @description: 款项性质枚举
 */
public enum PaymentNatureTypeEnum {

    /**
     * 退款
     */
    REFUND("refund", "退款"),
    /**
     * 其他
     */
    OTHER("other", "其他");

    @EnumValue
    @JsonValue
    private String code;
    private String des;

    PaymentNatureTypeEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return this.code;
    }

    public String getDes() {
        return this.des;
    }

    public static PaymentNatureTypeEnum codeToEnum(String code) {
        PaymentNatureTypeEnum natureTypeEnum = null;
        PaymentNatureTypeEnum[] var2 = values();

        for (PaymentNatureTypeEnum typeEnum : var2) {
            if (typeEnum.code.equals(code)) {
                natureTypeEnum = typeEnum;
            }
        }

        return natureTypeEnum;
    }
}
