package com.biz.crm.tpm.business.payment.receipt.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * @author: chenlong
 * @date: 2022/12/6 20:00
 * @description: 保存类型枚举
 */
public enum SaveTypeEnum {

    /**
     * 暂存
     */
    TEMPORARY_SAVE("1", "暂存"),
    /**
     * 提交
     */
    SUBMIT("2", "提交");

    @EnumValue
    @JsonValue
    private String code;
    private String des;

    SaveTypeEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return this.code;
    }

    public String getDes() {
        return this.des;
    }

    public static SaveTypeEnum codeToEnum(String code) {
        SaveTypeEnum scopeTypeEnum = null;
        SaveTypeEnum[] var2 = values();

        for (SaveTypeEnum typeEnum : var2) {
            if (typeEnum.code.equals(code)) {
                scopeTypeEnum = typeEnum;
            }
        }

        return scopeTypeEnum;
    }
}
