package com.biz.crm.tpm.business.payment.receipt.sdk.event.log;

import com.biz.crm.tpm.business.payment.receipt.sdk.dto.PaymentReceiptLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * @author: chenlong
 * @date: 2022/11/14 10:21
 * @description: 付款单日志监听
 */
public interface PaymentReceiptEventListener extends NebulaEvent {

    /**
     * 创建事件
     *
     * @param eventDto 事件dto
     */
    void onCreate(PaymentReceiptLogEventDto eventDto);

    /**
     * 删除事件
     *
     * @param eventDto 事件dto
     */
    void onDelete(PaymentReceiptLogEventDto eventDto);

    /**
     * 更新日志
     *
     * @param eventDto 事件dto
     */
    void onUpdate(PaymentReceiptLogEventDto eventDto);

    /**
     * 启用
     *
     * @param eventDto 事件dto
     */
    void onEnable(PaymentReceiptLogEventDto eventDto);

    /**
     * 禁用
     *
     * @param eventDto 事件dto
     */
    void onDisable(PaymentReceiptLogEventDto eventDto);
}
