package com.biz.crm.tpm.business.payment.receipt.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.third.system.sd.sdk.dto.PaymentReceiptQueryStatusDto;
import com.biz.crm.tpm.business.payment.receipt.sdk.dto.PaymentReceiptAuditPayDto;
import com.biz.crm.tpm.business.payment.receipt.sdk.dto.PaymentReceiptDto;
import com.biz.crm.tpm.business.payment.receipt.sdk.dto.PaymentReceiptShouldDto;
import com.biz.crm.tpm.business.payment.receipt.sdk.vo.*;
import org.springframework.data.domain.Pageable;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author: chenlong
 * @date: 2022/12/5 11:35
 * @description: 付款单表(PaymentReceipt)表服务接口
 */
public interface PaymentReceiptSdkService {

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param dto      查询dto
     * @return 所有数据
     */
    Page<PaymentReceiptVo> findByConditions(Pageable pageable, PaymentReceiptDto dto);

    /**
     * 通过编码查询单条数据
     *
     * @param code 编码
     * @return 单条数据
     */
    PaymentReceiptVo findByCode(String code);

    /**
     * 通过核销编码查询付款的信息 并做修改
     * @param auditCode 核销编码
     * @return PaymentReceiptVo
     */
    PaymentReceiptVo findByAuditCode(String auditCode);

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    PaymentReceiptVo findById(String id);

    /**
     * 通过主键查询批量数据
     *
     * @param ids 主键集合
     * @return 单条数据
     */
    List<PaymentReceiptVo> findByIds(List<String> ids);

    /**
     * 通过主键查询批量数据
     *
     * @param codeList
     * @return 单条数据
     */
    List<PaymentReceiptVo> findByCodes(List<String> codeList);
    /**
     * 新增数据
     *
     * @param dto dto对象
     * @return PaymentReceiptVo
     */
    PaymentReceiptVo create(PaymentReceiptDto dto);

    /**
     * 修改数据
     *
     * @param dto dto对象
     * @return PaymentReceiptVo
     */
    PaymentReceiptVo update(PaymentReceiptDto dto);

    /**
     * 删除数据
     *
     * @param ids 主键结合
     */
    void delete(List<String> ids);

    /**
     * 启用
     *
     * @param ids 主键列表
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     *
     * @param ids 主键列表
     */
    void disableBatch(List<String> ids);

    /**
     * 根据核销明细编码,获取应付明细详细数据
     *
     * @param codeList 主键列表
     * @return 应付明细详细数据列表
     */
    LinkedList<PaymentReceiptShouldVo> getShouldDetailData(LinkedList<String> codeList);


    /**
     * 分页查询可付款的核销付款信息
     *
     * @param pageable 分页对象
     * @param dto      查询dto
     * @return 所有数据
     */
    Page<PaymentReceiptShouldVo> findAuditPayByConditions(Pageable pageable, PaymentReceiptAuditPayDto dto);

    /**
     * 分页查询可付款的核销付款信息(无付款方式条件)
     *
     * @param pageable 分页对象
     * @param dto      查询dto
     * @return 所有数据
     */
    Page<PaymentReceiptShouldVo> findAuditPayByConditionsWithoutPayType(Pageable pageable, PaymentReceiptAuditPayDto dto);


    /**
     * 推送付款收据
     *
     * @param paymentReceiptVo 付款收据vo
     */
    Result<String> pushPaymentReceiptToCe(PaymentReceiptVo paymentReceiptVo);

    /**
     * 按钮推送付款单到CE
     * @param ids
     */
    Map<String,String> pushPaymentReceiptToCE(List<String> ids);

    /**
     * 按钮推送付款单到SAP
     * @param ids
     */
    Map<String,String> pushPaymentReceiptToSAP(List<String> ids);

    /**
     * 按钮推送付款单到SAP
     * @param
     */
    Result<String> pushPaymentReceiptToSAP(PaymentReceiptVo receiptVo);

    /**
     * 查询CE状态
     */
    void queryPaymentReceiptECStatus(PaymentReceiptQueryStatusDto paymentReceiptQueryStatusDto);

    /**
     * 异步查询CE状态
     */
    void syncQueryPaymentReceiptECStatus(String body);

    /**
     * 根据报销项目编码查询报销项目数据
     * @param code
     * @return
     */
    ReimburseFundsReasonMappingVo findReimburseFundsReasonMappingByCode(String code);

    /**
     * 查询 付款单信息
     * @param auditCode 核销编码
     * @return PaymentReceiptVo
     */
    PaymentReceiptVo getPaymentReceiptByAuditCode(String auditCode);

    /**
     * 审批状态修改
     * @param paymentReceipt 参数
     */
    void updatePaymentReceiptProcess(PaymentReceiptDto paymentReceipt);

    /**
     * 自动推送付款单
     * @param id
     */
    void autoPushPaymentReceipt(String id);

    /**
     * 汇总应付明细数据
     *
     * @param dto dto对象
     * @return PaymentReceiptVo
     */
    List<PaymentReceiptShouldDto> summaryShouldInfo(PaymentReceiptDto dto);

    /**
     * 根据核销编码查询付款单信息
     * @param auditCodes 核销编码
     * @return List
     */
    List<PaymentReceiptShouldVo> findPaymentReceiptByAuditCode(List<String> auditCodes);

    /**
     * 审批状态修改
     * @param processNo 审批编码
     * @param processStats 状态
     * @param paymentReceiptCode 付款单编码
     */
    void updatePaymentReceiptProcess(String processNo, String processStats, String paymentReceiptCode);

    /**
     * 审批
     * @param auditId 核销Id
     */
    void paymentReceiptJoinProcess(String auditId);

    /**
     * 查询付款单应付信息
     * @param auditCodes 核销编码
     * @return List
     */
    List<PaymentReceiptShouldVo> findPaymentReceiptShouldByAuditCode(List<String> auditCodes);

    /**
     * 删除自动生成的付款单
     * @param auditCodes 核销编码
     */
    void deletePaymentReceiptByAuditCode(List<String> auditCodes);


    /**
     * 根据核销编码查应付明细
     *
     * @param codeSet
     * @return
     */
    List<PaymentReceiptShouldVo> findPaymentReceiptShouldByAuditCode(Set<String> codeSet);
    /**
     * 根据付款单编码查支付明细
     *
     * @param paymentReceiptCodes
     * @return
     */
    List<PaymentReceiptPayVo> findByPaymentReceiptCodes(Set<String> paymentReceiptCodes);

    List<MobilePaymentReceiptApprovedVo> mobilePaymentReceiptApproved(String processNo);
}
