package com.biz.crm.tpm.business.payment.receipt.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author: chenlong
 * @date: 2022/12/6 14:08
 * @description: 付款单-附件信息vo
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "PaymentReceiptFileVo", description = "付款单-附件信息vo")
public class PaymentReceiptFileVo extends TenantFlagOpVo {

    @ApiModelProperty(name = "付款单编码", notes = "付款单编码")
    private String paymentReceiptCode;

    @ApiModelProperty("文件唯一识别号")
    private String fileCode;

    @ApiModelProperty(name = "originalFileName", value = "原始文件名")
    private String originalFileName;

    @ApiModelProperty(name = "附件数")
    private Integer appendices;
}
