package com.biz.crm.tpm.business.payment.receipt.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author: chenlong
 * @date: 2022/12/6 9:59
 * @description: 付款单-支付明细vo
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "PaymentReceiptPayVo", description = "付款单-支付明细vo")
public class PaymentReceiptPayVo extends TenantFlagOpVo {

    @ApiModelProperty(name = "付款单编码", notes = "付款单编码")
    private String paymentReceiptCode;

    @ApiModelProperty(name = "支付明细编码", notes = "支付明细编码")
    private String payCode;

    @ApiModelProperty(name = "核销付款信息编码", notes = "核销付款信息编码")
    private String auditPayCode;

    @ApiModelProperty(name = "应付明细编码", notes = "应付明细编码")
    private String shouldCode;

    @ApiModelProperty(name = "支付摘要", notes = "支付摘要")
    private String paymentDigest;

    @ApiModelProperty(name = "支付摘要描述", notes = "支付摘要描述")
    private String paymentDigestName;

    @ApiModelProperty(name = "利润中心", notes = "利润中心")
    private String profitCenter;

    @ApiModelProperty(name = "资金流出项目", notes = "资金流出项目")
    private String capitalOutflowProject;

    @ApiModelProperty(name = "capitalOutflowProjectName", notes = "资金流出项目描述")
    private String capitalOutflowProjectName;

    @ApiModelProperty(name = "原因代码", notes = "原因代码")
    private String reasonCode;

    @ApiModelProperty(name = "reasonName", notes = "原因代码描述")
    private String reasonName;

    @ApiModelProperty(name = "序号", notes = "序号")
    private Integer sortNo;

    @ApiModelProperty(name = "付款金额", notes = "付款金额")
    private BigDecimal nowShouldPayMoney;

    /**
     * 报销项目映射关系
     */
    @ApiModelProperty(name = "报销项目映射关系", notes = "报销项目映射关系")
    List<ReimburseFundsReasonMappingVo> reimburseFundsReasonMappingVos;

    @ApiModelProperty("付款成功日期")
    private String paySuccessDate;

    @ApiModelProperty(name = "收款账号", notes = "收款账号")
    private String collectionAccount;

    @ApiModelProperty(name = "附件数")
    private Integer appendices;
}
