package com.biz.crm.tpm.business.payment.receipt.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;

/**
 * @author: chenlong
 * @date: 2022/12/5 20:19
 * @description: 付款单vo
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "PaymentReceiptShouldAuditRelationsVo", description = "vo")
public class PaymentReceiptShouldAuditRelationsVo extends TenantFlagOpVo {

    @ApiModelProperty(name = "核销明细ID", notes = "核销明细ID")
    private String auditDetailId;

    @ApiModelProperty(name = "应付明细编码", notes = "应付明细编码")
    private String shouldCode;

    @ApiModelProperty(name = "付款单编码 ", notes = "付款单编码")
    private String paymentReceiptCode;

    @ApiModelProperty(name = "本次应付金额（元）", notes = "本次应付金额（元）")
    private BigDecimal nowShouldPayMoney;

    @ApiModelProperty(name = "核销明细编码", notes = "核销明细编码")
    private String auditItemCode;

}
