/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.platform.customer.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.platform.customer.sdk.dto.PlatformCustomerDto;
import com.biz.crm.tpm.business.platform.customer.sdk.service.PlatformCustomerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/platformCustomer"})
@Api(tags={"\u5e73\u53f0\u5ba2\u6237"})
public class PlatformCustomerController {
    private static final Logger log = LoggerFactory.getLogger(PlatformCustomerController.class);
    @Autowired(required=false)
    private PlatformCustomerService platformCustomerService;

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{id}"})
    public Result<PlatformCustomerDto> findById(@PathVariable @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            PlatformCustomerDto platformCustomer = this.platformCustomerService.findById(id);
            return Result.ok((Object)platformCustomer);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public Result<PlatformCustomerDto> create(@ApiParam(name="platformCustomer", value="\u5e73\u53f0\u5ba2\u6237") @RequestBody PlatformCustomerDto platformCustomer) {
        try {
            PlatformCustomerDto result = this.platformCustomerService.create(platformCustomer);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PatchMapping
    public Result<PlatformCustomerDto> update(@ApiParam(name="platformCustomer", value="\u5e73\u53f0\u5ba2\u6237") @RequestBody PlatformCustomerDto platformCustomer) {
        try {
            PlatformCustomerDto result = this.platformCustomerService.update(platformCustomer);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"enable"})
    public Result<?> enable(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestBody List<String> ids) {
        try {
            this.platformCustomerService.enableBatch(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"disable"})
    public Result<?> disable(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestBody List<String> ids) {
        try {
            this.platformCustomerService.disableBatch(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    @DeleteMapping
    public Result<?> delete(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="ids") List<String> ids) {
        try {
            this.platformCustomerService.delete(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

