/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.platform.customer.local.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.platform.customer.local.mapper.PlatformCustomerMapper;
import com.biz.crm.tpm.business.platform.customer.sdk.dto.PlatformCustomerExportDto;
import com.biz.crm.tpm.business.platform.customer.sdk.vo.PlatformCustomerExportsVo;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class PlatformCustomerExportsProcess
implements ExportProcess<PlatformCustomerExportsVo> {
    @Autowired(required=false)
    private PlatformCustomerMapper platformCustomerMapper;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    public Integer getTotal(Map<String, Object> params) {
        PlatformCustomerExportDto dto = this.convertParams(params);
        Integer total = this.platformCustomerMapper.getExportTotal(dto);
        Validate.isTrue((total < CommonConstant.IE_EXPORT_MAX_TOTAL ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return total;
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        PlatformCustomerExportDto dto = this.convertParams(params);
        dto.setOffset(Integer.valueOf(this.getPageSize() * vo.getPageNo()));
        dto.setLimit(vo.getPageSize());
        List<PlatformCustomerExportsVo> data = this.platformCustomerMapper.findData(dto);
        this.adjustData(data);
        return JSON.parseArray((String)JSON.toJSONString(data));
    }

    public String getBusinessCode() {
        return "TPM_PLATFORM_CUSTOMER_EXPORT";
    }

    public String getBusinessName() {
        return "TPM\u5e73\u53f0\u5ba2\u6237\u5bfc\u51fa";
    }

    private PlatformCustomerExportDto convertParams(Map<String, Object> params) {
        PlatformCustomerExportDto dto = (PlatformCustomerExportDto)JSON.parseObject((String)JSON.toJSONString(params), PlatformCustomerExportDto.class);
        return dto;
    }

    private void adjustData(List<PlatformCustomerExportsVo> data) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        Map mapDict = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{"enable_status"}));
        for (PlatformCustomerExportsVo vo : data) {
            vo.setEnableStatus(this.findDictValue(mapDict, "enable_status", String.valueOf(vo.getEnableStatus())));
        }
    }

    private String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
        if (Objects.isNull(mapDict) || StringUtils.isBlank((CharSequence)dictTypeCode) || StringUtils.isBlank((CharSequence)code)) {
            return "";
        }
        List<DictDataVo> vos = mapDict.get(dictTypeCode);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(vos)) {
            return "";
        }
        Optional<String> first = vos.stream().filter(a -> a.getDictCode().equals(code)).map(DictDataVo::getDictValue).findFirst();
        return first.orElse("");
    }

    public Class<PlatformCustomerExportsVo> findCrmExcelVoClass() {
        return PlatformCustomerExportsVo.class;
    }
}

