/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.platform.customer.local.process;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.tpm.business.platform.customer.sdk.dto.PlatformCustomerDto;
import com.biz.crm.tpm.business.platform.customer.sdk.service.PlatformCustomerService;
import com.biz.crm.tpm.business.platform.customer.sdk.vo.PlatformCustomerImportsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class PlatformCustomerImportsProcess
implements ImportProcess<PlatformCustomerImportsVo> {
    private static final Logger log = LoggerFactory.getLogger(PlatformCustomerImportsProcess.class);
    @Autowired(required=false)
    private PlatformCustomerService platformCustomerService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;

    public Map<Integer, String> execute(LinkedHashMap<Integer, PlatformCustomerImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        log.info("\u5f00\u59cb\u5bfc\u5165......");
        Validate.notEmpty(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        log.info("\u5f00\u59cb\u5bfc\u5165\u6821\u9a8c......");
        List<PlatformCustomerDto> importList = this.validate(data);
        log.info("\u5bfc\u5165\u6821\u9a8c\u7ed3\u675f......");
        log.info("\u5f00\u59cb\u6267\u884c\u4fdd\u5b58......");
        this.platformCustomerService.importSave(importList);
        log.info("\u7ed3\u675f\u6267\u884c\u4fdd\u5b58......");
        return null;
    }

    private List<PlatformCustomerDto> validate(LinkedHashMap<Integer, PlatformCustomerImportsVo> data) {
        ArrayList<PlatformCustomerImportsVo> importList = new ArrayList<PlatformCustomerImportsVo>(data.values());
        ArrayList<PlatformCustomerDto> dtoList = new ArrayList<PlatformCustomerDto>(this.nebulaToolkitService.copyCollectionByWhiteList(importList, PlatformCustomerImportsVo.class, PlatformCustomerDto.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        log.info("\u4e00\u5171\u3010" + dtoList.size() + "\u3011\u6761\u6570\u636e\uff0c\u5ba2\u6237\u540d\u79f0\u3010" + ((PlatformCustomerDto)dtoList.get(0)).getCustomerName() + "\u3011......");
        log.info("\u5f00\u59cb\u975e\u7a7a\u6821\u9a8c......");
        dtoList.forEach(e -> {
            Validate.notNull((Object)e, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            e.setId(null);
            Validate.notBlank((CharSequence)e.getPlatformName(), (String)"\u5e73\u53f0\u540d\u79f0\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)e.getShop(), (String)"\u5e97\u94fa\u540d\u79f0\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)e.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)e.getAppKey(), (String)"appKey\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)e.getAppSecret(), (String)"appSecret\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)e.getUrl(), (String)"\u6388\u6743url\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        });
        log.info("\u7ed3\u675f\u975e\u7a7a\u6821\u9a8c......");
        log.info("\u5f00\u59cb\u67e5\u8be2\u6570\u636e\u5b57\u5178......");
        List dictDataVos = this.dictDataVoService.findByDictTypeCode("mdm_estore_platform");
        log.info("\u7ed3\u675f\u67e5\u8be2\u6570\u636e\u5b57\u5178......");
        Map<Object, Object> customerVoMap = new HashMap();
        log.info("\u5ba2\u6237set\u5f00\u59cb......");
        Set customerCodeSet = dtoList.stream().map(PlatformCustomerDto::getCustomerCode).filter(Objects::nonNull).collect(Collectors.toSet());
        log.info("\u5ba2\u6237set\u7ed3\u675f......");
        log.info("\u5ba2\u6237\u83b7\u53d6\u5f00\u59cb......");
        List customerVos = this.customerVoService.findByCustomerCodes(new ArrayList(customerCodeSet));
        log.info("\u5ba2\u6237\u83b7\u53d6\u7ed3\u675f......");
        log.info("\u5ba2\u6237\u5c01\u88c5\u5f00\u59cb......");
        if (CollectionUtils.isEmpty((Collection)customerVos)) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u4efb\u610f\u5ba2\u6237\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        customerVoMap = customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
        log.info("\u5ba2\u6237\u5c01\u88c5\u7ed3\u675f......");
        log.info("\u5f00\u59cb\u5173\u8054\u6570\u636e\u6821\u9a8c......");
        for (PlatformCustomerDto dto : dtoList) {
            if (!customerVoMap.containsKey(dto.getCustomerCode())) {
                throw new IllegalArgumentException("\u5ba2\u6237\u7f16\u7801\u3010" + dto.getCustomerCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            dto.setCustomerName(((CustomerVo)customerVoMap.get(dto.getCustomerCode())).getCustomerName());
            DictDataVo dictDataVo = dictDataVos.stream().filter(e -> e.getDictValue().equals(dto.getPlatformName())).findFirst().orElse(null);
            if (dictDataVo != null) {
                dto.setPlatformCode(dictDataVo.getDictCode());
                continue;
            }
            throw new IllegalArgumentException("\u5e73\u53f0\u540d\u79f0\u3010" + dto.getPlatformName() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        log.info("\u7ed3\u675f\u5173\u8054\u6570\u636e\u6821\u9a8c......");
        log.info("\u5f00\u59cb\u91cd\u590d\u6821\u9a8c......");
        Set setRepeat = dtoList.stream().map(e -> e.getPlatformCode() + "_" + e.getCustomerCode() + "_" + e.getShop() + "_" + e.getAppKey() + "_" + e.getAppSecret() + "_" + e.getUrl()).collect(Collectors.toSet());
        Validate.isTrue((setRepeat.size() == dtoList.size() ? 1 : 0) != 0, (String)"\u5b58\u5728\u91cd\u590d\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u4fdd\u5b58", (Object[])new Object[0]);
        log.info("\u7ed3\u675f\u91cd\u590d\u6821\u9a8c......");
        log.info("\u5f00\u59cb\u6570\u636e\u5e93\u91cd\u590d\u6821\u9a8c......");
        dtoList.forEach(e -> this.platformCustomerService.validateRepeatabilityOnCreate(e));
        log.info("\u7ed3\u675f\u6570\u636e\u5e93\u91cd\u590d\u6821\u9a8c......");
        return dtoList;
    }

    public Class<PlatformCustomerImportsVo> findCrmExcelVoClass() {
        return PlatformCustomerImportsVo.class;
    }

    public String getTemplateCode() {
        return "TPM_PLATFORM_CUSTOMER_IMPORT";
    }

    public String getTemplateName() {
        return "TPM\u5e73\u53f0\u5ba2\u6237\u5bfc\u5165";
    }

    public Integer getBatchCount() {
        return 10000;
    }
}

