/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.platform.customer.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.platform.customer.local.entity.PlatformCustomer;
import com.biz.crm.tpm.business.platform.customer.local.mapper.PlatformCustomerMapper;
import com.biz.crm.tpm.business.platform.customer.sdk.dto.PlatformCustomerDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class PlatformCustomerRepository
extends ServiceImpl<PlatformCustomerMapper, PlatformCustomer> {
    @Autowired(required=false)
    private PlatformCustomerMapper platformCustomerMapper;

    public void removePlatformCustomerByIds(List<String> idList) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, idList)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public void updateEnableStatusByIdIn(EnableStatusEnum enable, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"enable_status", (Object)enable.getCode());
        updateWrapper.in((Object)"id", ids);
        this.update((Wrapper)updateWrapper);
    }

    public List<PlatformCustomer> findOnCreate(PlatformCustomerDto dto) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(PlatformCustomer::getPlatformCode, (Object)dto.getPlatformCode())).eq(PlatformCustomer::getCustomerCode, (Object)dto.getCustomerCode())).eq(PlatformCustomer::getShop, (Object)dto.getShop())).eq(PlatformCustomer::getAppKey, (Object)dto.getAppKey())).eq(PlatformCustomer::getAppSecret, (Object)dto.getAppSecret())).eq(PlatformCustomer::getUrl, (Object)dto.getUrl())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).select(new SFunction[]{UuidEntity::getId}).list();
    }

    public List<PlatformCustomer> findOnUpdate(PlatformCustomerDto dto) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(PlatformCustomer::getPlatformCode, (Object)dto.getPlatformCode())).eq(PlatformCustomer::getCustomerCode, (Object)dto.getCustomerCode())).eq(PlatformCustomer::getShop, (Object)dto.getShop())).eq(PlatformCustomer::getAppKey, (Object)dto.getAppKey())).eq(PlatformCustomer::getAppSecret, (Object)dto.getAppSecret())).eq(PlatformCustomer::getUrl, (Object)dto.getUrl())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).ne(UuidEntity::getId, (Object)dto.getId())).select(new SFunction[]{UuidEntity::getId}).list();
    }
}

