/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.platform.customer.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.platform.customer.local.entity.PlatformCustomer;
import com.biz.crm.tpm.business.platform.customer.local.repository.PlatformCustomerRepository;
import com.biz.crm.tpm.business.platform.customer.sdk.dto.PlatformCustomerDto;
import com.biz.crm.tpm.business.platform.customer.sdk.dto.log.PlatformCustomerLogEventDto;
import com.biz.crm.tpm.business.platform.customer.sdk.event.log.PlatformCustomerLogEventListener;
import com.biz.crm.tpm.business.platform.customer.sdk.service.PlatformCustomerService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="platformCustomerService")
public class PlatformCustomerServiceImpl
implements PlatformCustomerService {
    @Autowired(required=false)
    private PlatformCustomerRepository platformCustomerRepository;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;

    public PlatformCustomerDto findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        PlatformCustomer entity = (PlatformCustomer)((Object)this.platformCustomerRepository.getById((Serializable)((Object)id)));
        if (entity == null) {
            return null;
        }
        return (PlatformCustomerDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, PlatformCustomerDto.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public PlatformCustomerDto create(PlatformCustomerDto platformCustomer) {
        this.createValidate(platformCustomer);
        List codeList = this.generateCodeService.generateCode("PC" + DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd"), 1, Integer.valueOf(5), 2L, TimeUnit.DAYS);
        platformCustomer.setPlatformCustomerCode((String)codeList.get(0));
        platformCustomer.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        platformCustomer.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        platformCustomer.setTenantCode(TenantUtils.getTenantCode());
        this.platformCustomerRepository.saveOrUpdate(this.nebulaToolkitService.copyObjectByWhiteList((Object)platformCustomer, PlatformCustomer.class, HashSet.class, ArrayList.class, new String[0]));
        PlatformCustomerLogEventDto logEventDto = new PlatformCustomerLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(platformCustomer);
        SerializableBiConsumer & Serializable onCreate = PlatformCustomerLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, PlatformCustomerLogEventListener.class, (SerializableBiConsumer)onCreate);
        return platformCustomer;
    }

    @Transactional(rollbackFor={Exception.class})
    public PlatformCustomerDto update(PlatformCustomerDto platformCustomer) {
        this.updateValidate(platformCustomer);
        platformCustomer.setPlatformCustomerCode(null);
        platformCustomer.setTenantCode(null);
        PlatformCustomer entityOld = (PlatformCustomer)((Object)this.platformCustomerRepository.getById((Serializable)((Object)platformCustomer.getId())));
        Validate.notNull((Object)((Object)entityOld), (String)"\u672a\u627e\u5230\u4fee\u6539\u7684\u6570\u636e", (Object[])new Object[0]);
        this.platformCustomerRepository.saveOrUpdate(this.nebulaToolkitService.copyObjectByWhiteList((Object)platformCustomer, PlatformCustomer.class, HashSet.class, ArrayList.class, new String[0]));
        PlatformCustomerLogEventDto logEventDto = new PlatformCustomerLogEventDto();
        logEventDto.setOriginal((PlatformCustomerDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entityOld, PlatformCustomerDto.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        logEventDto.setNewest(platformCustomer);
        SerializableBiConsumer & Serializable onUpdate = PlatformCustomerLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, PlatformCustomerLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return platformCustomer;
    }

    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u5f85\u542f\u7528\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List list = this.platformCustomerRepository.listByIds(ids);
        Validate.notEmpty((Collection)list, (String)"\u5f85\u542f\u7528\u7684\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664!", (Object[])new Object[0]);
        this.platformCustomerRepository.updateEnableStatusByIdIn(EnableStatusEnum.ENABLE, ids);
        Collection dtoList = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, PlatformCustomer.class, PlatformCustomerDto.class, HashSet.class, ArrayList.class, new String[0]);
        SerializableBiConsumer & Serializable onEnable = PlatformCustomerLogEventListener::onEnable;
        for (PlatformCustomerDto dto : dtoList) {
            PlatformCustomerLogEventDto logEventDto = new PlatformCustomerLogEventDto();
            logEventDto.setNewest(dto);
            dto.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            logEventDto.setOriginal(dto);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, PlatformCustomerLogEventListener.class, (SerializableBiConsumer)onEnable);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u5f85\u7981\u7528\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List configList = this.platformCustomerRepository.listByIds(ids);
        Validate.notEmpty((Collection)configList, (String)"\u5f85\u7981\u7528\u7684\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664!", (Object[])new Object[0]);
        this.platformCustomerRepository.updateEnableStatusByIdIn(EnableStatusEnum.DISABLE, ids);
        Collection dtoList = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)configList, PlatformCustomer.class, PlatformCustomerDto.class, HashSet.class, ArrayList.class, new String[0]);
        SerializableBiConsumer & Serializable onDisable = PlatformCustomerLogEventListener::onDisable;
        for (PlatformCustomerDto dto : dtoList) {
            PlatformCustomerLogEventDto logEventDto = new PlatformCustomerLogEventDto();
            logEventDto.setNewest(dto);
            dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            logEventDto.setOriginal(dto);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, PlatformCustomerLogEventListener.class, (SerializableBiConsumer)onDisable);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List list = this.platformCustomerRepository.listByIds(idList);
        Validate.notEmpty((Collection)list, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u4e3b\u952e\u96c6\u5408\u4fe1\u606f\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u6570\u636e", (Object[])new Object[0]);
        this.platformCustomerRepository.removePlatformCustomerByIds(idList);
        Collection dtoList = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, PlatformCustomer.class, PlatformCustomerDto.class, HashSet.class, ArrayList.class, new String[0]);
        SerializableBiConsumer & Serializable onDelete = PlatformCustomerLogEventListener::onDelete;
        for (PlatformCustomerDto dto : dtoList) {
            PlatformCustomerLogEventDto logEventDto = new PlatformCustomerLogEventDto();
            logEventDto.setOriginal(dto);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, PlatformCustomerLogEventListener.class, (SerializableBiConsumer)onDelete);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void importSave(List<PlatformCustomerDto> importList) {
        if (CollectionUtils.isEmpty(importList)) {
            return;
        }
        List codeList = this.generateCodeService.generateCode("PC" + DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd"), importList.size(), Integer.valueOf(5), 2L, TimeUnit.DAYS);
        for (int i = 0; i < importList.size(); ++i) {
            PlatformCustomerDto dto2 = importList.get(i);
            dto2.setPlatformCustomerCode((String)codeList.get(i));
            dto2.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            dto2.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            dto2.setTenantCode(TenantUtils.getTenantCode());
        }
        this.platformCustomerRepository.saveBatch(this.nebulaToolkitService.copyCollectionByWhiteList(importList, PlatformCustomerDto.class, PlatformCustomer.class, HashSet.class, ArrayList.class, new String[0]));
        importList.forEach(dto -> {
            PlatformCustomerLogEventDto logEventDto = new PlatformCustomerLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer & Serializable onCreate = PlatformCustomerLogEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, PlatformCustomerLogEventListener.class, (SerializableBiConsumer)onCreate);
        });
    }

    public void createValidate(PlatformCustomerDto platformCustomer) {
        Validate.notNull((Object)platformCustomer, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        platformCustomer.setId(null);
        this.commonValidate(platformCustomer);
        this.validateRepeatabilityOnCreate(platformCustomer);
    }

    private void updateValidate(PlatformCustomerDto platformCustomer) {
        Validate.notNull((Object)platformCustomer, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)platformCustomer.getId(), (String)"id\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.commonValidate(platformCustomer);
        this.validateRepeatabilityOnUpdate(platformCustomer);
    }

    public void validateRepeatabilityOnCreate(PlatformCustomerDto dto) {
        List<PlatformCustomer> list = this.platformCustomerRepository.findOnCreate(dto);
        Validate.isTrue((boolean)CollectionUtils.isEmpty(list), (String)"\u5b58\u5728\u91cd\u590d\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u4fdd\u5b58", (Object[])new Object[0]);
    }

    private void validateRepeatabilityOnUpdate(PlatformCustomerDto dto) {
        List<PlatformCustomer> list = this.platformCustomerRepository.findOnUpdate(dto);
        Validate.isTrue((boolean)CollectionUtils.isEmpty(list), (String)"\u5b58\u5728\u91cd\u590d\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u4fdd\u5b58", (Object[])new Object[0]);
    }

    private void commonValidate(PlatformCustomerDto platformCustomer) {
        Validate.notBlank((CharSequence)platformCustomer.getPlatformCode(), (String)"\u5e73\u53f0\u7f16\u7801\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)platformCustomer.getPlatformName(), (String)"\u5e73\u53f0\u540d\u79f0\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)platformCustomer.getShop(), (String)"\u5e97\u94fa\u540d\u79f0\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)platformCustomer.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)platformCustomer.getCustomerName(), (String)"\u5ba2\u6237\u540d\u79f0\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)platformCustomer.getAppKey(), (String)"appKey\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)platformCustomer.getAppSecret(), (String)"appSecret\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)platformCustomer.getUrl(), (String)"\u6388\u6743url\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

