package com.biz.crm.tpm.business.prepayment.details.local.dataview;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 *  活动预付明细 DataView
 *  * @author xiaoyoujun
 *  * @since 2022-11-21
 */
@Component
public class PrepaymentDetailsDateView implements DataviewRegister {

    @Override
    public String code() {
        return "tpm_prepayment_details_data_view";
    }

    @Override
    public String desc() {
        return "TPM-活动预付明细";
    }

    @Override
    public String buildSql() {
        return "SELECT t.*,DATE_FORMAT(t.prepayment_date,'%Y-%m') prepayment_date_str," +
                "  t2.process_status process_status_prepayment, t2.process_instance_id process_instance_id_prepayment " +
                "  FROM tpm_prepayment_details t" +
                "  LEFT JOIN tpm_event_prepayment t2 on t2.prepaid_coding=t.prepaid_coding" +
                "  WHERE t.del_flag = '" + EnableStatusEnum.ENABLE.getCode() + "' "+
                "  AND t.tenant_code = :tenantCode ";
    }
}
