package com.biz.crm.tpm.business.prepayment.details.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author xiaoyoujun
 * @date 2022年11月19日 10:22
 */
@ApiModel(value = "PrepaymentDetailsEntity", description = "TPM-活动预付明细")
@TableName("tpm_prepayment_details")
@Data
@Entity(name = "tpm_prepayment_details")
@Table(name = "tpm_prepayment_details", indexes = {
        @Index(name = "tpm_prepayment_details_index1", columnList = "prepaid_coding", unique = false),
        @Index(name = "tpm_prepayment_details_index2", columnList = "supplier_code", unique = false),
        @Index(name = "tpm_prepayment_details_index3", columnList = "activity_detail_no", unique = false),
        @Index(name = "tpm_prepayment_details_index4", columnList = "customer_code", unique = false),
})
@org.hibernate.annotations.Table(appliesTo = "tpm_prepayment_details", comment = "TPM-活动预付明细")
public class PrepaymentDetailsEntity extends TenantFlagOpEntity {


    /**
     * 预付编码
     */
    @ApiModelProperty(name = "prepaidCoding", value = "预付编码", notes = "预付编码")
    @Column(name = "prepaid_coding", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预付编码 '")
    private String prepaidCoding;

    /**
     * 预付名称
     */
    @ApiModelProperty(name = "prepaymentName", value = "预付名称", notes = "预付名称")
    @Column(name = "prepayment_name", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '预付名称 '")
    private String prepaymentName;

    /**
     * 预付类型
     */
    @ApiModelProperty(name = "prepaymentType", value = "预付类型", notes = "预付类型")
    @Column(name = "prepayment_type", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '预付类型 '")
    private String prepaymentType;

    /**
     * 预付年月
     */
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @ApiModelProperty(name = "prepaymentDate", value = "预付年月", notes = "预付年月")
    @Column(name = "prepayment_date", columnDefinition = "datetime COMMENT '预付年月 '")
    private Date prepaymentDate;

    /**
     * 返回单据编码
     */
    @ApiModelProperty(name = "returnDocCode", value = "返回单据编码", notes = "返回单据编码")
    @Column(name = "return_doc_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '返回单据编码 '")
    private String returnDocCode;

    /**
     * 业态
     */
    @ApiModelProperty(name = "businessFormatCode", value = "业态", notes = "业态")
    @Column(name = "business_format_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '业态 '")
    private String businessFormatCode;


    /**
     * 业务单元
     */
    @ApiModelProperty(name = "businessUnitName", value = "业务单元", notes = "业务单元")
    @Column(name = "business_unit_name", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '业务单元 '")
    private String businessUnitName;
    /**
     * 业务单元编码
     */
    @ApiModelProperty(name = "businessUnitCode", value = "业务单元编码", notes = "业务单元编码")
    @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元编码 '")
    private String businessUnitCode;


    @ApiModelProperty("客户编码")
    @Column(name = "customer_code", length = 64, columnDefinition = "varchar(64) COMMENT '客户编码'")
    private String customerCode;

    /**
     * 客户MDG编码
     */
    @ApiModelProperty("客户MDG编码")
    @Column(name = "customer_mdg_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户MDG编码'")
    private String customerMdgCode;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    @Column(name = "customer_name", columnDefinition = "varchar(255) COMMENT '客户名称'")
    private String customerName;

    /**
     * 供应商编码
     */
    @ApiModelProperty("供应商编码")
    @Column(name = "supplier_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '供应商编码'")
    private String supplierCode;

    /**
     * 供应商名称
     */
    @ApiModelProperty("供应商名称")
    @Column(name = "supplier_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '供应商名称'")
    private String supplierName;

    /**
     * 活动编号
     */
    @ApiModelProperty(name = "activityNo", value = "活动编号", notes = "活动编号")
    @Column(name = "activity_no", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动编号 '")
    private String activityNo;

    /**
     * 活动明细编号
     */
    @ApiModelProperty(name = "activityDetailNo", value = "活动明细编号", notes = "活动明细编号")
    @Column(name = "activity_detail_no", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动明细编号 '")
    private String activityDetailNo;

    /**
     * 活动申请金额
     */
    @ApiModelProperty(name = "activityApplicationAmount", value = "活动申请金额", notes = "活动申请金额")
    @Column(name = "activity_application_amount", columnDefinition = "decimal(24,6) COMMENT '活动申请金额'")
    private BigDecimal activityApplicationAmount;


    /**
     * 本次申请预付总额
     */
    @ApiModelProperty(name = "currentAmount", value = "本次申请预付总额", notes = "本次申请预付总额")
    @Column(name = "current_amount", columnDefinition = "decimal(24,6) COMMENT '本次申请预付总额'")
    private BigDecimal currentAmount;

    /**
     * 付款类型
     */
    @ApiModelProperty(name = "paymentType", value = "付款类型", notes = "付款类型")
    @Column(name = "payment_type", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '付款类型 '")
    private String paymentType;

    /**
     * 付款方式
     */
    @ApiModelProperty(name = "paymentMethod", value = "付款方式", notes = "付款方式")
    @Column(name = "payment_method", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '付款方式'")
    private String paymentMethod;

    /**
     * 已冲销金额
     */
    @ApiModelProperty(name = "reversedAmount", value = "已冲销金额", notes = "已冲销金额")
    @Column(name = "reversed_amount", columnDefinition = "decimal(24,6) COMMENT '已冲销金额'")
    private BigDecimal reversedAmount;


    /**
     * 待冲销金额
     */
    @ApiModelProperty(name = "amountWrittenOff", value = "待冲销金额", notes = "待冲销金额")
    @Column(name = "amount_written_off", columnDefinition = "decimal(24,6) COMMENT '待冲销金额'")
    private BigDecimal amountWrittenOff;


    /**
     * 预付原因
     */
    @ApiModelProperty(name = "prepaymentReason", value = "预付原因", notes = "待冲销金额")
    @Column(name = "prepayment_reason", columnDefinition = "varchar(128) COMMENT '预付原因'")
    private String prepaymentReason;

    /**
     * 流程编号
     */
    @ApiModelProperty("流程编号")
    @Column(name = "process_no", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '流程编号'")
    private String processNo;
    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    @Column(name = "process_status", nullable = true, length = 10, columnDefinition = "varchar(10) COMMENT '审批状态'")
    private String processStatus;
    /**
     * 销售组织编码
     */
    @ApiModelProperty(name = "salesOrgCode", value = "销售组织编码", notes = "销售组织编码")
    @Column(name = "sales_org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织编码 '")
    private String salesOrgCode;
    /**
     * 销售组织名称
     */
    @ApiModelProperty(name = "supplierName", value = "销售组织名称", notes = "销售组织名称")
    @Column(name = "sales_org_name", nullable = true, length = 200, columnDefinition = "VARCHAR(200) COMMENT '销售组织名称 '")
    private String salesOrgName;
    /**
     * 区域
     */
    @ApiModelProperty(name = "region", value = "区域", notes = "区域")
    @Column(name = "region", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '区域 '")
    private String region;
    /**
     * 活动形式编码
     */
    @ApiModelProperty(name = "activityFormCode", value = "活动形式编码", notes = "活动形式编码")
    @Column(name = "activity_form_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动形式编码 '")
    private String activityFormCode;
    /**
     * 活动形式名称
     */
    @ApiModelProperty(name = "activityFormName", value = "活动形式名称", notes = "活动形式名称")
    @Column(name = "activity_form_name", nullable = true, length = 200, columnDefinition = "VARCHAR(200) COMMENT '活动形式名称 '")
    private String activityFormName;
    /**
     * 活动类型编码
     */
    @ApiModelProperty(name = "activityTypeCode", value = "活动类型编码", notes = "活动类型编码")
    @Column(name = "activity_type_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动类型编码 '")
    private String activityTypeCode;
    /**
     * 活动类型名称
     */
    @ApiModelProperty(name = "activityTypeName", value = "活动类型名称", notes = "活动类型名称")
    @Column(name = "activity_type_name", nullable = true, length = 200, columnDefinition = "VARCHAR(200) COMMENT '活动类型名称 '")
    private String activityTypeName;

    @ApiModelProperty("零售商编码")
    @Column(name = "system_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '零售商编码 '")
    private String systemCode;

    @ApiModelProperty("零售商名称")
    @Column(name = "system_name", nullable = true, length = 200, columnDefinition = "VARCHAR(200) COMMENT '零售商名称 '")
    private String systemName;
    /**
     * 活动申请金额
     */
    @ApiModelProperty(name = "feeAmount", value = "活动申请金额", notes = "活动申请金额")
    @Column(name = "fee_amount", nullable = true, precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '活动申请金额 '")
    private BigDecimal feeAmount;

    /**
     * 组织编码
     */
    @ApiModelProperty(name = "组织编码", notes = "组织编码")
    @Column(name = "org_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '组织编码 '")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "组织名称", notes = "组织名称")
    @Column(name = "org_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '组织名称 '")
    private String orgName;

}
