package com.biz.crm.tpm.business.prepayment.details.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.prepayment.details.local.entity.PrepaymentDetailsEntity;
import com.biz.crm.tpm.business.prepayment.details.sdk.dto.PrepaymentDetailsDto;
import com.biz.crm.tpm.business.prepayment.details.sdk.vo.PrepaymentDetailsVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;


/**
 * 活动预付明细(PrepaymentDetailsEntity)表mybatis访问层
 *
 * @author xiaoyoujun
 * @date 2022年11月19日 11：25
 */
public interface PrepaymentDetailsMapper extends BaseMapper<PrepaymentDetailsEntity> {

    /**
     * 分页查询所有数据
     *
     * @param page 分页对象
     * @param prepaymentDetailsDto 查询实体
     * @return 所有数据
     */
    public Page<PrepaymentDetailsVo> findByPrepayments(@Param("page") Page<PrepaymentDetailsVo> page, @Param("dto") PrepaymentDetailsDto prepaymentDetailsDto);

    /**
     * 冲销或取消冲销预付单
     *
     * @param dtoList
     */
    void reversedOrBack(@Param("dtoList") List<PrepaymentDetailsDto> dtoList);

    List<PrepaymentDetailsVo> findUpwardForWithholding(@Param("beginDate") String beginDate,
                                                       @Param("endDate") String endDate,
                                                       @Param("dto") PrepaymentDetailsDto dto,
                                                       @Param("customerCodeInStrList") List<String> customerCodeInStrList);

    /**
     * 刷新预付单冲销金额
     *
     * @param prepaidCodingList
     */
    void refreshPrepaymentAmount(@Param("prepaidCodingList") List<String> prepaidCodingList);
}
