package com.biz.crm.tpm.business.prepayment.details.local.notifier;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.biz.crm.tpm.business.event.prepayment.local.enums.PayInAdvanceEnum;
import com.biz.crm.tpm.business.event.prepayment.sdk.event.EventPerpaymentEventListener;
import com.biz.crm.tpm.business.event.prepayment.sdk.vo.EventPrepaymentVo;
import com.biz.crm.tpm.business.prepayment.details.sdk.dto.PrepaymentDetailsDto;
import com.biz.crm.tpm.business.prepayment.details.sdk.service.PrepaymentDetailsService;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Component
public class EventPrepaymentEventListenerImpl implements EventPerpaymentEventListener {
    @Autowired(required = false)
    private PrepaymentDetailsService prepaymentDetailsService;

    @Override
    public void onCreate(EventPrepaymentVo vo) {

    }

    @Override
    public void onUpdate(EventPrepaymentVo oldVo, EventPrepaymentVo newVo) {

    }

    @Override
    public void onEnable(List<EventPrepaymentVo> list) {

    }

    @Override
    public void onDisable(List<EventPrepaymentVo> list) {

    }

    @Override
    public void onDelete(List<EventPrepaymentVo> list) {

    }

    @Override
    public void onUpdateProcessStatus(String processStatus,List<EventPrepaymentVo> list) {
        if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus) && CollectionUtil.isNotEmpty(list)){
            List<PrepaymentDetailsDto> prepaymentDetailes = new ArrayList<>(list.size());
            for (EventPrepaymentVo eventPrepaymentVo : list) {
                if (eventPrepaymentVo == null){
                    continue;
                }
                if (CollectionUtil.isNotEmpty(eventPrepaymentVo.getCustomerPrepayment()) && eventPrepaymentVo.getCustomerPrepayment() != null){
                    eventPrepaymentVo.getCustomerPrepayment().forEach(customerPrepayment -> {
                        PrepaymentDetailsDto prepaymentDetailsDto = new PrepaymentDetailsDto();
                        //头表数据
                        prepaymentDetailsDto.setPrepaidCoding(eventPrepaymentVo.getPrepaidCoding());
                        prepaymentDetailsDto.setPrepaymentName(eventPrepaymentVo.getPrepaymentName());
                        prepaymentDetailsDto.setPrepaymentType(eventPrepaymentVo.getPrepaymentType());
                        prepaymentDetailsDto.setPrepaymentDate(DateUtil.parse(eventPrepaymentVo.getPrepaymentDate(),"yyyy-MM"));
                        prepaymentDetailsDto.setBusinessFormatCode(eventPrepaymentVo.getBusinessFormatCode());
                        prepaymentDetailsDto.setBusinessUnitName(eventPrepaymentVo.getBusinessUnitName());
                        prepaymentDetailsDto.setBusinessUnitCode(eventPrepaymentVo.getBusinessUnitCode());
                        prepaymentDetailsDto.setActivityApplicationAmount(eventPrepaymentVo.getActivityApplicationAmount());
                        prepaymentDetailsDto.setPaymentType(eventPrepaymentVo.getPrepaymentType());
                        prepaymentDetailsDto.setPaymentMethod(eventPrepaymentVo.getPaymentMethod());
                        prepaymentDetailsDto.setPrepaymentReason(eventPrepaymentVo.getRemark());
                        prepaymentDetailsDto.setOrgCode(eventPrepaymentVo.getOrgCode());
                        prepaymentDetailsDto.setOrgName(eventPrepaymentVo.getOrgName());

                        //明细数据
                        prepaymentDetailsDto.setCustomerCode(customerPrepayment.getCustomerCode());
                        prepaymentDetailsDto.setCustomerMdgCode(customerPrepayment.getCustomerMdgCode());
                        prepaymentDetailsDto.setCustomerName(customerPrepayment.getCustomerName());
                        prepaymentDetailsDto.setSupplierCode(customerPrepayment.getSupplierCode());
                        prepaymentDetailsDto.setSupplierName(customerPrepayment.getSupplierName());
                        prepaymentDetailsDto.setActivityNo(customerPrepayment.getActivityCode());
                        prepaymentDetailsDto.setActivityDetailNo(customerPrepayment.getActivityDetailItemCode());
                        prepaymentDetailsDto.setCurrentAmount(customerPrepayment.getPrepaidAmount());
                        prepaymentDetailsDto.setFeeAmount(customerPrepayment.getFeeAmount());
                        prepaymentDetailsDto.setTenantCode(TenantUtils.getTenantCode());
                        prepaymentDetailsDto.setActivityFormCode(customerPrepayment.getActivityFormCode());
                        prepaymentDetailsDto.setActivityFormName(customerPrepayment.getActivityFormName());
                        prepaymentDetailsDto.setActivityTypeCode(customerPrepayment.getActivityTypeCode());
                        prepaymentDetailsDto.setActivityTypeName(customerPrepayment.getActivityTypeName());
                        prepaymentDetailsDto.setSalesOrgCode(customerPrepayment.getSalesOrgCode());
                        prepaymentDetailsDto.setSalesOrgName(customerPrepayment.getSalesOrgName());
                        prepaymentDetailsDto.setAmountWrittenOff(prepaymentDetailsDto.getCurrentAmount());
                        prepaymentDetailsDto.setReversedAmount(BigDecimal.ZERO);
                        //不确定活动预付零售商字段
                        prepaymentDetailsDto.setSystemCode(StringUtils.isNotEmpty(customerPrepayment.getCustomerRetailerCode()) ? customerPrepayment.getCustomerRetailerCode() : customerPrepayment.getSystemCode());
                        prepaymentDetailsDto.setSystemName(StringUtils.isNotEmpty(customerPrepayment.getCustomerRetailerName()) ? customerPrepayment.getCustomerRetailerName() : customerPrepayment.getSystemName());
                        prepaymentDetailsDto.setRegion(customerPrepayment.getRegion());

                        prepaymentDetailes.add(prepaymentDetailsDto);
                    });
                }
            }
            if (CollectionUtil.isNotEmpty(prepaymentDetailes)){
                prepaymentDetailsService.create(prepaymentDetailes);
            }
        }
    }
}
