/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.prepayment.details.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.prepayment.details.sdk.dto.PrepaymentDetailsDto;
import com.biz.crm.tpm.business.prepayment.details.sdk.service.PrepaymentDetailsService;
import com.biz.crm.tpm.business.prepayment.details.sdk.vo.BeachPrepaymentDetailsVo;
import com.biz.crm.tpm.business.prepayment.details.sdk.vo.PrepaymentDetailsVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/prepayment/details"})
@Api(tags={"\u6d3b\u52a8\u9884\u4ed8\u660e\u7ec6"})
public class PrepaymentDetailsController {
    private static final Logger log = LoggerFactory.getLogger(PrepaymentDetailsController.class);
    @Autowired(required=false)
    private PrepaymentDetailsService prepaymentDetailsService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByPrepayments"})
    public Result<Page<PrepaymentDetailsVo>> findByPrepayments(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="prepaymentDetailsDto", value="\u6d3b\u52a8\u9884\u4ed8\u660e\u7ec6") PrepaymentDetailsDto prepaymentDetailsDto) {
        try {
            Page page = this.prepaymentDetailsService.findByPrepayments(pageable, prepaymentDetailsDto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u4f9b\u5e94\u5546\u7f16\u7801\u67e5\u8be2\u4f9b\u5e94\u5546\u9884\u4ed8\u660e\u7ec6")
    @GetMapping(value={"findBySupplierCode"})
    public Result<List<BeachPrepaymentDetailsVo>> findBySupplierCode(@ApiParam(name="supplierCode", value="\u4f9b\u5e94\u5546\u7f16\u7801", required=true) Set<String> supplierCodes) {
        try {
            return Result.ok((Object)this.prepaymentDetailsService.findBySupplierCode(supplierCodes));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u5f85\u51b2\u9500\u91d1\u989d\u6c47\u603b")
    @PostMapping(value={"getAmountWrittenOff"})
    public Result<List<PrepaymentDetailsVo>> getAmountWrittenOff(@ApiParam(name="dtoList", value="dto\u96c6\u5408") @RequestBody List<PrepaymentDetailsDto> dtoList) {
        try {
            return Result.ok((Object)this.prepaymentDetailsService.getAmountWrittenOff(dtoList));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u9884\u4ed8\u91d1\u989d\u548c\u5df2\u51b2\u9500\u9884\u4ed8\u91d1\u989d")
    @PostMapping(value={"getPrepayReversedAmount"})
    public Result<List<PrepaymentDetailsVo>> getPrepayReversedAmount(@ApiParam(name="dtoList", value="dto\u96c6\u5408") @RequestBody List<PrepaymentDetailsDto> dtoList) {
        try {
            return Result.ok((Object)this.prepaymentDetailsService.getPrepayReversedAmount(dtoList));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u51b2\u9500\u6216\u53d6\u6d88\u51b2\u9500\u9884\u4ed8\u5355")
    @PostMapping(value={"reversedOrBack"})
    public Result<?> reversedOrBack(@ApiParam(name="dtoList", value="dto\u96c6\u5408") @RequestBody List<PrepaymentDetailsDto> dtoList) {
        try {
            this.prepaymentDetailsService.reversedOrBack(dtoList);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

