/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.prepayment.details.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.prepayment.details.local.entity.PrepaymentDetailsEntity;
import com.biz.crm.tpm.business.prepayment.details.local.mapper.PrepaymentDetailsMapper;
import com.biz.crm.tpm.business.prepayment.details.sdk.dto.PrepaymentDetailsDto;
import com.biz.crm.tpm.business.prepayment.details.sdk.vo.BeachPrepaymentDetailsVo;
import com.biz.crm.tpm.business.prepayment.details.sdk.vo.PrepaymentDetailsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class PrepaymentDetailsRepository
extends ServiceImpl<PrepaymentDetailsMapper, PrepaymentDetailsEntity> {
    private static final Logger log = LoggerFactory.getLogger(PrepaymentDetailsRepository.class);
    @Resource
    private PrepaymentDetailsMapper prepaymentDetailsMapper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Page<PrepaymentDetailsVo> findByPrepayments(Pageable pageable, PrepaymentDetailsDto prepaymentDetailsDto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<PrepaymentDetailsVo> pageList = this.prepaymentDetailsMapper.findByPrepayments((Page<PrepaymentDetailsVo>)page, prepaymentDetailsDto);
        return pageList;
    }

    public List<BeachPrepaymentDetailsVo> findBySupplierCode(Set<String> supplierCodes) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(PrepaymentDetailsEntity::getSupplierCode, supplierCodes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        ArrayList prepaymentDetailsVoList = CollectionUtils.isEmpty((Collection)list) ? new ArrayList() : new ArrayList(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, PrepaymentDetailsEntity.class, PrepaymentDetailsVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        ArrayList<BeachPrepaymentDetailsVo> beachPrepaymentDetailsVoList = new ArrayList<BeachPrepaymentDetailsVo>();
        Map<String, List<PrepaymentDetailsVo>> collect = prepaymentDetailsVoList.stream().collect(Collectors.groupingBy(PrepaymentDetailsVo::getSupplierCode));
        collect.forEach((key, value) -> {
            BeachPrepaymentDetailsVo beachPrepaymentDetailsVo = new BeachPrepaymentDetailsVo();
            beachPrepaymentDetailsVo.setSupplierCode(key);
            beachPrepaymentDetailsVo.setPrepaymentDetailsList(value);
            beachPrepaymentDetailsVoList.add(beachPrepaymentDetailsVo);
        });
        return beachPrepaymentDetailsVoList;
    }

    public BigDecimal getAmountWrittenOff(PrepaymentDetailsDto prepaymentDetailsDto, String type) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"del_flag", (Object)DelFlagStatusEnum.NORMAL.getCode())).select(new String[]{"IFNULL(sum(amount_written_off),0) as total"});
        if ("ActivityDetailNo".equals(type)) {
            queryWrapper.eq((Object)"activity_detail_no", (Object)prepaymentDetailsDto.getActivityDetailNo());
        } else {
            queryWrapper.eq((Object)"customer_code", (Object)prepaymentDetailsDto.getCustomerCode());
        }
        Map map = this.getMap((Wrapper)queryWrapper);
        return (BigDecimal)map.get("total");
    }

    public Map<String, BigDecimal> findSumAmountWrittenOffByActivityDetailNos(List<String> activityDetailNos) {
        HashMap map = Maps.newHashMap();
        if (CollectionUtils.isEmpty(activityDetailNos)) {
            return map;
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(PrepaymentDetailsEntity::getActivityDetailNo, activityDetailNos)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        Map<String, List<PrepaymentDetailsEntity>> collect = list.stream().collect(Collectors.groupingBy(PrepaymentDetailsEntity::getActivityDetailNo));
        collect.forEach((key, value) -> map.put(key, value.stream().map(PrepaymentDetailsEntity::getAmountWrittenOff).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)));
        return map;
    }

    public Map<String, BigDecimal> findSumAmountWrittenOffByCustomerCodes(List<String> customerCodes) {
        HashMap map = Maps.newHashMap();
        if (CollectionUtils.isEmpty(customerCodes)) {
            return map;
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(PrepaymentDetailsEntity::getCustomerCode, customerCodes)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        Map<String, List<PrepaymentDetailsEntity>> collect = list.stream().collect(Collectors.groupingBy(PrepaymentDetailsEntity::getCustomerCode));
        collect.forEach((key, value) -> map.put(key, value.stream().map(PrepaymentDetailsEntity::getAmountWrittenOff).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)));
        return map;
    }

    public List<PrepaymentDetailsVo> getPrepayReversedAmount(PrepaymentDetailsDto prepaymentDetailsDto) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(PrepaymentDetailsEntity::getPrepaidCoding, (Object)prepaymentDetailsDto.getPrepaidCoding())).eq(PrepaymentDetailsEntity::getSupplierCode, (Object)prepaymentDetailsDto.getSupplierCode())).list();
        return CollectionUtils.isEmpty((Collection)list) ? new ArrayList<PrepaymentDetailsVo>() : new ArrayList(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, PrepaymentDetailsEntity.class, PrepaymentDetailsVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
    }

    public void reversedOrBack(List<PrepaymentDetailsDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        for (PrepaymentDetailsDto prepaymentDetailsDto : dtoList) {
            PrepaymentDetailsEntity one = (PrepaymentDetailsEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(PrepaymentDetailsEntity::getPrepaidCoding, (Object)prepaymentDetailsDto.getPrepaidCoding())).eq(PrepaymentDetailsEntity::getSupplierCode, (Object)prepaymentDetailsDto.getSupplierCode())).one());
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(PrepaymentDetailsEntity::getPrepaidCoding, (Object)prepaymentDetailsDto.getPrepaidCoding())).eq(PrepaymentDetailsEntity::getSupplierCode, (Object)prepaymentDetailsDto.getSupplierCode())).set(PrepaymentDetailsEntity::getAmountWrittenOff, (Object)Optional.ofNullable(one.getAmountWrittenOff()).orElse(BigDecimal.ZERO).subtract(prepaymentDetailsDto.getReversedAmount()))).set(PrepaymentDetailsEntity::getReversedAmount, (Object)Optional.ofNullable(one.getReversedAmount()).orElse(BigDecimal.ZERO).add(prepaymentDetailsDto.getReversedAmount()));
        }
    }

    public void updateReversedAmount(List<PrepaymentDetailsDto> dtoList) {
        for (PrepaymentDetailsDto prepaymentDetailsDto : dtoList) {
            List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotBlank((CharSequence)prepaymentDetailsDto.getActivityDetailNo()), PrepaymentDetailsEntity::getActivityDetailNo, (Object)prepaymentDetailsDto.getActivityDetailNo())).eq(StringUtils.isBlank((CharSequence)prepaymentDetailsDto.getActivityDetailNo()) && StringUtils.isNotEmpty((CharSequence)prepaymentDetailsDto.getCustomerCode()), PrepaymentDetailsEntity::getCustomerCode, (Object)prepaymentDetailsDto.getCustomerCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
            Validate.notNull((Object)list, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6d3b\u52a8\u9884\u4ed8\u660e\u7ec6", (Object[])new Object[0]);
            list = list.stream().sorted(Comparator.comparing(UuidOpEntity::getCreateTime)).collect(Collectors.toList());
            BigDecimal auditReversedAmount = prepaymentDetailsDto.getReversedAmount();
            ArrayList<PrepaymentDetailsEntity> updateList = new ArrayList<PrepaymentDetailsEntity>();
            HashSet<String> prepaidCodingSet = new HashSet<String>();
            for (PrepaymentDetailsEntity entity : list) {
                PrepaymentDetailsEntity entityUpdate = new PrepaymentDetailsEntity();
                entityUpdate.setId(entity.getId());
                prepaidCodingSet.add(entity.getPrepaidCoding());
                if (auditReversedAmount.compareTo(entity.getAmountWrittenOff()) <= 0) {
                    entityUpdate.setReversedAmount(entity.getReversedAmount().add(auditReversedAmount));
                    entityUpdate.setAmountWrittenOff(entity.getAmountWrittenOff().subtract(auditReversedAmount));
                    updateList.add(entityUpdate);
                    break;
                }
                entityUpdate.setReversedAmount(entity.getReversedAmount().add(entity.getAmountWrittenOff()));
                entityUpdate.setAmountWrittenOff(BigDecimal.ZERO);
                updateList.add(entityUpdate);
            }
            this.updateBatchById(updateList);
            this.refreshPrepaymentAmount(new ArrayList<String>(prepaidCodingSet));
        }
    }

    public void refreshPrepaymentAmount(List<String> prepaidCodingList) {
        List partition = Lists.partition(prepaidCodingList, (int)500);
        for (List part : partition) {
            this.prepaymentDetailsMapper.refreshPrepaymentAmount(part);
        }
    }

    public List<PrepaymentDetailsEntity> findForWithholding(String beginDate, String endDate, PrepaymentDetailsDto prepaymentDetailsDto) {
        if (prepaymentDetailsDto != null) {
            return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().ge(StringUtils.isNotEmpty((CharSequence)beginDate), PrepaymentDetailsEntity::getPrepaymentDate, (Object)beginDate)).lt(StringUtils.isNotEmpty((CharSequence)endDate), PrepaymentDetailsEntity::getPrepaymentDate, (Object)endDate)).eq(PrepaymentDetailsEntity::getBusinessUnitCode, (Object)prepaymentDetailsDto.getBusinessUnitCode())).eq(StringUtils.isNotEmpty((CharSequence)prepaymentDetailsDto.getCustomerCode()), PrepaymentDetailsEntity::getCustomerCode, (Object)prepaymentDetailsDto.getCustomerCode())).eq(StringUtils.isNotEmpty((CharSequence)prepaymentDetailsDto.getSalesOrgCode()), PrepaymentDetailsEntity::getSalesOrgCode, (Object)prepaymentDetailsDto.getSalesOrgCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).ne(PrepaymentDetailsEntity::getBusinessUnitCode, (Object)BusinessUnitEnum.HEADQUARTERS.getCode())).ne(PrepaymentDetailsEntity::getAmountWrittenOff, (Object)BigDecimal.ZERO)).list();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().ge(StringUtils.isNotEmpty((CharSequence)beginDate), PrepaymentDetailsEntity::getPrepaymentDate, (Object)beginDate)).lt(StringUtils.isNotEmpty((CharSequence)endDate), PrepaymentDetailsEntity::getPrepaymentDate, (Object)endDate)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).ne(PrepaymentDetailsEntity::getBusinessUnitCode, (Object)BusinessUnitEnum.HEADQUARTERS.getCode())).ne(PrepaymentDetailsEntity::getAmountWrittenOff, (Object)BigDecimal.ZERO)).list();
    }

    public List<PrepaymentDetailsVo> findUpwardForWithholding(String beginDate, String endDate, PrepaymentDetailsDto dto, List<String> customerCodeInStrList) {
        return this.prepaymentDetailsMapper.findUpwardForWithholding(beginDate, endDate, dto, customerCodeInStrList);
    }
}

