/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.prepayment.details.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgSubComOrgService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.prepayment.details.local.entity.PrepaymentDetailsEntity;
import com.biz.crm.tpm.business.prepayment.details.local.repository.PrepaymentDetailsRepository;
import com.biz.crm.tpm.business.prepayment.details.sdk.dto.PrepaymentDetailsDto;
import com.biz.crm.tpm.business.prepayment.details.sdk.service.PrepaymentDetailsService;
import com.biz.crm.tpm.business.prepayment.details.sdk.vo.BeachPrepaymentDetailsVo;
import com.biz.crm.tpm.business.prepayment.details.sdk.vo.PrepaymentDetailsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service(value="prepaymentDetailsService")
public class PrepaymentDetailsServiceImpl
implements PrepaymentDetailsService {
    private static final Logger log = LoggerFactory.getLogger(PrepaymentDetailsServiceImpl.class);
    @Autowired(required=false)
    private PrepaymentDetailsRepository prepaymentDetailsRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private SalesOrgSubComOrgService salesOrgSubComOrgService;
    @Autowired
    private CustomerVoService customerVoService;

    public Page<PrepaymentDetailsVo> findByPrepayments(Pageable pageable, PrepaymentDetailsDto prepaymentDetailsDto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(prepaymentDetailsDto)) {
            prepaymentDetailsDto = new PrepaymentDetailsDto();
        }
        return this.prepaymentDetailsRepository.findByPrepayments(pageable, prepaymentDetailsDto);
    }

    @Transactional(rollbackFor={Exception.class})
    public void create(List<PrepaymentDetailsDto> dtoList) {
        Assert.notEmpty(dtoList, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        Collection entityList = this.nebulaToolkitService.copyCollectionByWhiteList(dtoList, PrepaymentDetailsDto.class, PrepaymentDetailsEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.prepaymentDetailsRepository.saveOrUpdateBatch(entityList);
    }

    public List<BeachPrepaymentDetailsVo> findBySupplierCode(Set<String> supplierCodes) {
        return this.prepaymentDetailsRepository.findBySupplierCode(supplierCodes);
    }

    public List<PrepaymentDetailsVo> getAmountWrittenOff(List<PrepaymentDetailsDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return new ArrayList<PrepaymentDetailsVo>();
        }
        ArrayList<PrepaymentDetailsVo> voList = new ArrayList<PrepaymentDetailsVo>();
        for (PrepaymentDetailsDto dto : dtoList) {
            BigDecimal amountWrittenOff;
            PrepaymentDetailsVo vo = new PrepaymentDetailsVo();
            if (StringUtils.isNotBlank((CharSequence)dto.getActivityDetailNo())) {
                amountWrittenOff = this.prepaymentDetailsRepository.getAmountWrittenOff(dto, "ActivityDetailNo");
            } else {
                if (!StringUtils.isNotBlank((CharSequence)dto.getCustomerCode())) continue;
                amountWrittenOff = this.prepaymentDetailsRepository.getAmountWrittenOff(dto, "CustomerCode");
            }
            vo.setActivityDetailNo(dto.getActivityDetailNo());
            vo.setCustomerCode(dto.getCustomerCode());
            vo.setAmountWrittenOff(amountWrittenOff);
            voList.add(vo);
        }
        return voList;
    }

    public List<PrepaymentDetailsVo> getAmountWrittenOff2(List<PrepaymentDetailsDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return new ArrayList<PrepaymentDetailsVo>();
        }
        List<String> activityDetailNos = dtoList.stream().map(PrepaymentDetailsDto::getActivityDetailNo).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
        List<String> customerCodes = dtoList.stream().map(PrepaymentDetailsDto::getCustomerCode).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
        Map<Object, Object> activityDetailPrepaymentAmountMap = new HashMap();
        Map<Object, Object> customerCodePrepaymentAmountMap = new HashMap();
        if (!CollectionUtils.isEmpty(activityDetailNos)) {
            activityDetailPrepaymentAmountMap = this.prepaymentDetailsRepository.findSumAmountWrittenOffByActivityDetailNos(activityDetailNos);
        }
        if (!CollectionUtils.isEmpty(customerCodes)) {
            customerCodePrepaymentAmountMap = this.prepaymentDetailsRepository.findSumAmountWrittenOffByCustomerCodes(customerCodes);
        }
        ArrayList<PrepaymentDetailsVo> voList = new ArrayList<PrepaymentDetailsVo>();
        for (PrepaymentDetailsDto dto : dtoList) {
            BigDecimal amountWrittenOff;
            PrepaymentDetailsVo vo = new PrepaymentDetailsVo();
            if (StringUtils.isNotBlank((CharSequence)dto.getActivityDetailNo())) {
                amountWrittenOff = (BigDecimal)activityDetailPrepaymentAmountMap.get(dto.getActivityDetailNo());
            } else {
                if (!StringUtils.isNotBlank((CharSequence)dto.getCustomerCode())) continue;
                amountWrittenOff = (BigDecimal)customerCodePrepaymentAmountMap.get(dto.getCustomerCode());
            }
            vo.setActivityDetailNo(dto.getActivityDetailNo());
            vo.setCustomerCode(dto.getCustomerCode());
            vo.setAmountWrittenOff(amountWrittenOff);
            voList.add(vo);
        }
        return voList;
    }

    public List<PrepaymentDetailsVo> getPrepayReversedAmount(List<PrepaymentDetailsDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return new ArrayList<PrepaymentDetailsVo>();
        }
        ArrayList<PrepaymentDetailsVo> voListAll = new ArrayList<PrepaymentDetailsVo>();
        for (PrepaymentDetailsDto dto : dtoList) {
            Validate.notBlank((CharSequence)dto.getPrepaidCoding(), (String)"\u9884\u4ed8\u7f16\u7801, \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)dto.getSupplierCode(), (String)"\u4f9b\u5e94\u5546\u7f16\u7801, \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            voListAll.addAll(this.prepaymentDetailsRepository.getPrepayReversedAmount(dto));
        }
        return voListAll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public void reversedOrBack(List<PrepaymentDetailsDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        HashSet<String> lockList = new HashSet<String>();
        for (PrepaymentDetailsDto dto : dtoList) {
            Validate.notBlank((CharSequence)dto.getPrepaidCoding(), (String)"\u9884\u4ed8\u7f16\u7801, \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)dto.getSupplierCode(), (String)"\u4f9b\u5e94\u5546\u7f16\u7801, \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            lockList.add(dto.getPrepaidCoding() + dto.getSupplierCode());
        }
        boolean lockSuccess = this.redisLockService.batchLock("tpm:prepayment_details:lock:", new ArrayList(lockList), TimeUnit.MINUTES, 5);
        Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
        try {
            this.prepaymentDetailsRepository.reversedOrBack(dtoList);
        }
        finally {
            this.redisLockService.batchUnLock("tpm:prepayment_details:lock:", new ArrayList(lockList));
        }
    }

    public void updateReversedAmount(List<PrepaymentDetailsDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        for (PrepaymentDetailsDto dto : dtoList) {
            Validate.notNull((Object)dto.getReversedAmount(), (String)"\u51b2\u9500\u91d1\u989d, \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            if (!StringUtils.isBlank((CharSequence)dto.getActivityDetailNo()) || !StringUtils.isBlank((CharSequence)dto.getCustomerCode())) continue;
            throw new IllegalArgumentException("\u6d3b\u52a8\u660e\u7ec6\u7f16\u53f7\u548c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        this.prepaymentDetailsRepository.updateReversedAmount(dtoList);
    }

    public List<PrepaymentDetailsVo> findForWithholding(String beginDate, String endDate, PrepaymentDetailsDto prepaymentDetailsDto) {
        List<PrepaymentDetailsEntity> entityList = this.prepaymentDetailsRepository.findForWithholding(beginDate, endDate, prepaymentDetailsDto);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(entityList, PrepaymentDetailsEntity.class, PrepaymentDetailsVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public List<PrepaymentDetailsVo> findUpwardForWithholding(String beginDate, String endDate, PrepaymentDetailsDto dto) {
        return new ArrayList<PrepaymentDetailsVo>();
    }
}

