package com.biz.crm.tpm.business.promotion.plan.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.ActualProfitLossService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 损益实际
 *
 * @author: yaoyongming
 * @date: 2023/2/14 10:10
 */
@RestController
@RequestMapping("/v1/actualProfitLoss")
@Slf4j
@Api(tags = "损益实际")
public class ActualProfitLossController {
    /**
     * 服务对象
     */
    @Autowired(required = false)
    private ActualProfitLossService actualProfitLossService;

    /**
     * 删除数据
     *
     * @param ids 主键结合
     * @return 删除结果
     */
    @ApiOperation(value = "删除数据")
    @DeleteMapping
    public Result<?> delete(@ApiParam(name = "ids", value = "主键集合") @RequestParam("ids") List<String> ids) {
        try {
            this.actualProfitLossService.delete(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
