package com.biz.crm.tpm.business.promotion.plan.local.controller;



import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionPlanTableFormService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanTableFormVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PurchaseSaleVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 平台维度电商的促销规划一览汇总表(PromotionPlanTableForm)表相关的http接口
 *
 * @author cyj
 * @since 2022-11-02 18:14:37
 */
@RestController
@RequestMapping("/v1/PromotionPlanTableForm")
@Slf4j
@Api(tags = "平台维度电商的促销规划一览汇总表")
public class PromotionPlanTableFormController {

    @Autowired(required = false)
    private PromotionPlanTableFormService promotionPlanTableFormService;

    @ApiOperation(value = "生成数据")
    @GetMapping("createDataSummary")
    public Result<?> createDataSummary(@ApiParam(name = "date", value = "时间") @RequestParam(value = "date",required = false) String date) {
        try {
            this.promotionPlanTableFormService.createDataSummary(date);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "查询下级数据")
    @GetMapping("findByPlatformLevelByDepartmentId")
    public Result<List<PromotionPlanTableFormVo>> findByPlatformLevelByDepartmentId(@ApiParam(name = "id", value = "id") @RequestParam(value = "id") String id) {
        try {
            List<PromotionPlanTableFormVo> vos = this.promotionPlanTableFormService.findByPlatformLevelByDepartmentId(id);
            return Result.ok(vos);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
