package com.biz.crm.tpm.business.promotion.plan.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 当月送货
 *
 * @author: yaoyongming
 * @date: 2022/11/2 13:52
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CurrentMonthDeliveryEntity", description = "当月送货实体类")
@Entity
@org.hibernate.annotations.Table(appliesTo = "tpm_current_month_delivery", comment = "当月送货实体类")
@TableName("tpm_current_month_delivery")
@Table(
        name = "tpm_current_month_delivery",
        indexes = {
                @Index(name = "uk_tpm_expenses_code_index", columnList = "expenses_code", unique = true),
                @Index(name = "tpm_current_month_delivery_index1", columnList = "promotion_plan_code"),
                @Index(name = "tpm_current_month_delivery_index2", columnList = "create_time,id"),
        })
public class CurrentMonthDeliveryEntity extends CurrentMonthEntity {

    /**
     * 预计销售额（元）
     */
    @ApiModelProperty("预计销售额（元）")
    @Column(name = "estimated_amount", columnDefinition = "decimal(20,6) COMMENT '预计销售额（元）'")
    private BigDecimal estimatedAmount;
    /**
     * 采购返点（元）
     */
    @ApiModelProperty("采购返点（元）")
    @Column(name = "purchase_rebate", columnDefinition = "decimal(20,6) COMMENT '采购返点（元）'")
    private BigDecimal purchaseRebate;
    /**
     * 物流费用（元）
     */
    @ApiModelProperty("物流费用（元）")
    @Column(name = "logistics", columnDefinition = "decimal(20,6) COMMENT '物流费用（元）'")
    private BigDecimal logistics;
}
