package com.biz.crm.tpm.business.promotion.plan.local.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import java.math.BigDecimal;

/**
 * 当月实体
 *
 * @author: yaoyongming
 * @date: 2022/11/2 16:27
 */
@Getter
@Setter
@ToString
@NoArgsConstructor
@MappedSuperclass
public class CurrentMonthEntity extends ExpensesEntity {

    /**
     * 税率
     */
    @ApiModelProperty("税率")
    @Column(name = "tax_rate", columnDefinition = "decimal(20,6) COMMENT '税率'")
    private BigDecimal taxRate;

    /**
     * 系数
     */
    @ApiModelProperty("系数")
    @Column(name = "ratio", columnDefinition = "decimal(20,6) COMMENT '系数'")
    private BigDecimal ratio;

    /**
     * 建议零售价（元）
     */
    @ApiModelProperty("建议零售价（元）")
    @Column(name = "suggested_retail_price", columnDefinition = "decimal(20,6) COMMENT '建议零售价（元）'")
    private BigDecimal suggestedRetailPrice;

    /**
     * 平台供货价（元）
     */
    @ApiModelProperty("平台供货价（元）")
    @Column(name = "platform_supply_price", columnDefinition = "decimal(20,6) COMMENT '平台供货价（元）'")
    private BigDecimal platformSupplyPrice;

    /**
     * 组合数量
     */
    @ApiModelProperty("组合数量")
    @Column(name = "combination_quantity", columnDefinition = "decimal(20,6) COMMENT '组合数量'")
    private BigDecimal combinationQuantity;

    /**
     * 预计销量（箱）
     */
    @ApiModelProperty("预计销量（箱）")
    @Column(name = "estimated_sales_box", columnDefinition = "decimal(20,6) COMMENT '预计销量（箱）'")
    private BigDecimal estimatedSalesBox;

    /**
     * 预计销量（吨）
     */
    @ApiModelProperty("预计销量（吨）")
    @Column(name = "estimated_sales_ton", columnDefinition = "decimal(20,6) COMMENT '预计销量（吨）'")
    private BigDecimal estimatedSalesTon;

    /**
     * 增值税（元）
     */
    @ApiModelProperty("增值税（元）")
    @Column(name = "vat", columnDefinition = "decimal(20,6) COMMENT '增值税（元）'")
    private BigDecimal vat;

    /**
     * 渠道推广费（元）
     */
    @ApiModelProperty("渠道推广费（元）")
    @Column(name = "channel_promotion_fee", columnDefinition = "decimal(20,6) COMMENT '渠道推广费（元）'")
    private BigDecimal channelPromotionFee;

    /**
     * 标准零售价
     */
    @ApiModelProperty("标准零售价")
    @Column(name = "standard_retail_price", length = 24, columnDefinition = "decimal(24,6) COMMENT '标准零售价'")
    private BigDecimal standardRetailPrice;

    /**
     * MDG客户编码
     */
    @ApiModelProperty("MDG客户编码")
    @Column(name = "erp_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT 'MDG客户编码'")
    private String erpCode;

    /**
     * 红线价
     */
    @ApiModelProperty("红线价")
    @Column(name = "red_line_price", columnDefinition = "DECIMAL(20,6) COMMENT '红线价'")
    private BigDecimal redLinePrice;

    /**
     * 成本价
     */
    @ApiModelProperty("成本价")
    @Column(name = "cost_price", columnDefinition = "DECIMAL(20,6) COMMENT '成本价'")
    private BigDecimal costPrice;

    /**
     * 折扣（元）
     */
    @ApiModelProperty("折扣（元）")
    @Column(name = "discount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '折扣（元）'")
    private BigDecimal discount;

    /**
     * 净收入（元）
     */
    @ApiModelProperty("净收入（元）")
    @Column(name = "net_income", columnDefinition = "DECIMAL(20,6) COMMENT '净收入（元）'")
    private BigDecimal netIncome;

    /**
     * 毛利（元）
     */
    @ApiModelProperty("毛利（元）")
    @Column(name = "gross_profit",nullable = true, columnDefinition = "decimal(20,4) COMMENT '毛利（元）'")
    private BigDecimal grossProfit;

    /**
     * 销管报销（元）
     */
    @ApiModelProperty("销管报销（元）")
    @Column(name = "sale_reimburse", columnDefinition = "DECIMAL(20,6) COMMENT '销管报销（元）'")
    private BigDecimal saleReimburse;

    /**
     * 行政+人力（元）
     */
    @ApiModelProperty("行政+人力（元）")
    @Column(name = "admin_human", columnDefinition = "DECIMAL(20,6) COMMENT '行政+人力（元）'")
    private BigDecimal adminHuman;

    /**
     * 其他收益（元）
     */
    @ApiModelProperty("其他收益（元）")
    @Column(name = "other_profit", columnDefinition = "DECIMAL(20,6) COMMENT '其他收益（元）'")
    private BigDecimal otherProfit;

    /**
     * 经营利润（元）
     */
    @ApiModelProperty("经营利润（元）")
    @Column(name = "operate_profit", columnDefinition = "DECIMAL(20,6) COMMENT '经营利润（元）'")
    private BigDecimal operateProfit;

    /**
     * 所得税（元）
     */
    @ApiModelProperty("所得税（元）")
    @Column(name = "income_tax", columnDefinition = "DECIMAL(20,6) COMMENT '所得税（元）'")
    private BigDecimal incomeTax;

    /**
     * 净利润（元）
     */
    @ApiModelProperty("净利润（元）")
    @Column(name = "net_profit", columnDefinition = "DECIMAL(20,6) COMMENT '净利润（元）'")
    private BigDecimal netProfit;

    /**
     * 净利率
     */
    @ApiModelProperty("净利率")
    @Column(name = "net_profit_rate", columnDefinition = "DECIMAL(20,6) COMMENT '净利率'")
    private BigDecimal netProfitRate;
}
