package com.biz.crm.tpm.business.promotion.plan.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 当月销售
 *
 * @author: yaoyongming
 * @date: 2022/11/2 13:51
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CurrentMonthSaleEntity", description = "当月销售实体类")
@Entity
@org.hibernate.annotations.Table(appliesTo = "tpm_current_month_sale", comment = "当月销售实体类")
@TableName("tpm_current_month_sale")
@Table(
        name = "tpm_current_month_sale",
        indexes = {
                @Index(name = "uk_tpm_expenses_code_index", columnList = "expenses_code", unique = true),
                @Index(name = "tpm_current_month_sale_index1", columnList = "promotion_plan_code"),
                @Index(name = "tpm_current_month_sale_index2", columnList = "create_time,id"),
        })
public class CurrentMonthSaleEntity extends CurrentMonthEntity {

    /**
     * 促销类型编码
     */
    @ApiModelProperty("促销类型编码")
    @Column(name = "promotion_type_code", length = 32, columnDefinition = "VARCHAR(64) COMMENT '促销类型编码'")
    private String promotionTypeCode;

    /**
     * 活动底价（元）
     */
    @ApiModelProperty("活动底价（元）")
    @Column(name = "activity_base_price", columnDefinition = "decimal(20,6) COMMENT '活动底价（元）'")
    private BigDecimal activityBasePrice;

    /**
     * 预计折前销售额（元）
     */
    @ApiModelProperty("预计折前销售额（元）")
    @Column(name = "estimated_amount_before", columnDefinition = "decimal(20,6) COMMENT '预计折前销售额（元）'")
    private BigDecimal estimatedAmountBefore;

    /**
     * 预计折后销售额（元）
     */
    @ApiModelProperty("预计折后销售额（元）")
    @Column(name = "estimated_amount_after", columnDefinition = "decimal(20,6) COMMENT '预计折后销售额（元）'")
    private BigDecimal estimatedAmountAfter;

    /**
     * 产品促销（元）
     */
    @ApiModelProperty("产品促销（元）")
    @Column(name = "product_promotion", columnDefinition = "decimal(20,6) COMMENT '产品促销（元）'")
    private BigDecimal productPromotion;

    /**
     * 大日期处理（元）
     */
    @ApiModelProperty("大日期处理（元）")
    @Column(name = "large_date_process", columnDefinition = "decimal(20,6) COMMENT '大日期处理（元）'")
    private BigDecimal largeDateProcess;

    /**
     * 新客专享（元）
     */
    @ApiModelProperty("新客专享（元）")
    @Column(name = "new_customer", columnDefinition = "decimal(20,6) COMMENT '新客专享（元）'")
    private BigDecimal newCustomer;

    /**
     * 老客留存（元）
     */
    @ApiModelProperty("老客留存（元）")
    @Column(name = "old_customer", columnDefinition = "decimal(20,6) COMMENT '老客留存（元）'")
    private BigDecimal oldCustomer;

    /**
     * 达人佣金（抖音）（元）
     */
    @ApiModelProperty("达人佣金（抖音）（元）")
    @Column(name = "tiktok_master", columnDefinition = "decimal(20,6) COMMENT '达人佣金（抖音）（元）'")
    private BigDecimal tiktokMaster;

    /**
     * 平台毛保（元）
     */
    @ApiModelProperty("平台毛保（元）")
    @Column(name = "platform_gross_protection", columnDefinition = "decimal(20,6) COMMENT '平台毛保（元）'")
    private BigDecimal platformGrossProtection;

    /**
     * 平台服务费（元）
     */
    @ApiModelProperty("平台服务费（元）")
    @Column(name = "platform_service", columnDefinition = "decimal(20,6) COMMENT '平台服务费（元）'")
    private BigDecimal platformService;

    /**
     * 平台返点费用（元）
     */
    @ApiModelProperty("平台返点费用（元）")
    @Column(name = "platform_rebate", columnDefinition = "decimal(20,6) COMMENT '平台返点费用（元）'")
    private BigDecimal platformRebate;

    /**
     * 平台佣金扣点（元）
     */
    @ApiModelProperty("平台佣金扣点（元）")
    @Column(name = "platform_commission", columnDefinition = "decimal(20,6) COMMENT '平台佣金扣点（元）'")
    private BigDecimal platformCommission;

    /**
     * 销售返点（元）
     */
    @ApiModelProperty("销售返点（元）")
    @Column(name = "sale_commission", columnDefinition = "decimal(20,6) COMMENT '销售返点（元）'")
    private BigDecimal saleCommission;

    /**
     * 物流费用（元）
     */
    @ApiModelProperty("物流费用（元）")
    @Column(name = "logistics", columnDefinition = "decimal(20,6) COMMENT '物流费用（元）'")
    private BigDecimal logistics;

    /**
     * 定额费用合计
     */
    @ApiModelProperty("定额费用合计")
    @Column(name = "quota_total", columnDefinition = "decimal(20,6) COMMENT '定额费用合计'")
    private BigDecimal quotaTotal;

    /**
     * 仓间不均（元）
     */
    @ApiModelProperty("仓间不均（元）")
    @Column(name = "uneven", columnDefinition = "DECIMAL(20,6) COMMENT '仓间不均（元）'")
    private BigDecimal uneven;

    /**
     * 高周转（元）
     */
    @ApiModelProperty("高周转（元）")
    @Column(name = "high_turnover", columnDefinition = "DECIMAL(20,6) COMMENT '高周转（元）'")
    private BigDecimal highTurnover;

    /**
     * GMV（元）
     */
    @ApiModelProperty("GMV（元）")
    @Column(name = "gmv", columnDefinition = "DECIMAL(20,6) COMMENT 'GMV（元）'")
    private BigDecimal gmv;

    /**
     * 京东采购返（元）
     */
    @ApiModelProperty("京东采购返（元）")
    @Column(name = "jd", columnDefinition = "DECIMAL(20,6) COMMENT '京东采购返（元）'")
    private BigDecimal jd;

    /**
     * 分销基础返点（旬返）
     */
    @ApiModelProperty("分销基础返点（旬返）")
    @Column(name = "distribution_base_ten", columnDefinition = "DECIMAL(20,6) COMMENT '分销基础返点（旬返）'")
    private BigDecimal distributionBaseTen;

    /**
     * 分销基础返点（月返）
     */
    @ApiModelProperty("分销基础返点（月返）")
    @Column(name = "distribution_base_month", columnDefinition = "DECIMAL(20,6) COMMENT '分销基础返点（月返）'")
    private BigDecimal distributionBaseMonth;

    /**
     * 月度目标达成返点（分销）
     */
    @ApiModelProperty("月度目标达成返点（分销）")
    @Column(name = "month_goal_achievement", columnDefinition = "DECIMAL(20,6) COMMENT '月度目标达成返点（分销）'")
    private BigDecimal monthGoalAchievement;

    /**
     * 组合装（分销）
     */
    @ApiModelProperty("组合装（分销）")
    @Column(name = "pre_pack", columnDefinition = "DECIMAL(20,6) COMMENT '组合装（分销）'")
    private BigDecimal prePack;

    /**
     * 人员费用（分销）
     */
    @ApiModelProperty("人员费用（分销）")
    @Column(name = "staff_fee", columnDefinition = "DECIMAL(20,6) COMMENT '人员费用（分销）'")
    private BigDecimal staffFee;

    /**
     * 投放费用（分销）
     */
    @ApiModelProperty("投放费用（分销）")
    @Column(name = "put_fee", columnDefinition = "DECIMAL(20,6) COMMENT '投放费用（分销）'")
    private BigDecimal putFee;

    /**
     * 物流支持（分销）
     */
    @ApiModelProperty("物流支持（分销）")
    @Column(name = "logistics_support", columnDefinition = "DECIMAL(20,6) COMMENT '物流支持（分销）'")
    private BigDecimal logisticsSupport;

    /**
     * 年度目标达成返点（分销）
     */
    @ApiModelProperty("年度目标达成返点（分销）")
    @Column(name = "year_goal_achievement", columnDefinition = "DECIMAL(20,6) COMMENT '年度目标达成返点（分销）'")
    private BigDecimal yearGoalAchievement;

    /**
     * 分销基础返点（旬返）-点数
     */
    @ApiModelProperty("分销基础返点（旬返）-点数")
    @Column(name = "distribution_base_ten_point", columnDefinition = "DECIMAL(20,6) COMMENT '分销基础返点（旬返）-点数'")
    private BigDecimal distributionBaseTenPoint;

    /**
     * 分销基础返点（月返）-点数
     */
    @ApiModelProperty("分销基础返点（月返）-点数")
    @Column(name = "distribution_base_month_point", columnDefinition = "DECIMAL(20,6) COMMENT '分销基础返点（月返）-点数'")
    private BigDecimal distributionBaseMonthPoint;

    /**
     * 目标达成返点数
     */
    @ApiModelProperty("目标达成返点数")
    @Column(name = "month_goal_achievement_point", columnDefinition = "DECIMAL(20,6) COMMENT '目标达成返点数'")
    private BigDecimal monthGoalAchievementPoint;

    /**
     * 组合装-点数
     */
    @ApiModelProperty("组合装-点数")
    @Column(name = "pre_pack_point", columnDefinition = "DECIMAL(20,6) COMMENT '组合装-点数'")
    private BigDecimal prePackPoint;

    /**
     * 人员点数
     */
    @ApiModelProperty("人员点数")
    @Column(name = "staff_fee_point", columnDefinition = "DECIMAL(20,6) COMMENT '人员点数'")
    private BigDecimal staffFeePoint;

    /**
     * 投放点数
     */
    @ApiModelProperty("投放点数")
    @Column(name = "put_fee_point", columnDefinition = "DECIMAL(20,6) COMMENT '投放点数'")
    private BigDecimal putFeePoint;

    /**
     * 物流点数
     */
    @ApiModelProperty("物流点数")
    @Column(name = "logistics_support_point", columnDefinition = "DECIMAL(20,6) COMMENT '物流点数'")
    private BigDecimal logisticsSupportPoint;

    /**
     * 年返点数
     */
    @ApiModelProperty("年返点数")
    @Column(name = "year_goal_achievement_point", columnDefinition = "DECIMAL(20,6) COMMENT '年返点数'")
    private BigDecimal yearGoalAchievementPoint;

    /**
     * 到手价政策价
     */
    @ApiModelProperty("到手价政策价")
    @Column(name = "take_home_price_policy", columnDefinition = "DECIMAL(20,6) COMMENT '到手价政策价'")
    private BigDecimal takeHomePricePolicy;

    /**
     * 到手价政策费用
     */
    @ApiModelProperty("到手价政策费用")
    @Column(name = "take_home_price_policy_fee", columnDefinition = "DECIMAL(20,6) COMMENT '到手价政策费用'")
    private BigDecimal takeHomePricePolicyFee;

}
