package com.biz.crm.tpm.business.promotion.plan.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 费用申请
 *
 * @author: yaoyongming
 * @date: 2022/11/2 13:49
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "GeneralExpensesEntity", description = "费用申请实体类")
@Entity
@org.hibernate.annotations.Table(appliesTo = "tpm_general_expenses", comment = "费用申请实体类")
@TableName("tpm_general_expenses")
@Table(
        name = "tpm_general_expenses",
        indexes = {
                @Index(name = "uk_tpm_expenses_code_index", columnList = "expenses_code", unique = true),
                @Index(name = "tpm_general_expenses_index1", columnList = "promotion_plan_code"),
                @Index(name = "tpm_general_expenses_index2", columnList = "create_time,id"),
        }
)
public class GeneralExpensesEntity extends ExpensesEntity {

    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型编码")
    @Column(name = "activity_type_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动类型编码'")
    private String activityTypeCode;

    /**
     * 活动类型名称
     */
    @ApiModelProperty("活动类型名称")
    @Column(name = "activity_type_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '活动类型名称'")
    private String activityTypeName;

    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    @Column(name = "activity_form_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动形式编码'")
    private String activityFormCode;

    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    @Column(name = "activity_form_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '活动形式名称'")
    private String activityFormName;

    /**
     * 商务政策编码
     */
    @ApiModelProperty("商务政策编码")
    @Column(name = "commerce_policy_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '商务政策编码'")
    private String commercePolicyCode;

    /**
     * 商务政策名称
     */
    @ApiModelProperty(name = "商务政策名称", notes = "商务政策名称")
    @Column(name = "business_policy_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '商务政策名称'")
    private String businessPolicyName;

    /**
     * 月度预算编码
     */
    @ApiModelProperty("月度预算编码")
    @Column(name = "month_budget_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '月度预算编码'")
    private String monthBudgetCode;

    /**
     * 三级预算项目
     */
    @ApiModelProperty("三级预算项目")
    @Column(name = "budget_item_code3", length = 32, columnDefinition = "VARCHAR(32) COMMENT '三级预算项目'")
    private String budgetItemCode3;

    /**
     * 二级预算项目
     */
    @ApiModelProperty("二级预算项目")
    @Column(name = "budget_item_code2", length = 32, columnDefinition = "VARCHAR(32) COMMENT '二级预算项目'")
    private String budgetItemCode2;

    /**
     * 一级预算项目
     */
    @ApiModelProperty("一级预算项目")
    @Column(name = "budget_item_code1", length = 32, columnDefinition = "VARCHAR(32) COMMENT '一级预算项目'")
    private String budgetItemCode1;

    /**
     * 三级预算项目名称
     */
    @ApiModelProperty("三级预算项目名称")
    @Column(name = "budget_item_name3", length = 256, columnDefinition = "VARCHAR(256) COMMENT '三级预算项目名称'")
    private String budgetItemName3;

    /**
     * 二级预算项目名称
     */
    @ApiModelProperty("二级预算项目名称")
    @Column(name = "budget_item_name2", length = 256, columnDefinition = "VARCHAR(256) COMMENT '二级预算项目名称'")
    private String budgetItemName2;

    /**
     * 一级预算项目名称
     */
    @ApiModelProperty("一级预算项目名称")
    @Column(name = "budget_item_name1", length = 256, columnDefinition = "VARCHAR(256) COMMENT '一级预算项目名称'")
    private String budgetItemName1;

    /**
     * 申请金额
     */
    @ApiModelProperty("申请金额")
    @Column(name = "apply_amount", columnDefinition = "decimal(20,6) COMMENT '申请金额'")
    private BigDecimal applyAmount;

    /**
     * 可用余额
     */
    @ApiModelProperty("可用余额")
    @Column(name = "balance", columnDefinition = "decimal(20,6) COMMENT '可用余额'")
    private BigDecimal balance;

    /**
     * 支付方式
     */
    @ApiModelProperty("支付方式")
    @Column(name = "pay_type", columnDefinition = "varchar(64) COMMENT '支付方式'")
    private String payType;

    /**
     * 入账方式
     */
    @ApiModelProperty("入账方式")
    @Column(name = "account_type", columnDefinition = "varchar(32) COMMENT '入账方式'")
    private String accountType;

    /**
     * 核销条件类型
     */
    @ApiModelProperty("核销条件类型")
    @Column(name = "audit_condition_type", length = 32, columnDefinition = "varchar(32) COMMENT '核销条件类型'")
    private String auditConditionType;

    /**
     * 核销条件编码
     */
    @ApiModelProperty("核销条件编码")
    @Column(name = "audit_condition_code", length = 32, columnDefinition = "varchar(32) COMMENT '核销条件编码'")
    private String auditConditionCode;

    /**
     * 核销条件名称
     */
    @ApiModelProperty("核销条件名称")
    @Column(name = "audit_condition_name", columnDefinition = "varchar(255) COMMENT '核销条件名称'")
    private String auditConditionName;

    /**
     * 合同编码
     */
    @ApiModelProperty("合同编码")
    @Column(name = "contract_code", columnDefinition = "varchar(32) COMMENT '合同编码'")
    private String contractCode;

    /**
     * 合同名称
     */
    @ApiModelProperty(name = "合同名称")
    @Column(name = "contract_name", columnDefinition = "VARCHAR(255) COMMENT '合同名称'")
    private String contractName;

    /**
     * 活动底价（元）
     */
    @ApiModelProperty("活动底价（元）")
    @Column(name = "activity_base_price", columnDefinition = "decimal(20,6) COMMENT '活动底价（元）'")
    private BigDecimal activityBasePrice;

    /**
     * 促销类型编码
     */
    @ApiModelProperty("促销类型编码")
    @Column(name = "promotion_type_code", length = 32, columnDefinition = "VARCHAR(64) COMMENT '促销类型编码'")
    private String promotionTypeCode;

    /**
     * 是否自动生成
     */
    @ApiModelProperty("是否自动生成")
    @Column(name = "be_generate", length = 1, columnDefinition = "char(1) COMMENT '是否自动生成：1是，0否'")
    private Boolean beGenerate = false;

    /**
     * 是否完全结案
     */
    @ApiModelProperty("是否完全结案")
    @Column(name = "whole_audit", length = 10, columnDefinition = "VARCHAR(10) COMMENT '是否完全结案'")
    private String wholeAudit;

    @ApiModelProperty("是否自动结案")
    @Column(name = "auto_audit", length = 10, columnDefinition = "VARCHAR(10) COMMENT '是否自动结案'")
    private String autoAudit;

    @ApiModelProperty("完全结案日期")
    @Column(name = "whole_audit_date", length = 20, columnDefinition = "varchar(20) COMMENT '完全结案日期'")
    private String wholeAuditDate;

    /**
     * 已结案金额
     */
    @ApiModelProperty("已结案金额")
    @Column(name = "already_audit_amount", columnDefinition = "DECIMAL(24,6) COMMENT '已结案金额'")
    private BigDecimal alreadyAuditAmount;

    /**
     * 本次结案金额
     */
    @ApiModelProperty("本次结案金额")
    @Column(name = "last_audit_amount", columnDefinition = "DECIMAL(24,6) COMMENT '本次结案金额'")
    private BigDecimal lastAuditAmount;

    /**
     * 结案方式
     */
    @ApiModelProperty(name = "结案方式", notes = "结案方式")
    @Column(name = "audit_way_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '结案方式'")
    private String auditWayCode;

    /**
     * 结案方式名称
     */
    @ApiModelProperty(name = "结案方式名称", notes = "结案方式名称")
    @Column(name = "audit_way_name",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '结案方式名称'")
    private String auditWayName;

    /**
     * 费用归属年月
     */
    @ApiModelProperty(name = "费用归属年月", notes = "费用归属年月")
    @Column(name = "year_month_ly", length = 32, columnDefinition = "VARCHAR(32) COMMENT '费用归属年月'")
    private String yearMonthLy;

    /**
     * 是否完全上账
     */
    @ApiModelProperty("是否完全上账")
    @Column(name = "whole_up_account", length = 1, columnDefinition = "VARCHAR(1) COMMENT '是否完全上账'")
    private String wholeUpAccount;

    /**
     * 已上账金额
     */
    @ApiModelProperty("已上账金额")
    @Column(name = "already_up_account_amount", precision = 20, scale = 6, columnDefinition = "DECIMAL(20,6) COMMENT '已上账金额'")
    private BigDecimal alreadyUpAccountAmount;

    /**
     * MDG客户编码
     */
    @ApiModelProperty("MDG客户编码")
    @Column(name = "erp_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT 'MDG客户编码'")
    private String erpCode;
}
