package com.biz.crm.tpm.business.promotion.plan.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 其他费用
 *
 * @author: yaoyongming
 * @date: 2022/11/2 13:54
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "OtherExpensesEntity", description = "其他费用实体类")
@Entity
@org.hibernate.annotations.Table(appliesTo = "tpm_other_expenses", comment = "其他费用实体类")
@TableName("tpm_other_expenses")
@Table(
        name = "tpm_other_expenses",
        indexes ={
        @Index(name = "uk_tpm_expenses_code_index", columnList = "expenses_code", unique = true),
        @Index(name = "tpm_other_expenses_index1", columnList = "promotion_plan_code")}
)

public class OtherExpensesEntity extends TenantFlagOpEntity {

    /**
     * 促销规划编码
     */
    @ApiModelProperty("促销规划编码")
    @Column(name = "promotion_plan_code", length = 32, columnDefinition = "VARCHAR(64) COMMENT '促销规划编码'")
    private String promotionPlanCode;

    /**
     * 促销规划明细编码
     */
    @ApiModelProperty("促销规划明细编码")
    @Column(name = "expenses_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '促销规划明细编码'")
    private String expensesCode;

    /**
     * 市场费用-预算（千元）
     */
    @ApiModelProperty("市场费用-预算（千元）")
    @Column(name = "market_amount_budget", columnDefinition = "decimal(20,6) COMMENT '市场费用-预算（千元）'")
    private BigDecimal marketAmountBudget;

    /**
     * 市场费用-规划（千元）
     */
    @ApiModelProperty("市场费用-规划（千元）")
    @Column(name = "market_amount_plan", columnDefinition = "decimal(20,6) COMMENT '市场费用-规划（千元）'")
    private BigDecimal marketAmountPlan;

    /**
     * 物流费用-预算（千元）
     */
    @ApiModelProperty("物流费用-预算（千元）")
    @Column(name = "logistics_amount_budget", columnDefinition = "decimal(20,6) COMMENT '物流费用-预算（千元）'")
    private BigDecimal logisticsAmountBudget;

    /**
     * 物流费用-规划（千元）
     */
    @ApiModelProperty("物流费用-规划（千元）")
    @Column(name = "logistics_amount_plan", columnDefinition = "decimal(20,6) COMMENT '物流费用-规划（千元）'")
    private BigDecimal logisticsAmountPlan;

    /**
     * 行政管理费用-预算（千元）
     */
    @ApiModelProperty("行政管理费用-预算（千元）")
    @Column(name = "admin_amount_budget", columnDefinition = "decimal(20,6) COMMENT '行政管理费用-预算（千元）'")
    private BigDecimal adminAmountBudget;

    /**
     * 行政管理费用-规划（千元）
     */
    @ApiModelProperty("行政管理费用-规划（千元）")
    @Column(name = "admin_amount_plan", columnDefinition = "decimal(20,6) COMMENT '行政管理费用-规划（千元）'")
    private BigDecimal adminAmountPlan;

    /**
     * 人力成本-预算（千元）
     */
    @ApiModelProperty("人力成本-预算（千元）")
    @Column(name = "human_amount_budget", columnDefinition = "decimal(20,6) COMMENT '人力成本-预算（千元）'")
    private BigDecimal humanAmountBudget;

    /**
     * 人力成本-规划（千元）
     */
    @ApiModelProperty("人力成本-规划（千元）")
    @Column(name = "human_amount_plan", columnDefinition = "decimal(20,6) COMMENT '人力成本-规划（千元）'")
    private BigDecimal humanAmountPlan;
}
