package com.biz.crm.tpm.business.promotion.plan.local.entity;

import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import java.math.BigDecimal;

/**
 * @author: yaoyongming
 * @date: 2023/2/11 15:34
 */
@Getter
@Setter
@ToString
@NoArgsConstructor
@MappedSuperclass
public class ProfitLoss extends TenantFlagOpEntity {

    /**
     * 数据字典:mdm_business_format
     */
    @ApiModelProperty("业态编码")
    @Column(name = "business_format_code", length = 32, columnDefinition = "varchar(32) COMMENT '业态编码'")
    private String businessFormatCode;

    @ApiModelProperty("业态名称")
    @Column(name = "business_format_name", columnDefinition = "varchar(255) COMMENT '业态名称'")
    private String businessFormatName;

    /**
     * 数据字典:mdm_business_unit
     */
    @ApiModelProperty("业务单元")
    @Column(name = "business_unit_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty("业务单元名称")
    @Column(name = "business_unit_name", columnDefinition = "VARCHAR(255) COMMENT '业务单元名称'")
    private String businessUnitName;

    @ApiModelProperty("年月")
    @Column(name = "year_monthly", length = 32, columnDefinition = "VARCHAR(32) COMMENT '年月'")
    private String yearMonthly;

    @ApiModelProperty("部门编码")
    @Column(name = "department_code", length = 32, columnDefinition = "varchar(32) COMMENT '部门编码'")
    private String departmentCode;

    @ApiModelProperty("部门名称")
    @Column(name = "department_name", columnDefinition = "varchar(255) COMMENT '部门名称'")
    private String departmentName;

    @ApiModelProperty("销售机构编码")
    @Column(name = "sales_institution_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构编码'")
    private String salesInstitutionCode;

    @ApiModelProperty("销售机构")
    @Column(name = "sales_institution_name", columnDefinition = "VARCHAR(255) COMMENT '销售机构名称'")
    private String salesInstitutionName;

    @ApiModelProperty("销售部门编码")
    @Column(name = "sales_org_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '销售部门编码'")
    private String salesOrgCode;

    @ApiModelProperty("销售部门")
    @Column(name = "sales_org_name", columnDefinition = "VARCHAR(255) COMMENT '销售部门名称'")
    private String salesOrgName;

    @ApiModelProperty("销售组编码")
    @Column(name = "sales_group_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '销售组编码'")
    private String salesGroupCode;

    @ApiModelProperty("销售组名称")
    @Column(name = "sales_group_name", columnDefinition = "VARCHAR(255) COMMENT '销售组名称'")
    private String salesGroupName;

    @ApiModelProperty("客户编码")
    @Column(name = "customer_code", length = 32, columnDefinition = "varchar(32) COMMENT '客户编码'")
    private String customerCode;

    @ApiModelProperty("客户名称")
    @Column(name = "customer_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户名称'")
    private String customerName;

    @ApiModelProperty("前台/账面")
    @Column(name = "type", length = 32, columnDefinition = "varchar(32) COMMENT '前台/账面'")
    private String type;

    @ApiModelProperty("销量（吨）")
    @Column(name = "sales_ton", columnDefinition = "DECIMAL(24,6) COMMENT '销量（吨）'")
    private BigDecimal salesTon;

    @ApiModelProperty("销售额")
    @Column(name = "sale_amount", columnDefinition = "decimal(20,6) COMMENT '销售额'")
    private BigDecimal saleAmount;

    @ApiModelProperty("减：增值税")
    @Column(name = "vat_sub", columnDefinition = "decimal(20,6) COMMENT '减：增值税'")
    private BigDecimal vatSub;

    @ApiModelProperty("加：增值税-折扣税金")
    @Column(name = "vat_add", columnDefinition = "decimal(20,6) COMMENT '加：增值税-折扣税金'")
    private BigDecimal vatAdd;

    @ApiModelProperty("销售收入")
    @Column(name = "sale_income", columnDefinition = "decimal(20,6) COMMENT '销售收入'")
    private BigDecimal saleIncome;

    @ApiModelProperty("减：折扣")
    @Column(name = "discount_sub", columnDefinition = "decimal(20,6) COMMENT '减：折扣'")
    private BigDecimal discountSub;

    @ApiModelProperty("净收入")
    @Column(name = "net_income", columnDefinition = "DECIMAL(20,6) COMMENT '净收入'")
    private BigDecimal netIncome;

    @ApiModelProperty("减：主营税金及附加")
    @Column(name = "main_tax_sub", columnDefinition = "DECIMAL(20,6) COMMENT '减：主营税金及附加'")
    private BigDecimal mainTaxSub;

    @ApiModelProperty("直接材料")
    @Column(name = "direct_material", columnDefinition = "decimal(20,6) COMMENT '直接材料'")
    private BigDecimal directMaterial;

    @ApiModelProperty("包材折扣")
    @Column(name = "package_discount", columnDefinition = "decimal(20,6) COMMENT '包材折扣'")
    private BigDecimal packageDiscount;

    @ApiModelProperty("变动制造费用")
    @Column(name = "variable_manufacturing", columnDefinition = "decimal(20,6) COMMENT '变动制造费用'")
    private BigDecimal variableManufacturing;

    @ApiModelProperty("运输装卸费用")
    @Column(name = "transport_handling", columnDefinition = "decimal(20,6) COMMENT '运输装卸费用'")
    private BigDecimal transportHandling;

    @ApiModelProperty("销售费用-销管报销(含税)")
    @Column(name = "sale_fee_reimburse", columnDefinition = "decimal(20,6) COMMENT '销售费用-销管报销(含税)'")
    private BigDecimal saleFeeReimburse;

    @ApiModelProperty("销售费用-销管折扣(含税)")
    @Column(name = "sale_fee_sale_discount", columnDefinition = "decimal(20,6) COMMENT '销售费用-销管折扣(含税)'")
    private BigDecimal saleFeeSaleDiscount;

    @ApiModelProperty("销管结案批复差异")
    @Column(name = "reimburse_diff", columnDefinition = "decimal(20,6) COMMENT '销管结案批复差异'")
    private BigDecimal reimburseDiff;

    @ApiModelProperty("销售费用-市场折扣")
    @Column(name = "sale_fee_market_discount", columnDefinition = "decimal(20,6) COMMENT '销售费用-市场折扣'")
    private BigDecimal saleFeeMarketDiscount;

    @ApiModelProperty("销售费用-行销折扣（含税）")
    @Column(name = "sale_fee_operate_discount", columnDefinition = "decimal(20,6) COMMENT '销售费用-行销折扣（含税）'")
    private BigDecimal saleFeeOperateDiscount;

    @ApiModelProperty("边际贡献")
    @Column(name = "marginal_contribution", columnDefinition = "decimal(20,6) COMMENT '边际贡献'")
    private BigDecimal marginalContribution;

    @ApiModelProperty("减：销售费用-市场报销（含税）")
    @Column(name = "sale_fee_market_reimburse_sub", columnDefinition = "decimal(20,6) COMMENT '减：销售费用-市场报销（含税）'")
    private BigDecimal saleFeeMarketReimburseSub;

    @ApiModelProperty("市场结案批复差异")
    @Column(name = "market_diff", columnDefinition = "decimal(20,6) COMMENT '市场结案批复差异'")
    private BigDecimal marketDiff;

    @ApiModelProperty("销售费用-行销报销（含税)")
    @Column(name = "sale_fee_operate_reimburse", columnDefinition = "decimal(20,6) COMMENT '销售费用-行销报销（含税)'")
    private BigDecimal saleFeeOperateReimburse;

    @ApiModelProperty("行销批复与结案差")
    @Column(name = "operate_diff", columnDefinition = "decimal(20,6) COMMENT '行销批复与结案差'")
    private BigDecimal operateDiff;

    @ApiModelProperty("固定制造费用")
    @Column(name = "fixed_manufacture", columnDefinition = "decimal(20,6) COMMENT '固定制造费用'")
    private BigDecimal fixedManufacture;

    @ApiModelProperty("销售费用--仓储费用")
    @Column(name = "sale_fee_inventory", columnDefinition = "decimal(20,6) COMMENT '销售费用--仓储费用'")
    private BigDecimal saleFeeInventory;

    @ApiModelProperty("销售费用--行政性费用")
    @Column(name = "sale_fee_admin", columnDefinition = "decimal(20,6) COMMENT '销售费用--行政性费用'")
    private BigDecimal saleFeeAdmin;

    @ApiModelProperty("销售费用--行政性费用（人力成本）")
    @Column(name = "sale_fee_admin_human", columnDefinition = "decimal(20,6) COMMENT '销售费用--行政性费用（人力成本）'")
    private BigDecimal saleFeeAdminHuman;

    @ApiModelProperty("公共事务专项费用")
    @Column(name = "affair", columnDefinition = "decimal(20,6) COMMENT '公共事务专项费用'")
    private BigDecimal affair;

    @ApiModelProperty("营改增税金")
    @Column(name = "business_tax_replaced_vat", columnDefinition = "decimal(20,6) COMMENT '营改增税金'")
    private BigDecimal businessTaxReplacedVat;

    @ApiModelProperty("管理费用")
    @Column(name = "manage", columnDefinition = "decimal(20,6) COMMENT '管理费用'")
    private BigDecimal manage;

    @ApiModelProperty("管理费用（人力成本）")
    @Column(name = "manage_human", columnDefinition = "decimal(20,6) COMMENT '管理费用（人力成本）'")
    private BigDecimal manageHuman;

    @ApiModelProperty("研发费用")
    @Column(name = "development", columnDefinition = "decimal(20,6) COMMENT '研发费用'")
    private BigDecimal development;

    @ApiModelProperty("研发费用（人力成本）")
    @Column(name = "development_human", columnDefinition = "decimal(20,6) COMMENT '研发费用（人力成本）'")
    private BigDecimal developmentHuman;

    @ApiModelProperty("其他")
    @Column(name = "others", columnDefinition = "decimal(20,6) COMMENT '其他'")
    private BigDecimal others;

    @ApiModelProperty("加：其他业务收入")
    @Column(name = "others_add", columnDefinition = "decimal(20,6) COMMENT '加：其他业务收入'")
    private BigDecimal othersAdd;

    @ApiModelProperty("减：其他业务支出")
    @Column(name = "others_sub", columnDefinition = "decimal(20,6) COMMENT '减：其他业务支出'")
    private BigDecimal othersSub;

    @ApiModelProperty("经营利润")
    @Column(name = "operate_profit", columnDefinition = "DECIMAL(20,6) COMMENT '经营利润（元）'")
    private BigDecimal operateProfit;

    @ApiModelProperty("加：其他收益")
    @Column(name = "others_profit_add", columnDefinition = "decimal(20,6) COMMENT '加：其他收益'")
    private BigDecimal othersProfitAdd;

    @ApiModelProperty("加：投资收益")
    @Column(name = "income_from_investment_add", columnDefinition = "decimal(20,6) COMMENT '加：投资收益'")
    private BigDecimal incomeFromInvestmentAdd;

    @ApiModelProperty("加：净敞口套期收益")
    @Column(name = "net_exposure_add", columnDefinition = "decimal(20,6) COMMENT '加：净敞口套期收益'")
    private BigDecimal netExposureAdd;

    @ApiModelProperty("加：公允价值变动收益")
    @Column(name = "fair_change_add", columnDefinition = "decimal(20,6) COMMENT '加：公允价值变动收益'")
    private BigDecimal fairChangeAdd;

    @ApiModelProperty("加：信用减值损失（反号）")
    @Column(name = "credit_loss_add", columnDefinition = "decimal(20,6) COMMENT '加：信用减值损失（反号）'")
    private BigDecimal creditLossAdd;

    @ApiModelProperty("加：资产减值损失（反号）")
    @Column(name = "asset_loss_add", columnDefinition = "decimal(20,6) COMMENT '加：资产减值损失（反号）'")
    private BigDecimal assetLossAdd;

    @ApiModelProperty("加：资产处置收益")
    @Column(name = "asset_dispose_add", columnDefinition = "decimal(20,6) COMMENT '加：资产处置收益'")
    private BigDecimal assetDisposeAdd;

    @ApiModelProperty("加：营业外收入")
    @Column(name = "nonbusiness_income_add", columnDefinition = "decimal(20,6) COMMENT '加：营业外收入'")
    private BigDecimal nonbusinessIncomeAdd;

    @ApiModelProperty("减：营业外支出")
    @Column(name = "nonbusiness_cost_sub", columnDefinition = "decimal(20,6) COMMENT '减：营业外支出'")
    private BigDecimal nonbusinessCostSub;

    @ApiModelProperty("息前税前利润")
    @Column(name = "ebit", columnDefinition = "decimal(20,6) COMMENT '息前税前利润'")
    private BigDecimal ebit;

    @ApiModelProperty("减：财务费用")
    @Column(name = "financial_expenses_sub", columnDefinition = "decimal(20,6) COMMENT '减：财务费用'")
    private BigDecimal financialExpensesSub;

    @ApiModelProperty("所得税")
    @Column(name = "income_tax", columnDefinition = "DECIMAL(20,6) COMMENT '所得税'")
    private BigDecimal incomeTax;

    @ApiModelProperty("净利润")
    @Column(name = "net_profit", columnDefinition = "DECIMAL(20,6) COMMENT '净利润'")
    private BigDecimal netProfit;

    @ApiModelProperty("GMV")
    @Column(name = "gmv", columnDefinition = "DECIMAL(20,6) COMMENT 'GMV'")
    private BigDecimal gmv;

    @ApiModelProperty("价格力度")
    @Column(name = "intensity", columnDefinition = "DECIMAL(20,6) COMMENT '价格力度'")
    private BigDecimal intensity;

    @ApiModelProperty("消费者费用（千元）")
    @Column(name = "consumer", columnDefinition = "DECIMAL(20,6) COMMENT '消费者费用（千元）'")
    private BigDecimal consumer;

    @ApiModelProperty("渠道费用（千元）")
    @Column(name = "channel", columnDefinition = "DECIMAL(20,6) COMMENT '渠道费用（千元）'")
    private BigDecimal channel;

    @ApiModelProperty("投放费用（千元）")
    @Column(name = "put", columnDefinition = "DECIMAL(20,6) COMMENT '投放费用（千元）'")
    private BigDecimal put;

    @ApiModelProperty("平台运营费用（千元）")
    @Column(name = "platform_operate", columnDefinition = "DECIMAL(20,6) COMMENT '平台运营费用（千元）'")
    private BigDecimal platformOperate;

    @ApiModelProperty("费用池（千元）")
    @Column(name = "fee_pool", columnDefinition = "DECIMAL(20,6) COMMENT '费用池（千元）'")
    private BigDecimal feePool;
}
