package com.biz.crm.tpm.business.promotion.plan.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;


/**
 * 促销规划整体一览表
 *
 * @author: cyj
 * @date: 2023/1/14 16:14
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "PromotionAllResult", description = "促销规划整体一览表")
@Entity
@org.hibernate.annotations.Table(appliesTo = "tpm_promotion_all_result", comment = "促销规划整体一览表")
@TableName("tpm_promotion_all_result")
@Table(
        name = "tpm_promotion_all_result",
        indexes = {
                @Index(name = "tpm_promotion_plan_result1", columnList = "year_and_month"),
        })
public class PromotionAllResult extends TenantFlagOpEntity {

    @ApiModelProperty(name = "年月", notes = "年月")
    @Column(name = "year_and_month",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '年月'")
    private String yearAndMonth;

    /**
     * 项目编码
     */
    @ApiModelProperty("项目编码")
    @Column(name = "project_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '项目编码'")
    private String projectCode;

    /**
     * 项目名称
     */
    @ApiModelProperty("项目名称")
    @Column(name = "project_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '项目名称'")
    private String projectName;

    /**
     * 同期
     */
    @ApiModelProperty("同期")
    @Column(name = "contemporaneous", columnDefinition = "decimal(20,6) COMMENT '同期'")
    private BigDecimal contemporaneous;

    /**
     * 预算
     */
    @ApiModelProperty("预算")
    @Column(name = "budget", columnDefinition = "decimal(20,6) COMMENT '预算'")
    private BigDecimal budget;

    /**
     * 规划
     */
    @ApiModelProperty("规划")
    @Column(name = "plan", columnDefinition = "decimal(20,6) COMMENT '规划'")
    private BigDecimal plan;

    /**
     * 规划VS同期
     */
    @ApiModelProperty("规划VS同期")
    @Column(name = "plan_vs_contemporaneous", columnDefinition = "decimal(20,6) COMMENT '规划VS同期'")
    private BigDecimal planVsContemporaneous;

    /**
     * 规划VS预算
     */
    @ApiModelProperty("规划VS预算")
    @Column(name = "plan_vs_budget", columnDefinition = "decimal(20,6) COMMENT '规划VS预算'")
    private BigDecimal planVsBudget;

    /**
     * 累计同期
     */
    @ApiModelProperty("累计同期")
    @Column(name = "contemporaneous_total", columnDefinition = "decimal(20,6) COMMENT '累计同期'")
    private BigDecimal contemporaneousTotal;

    /**
     * 累计规划
     */
    @ApiModelProperty("累计规划")
    @Column(name = "plan_total", columnDefinition = "decimal(20,6) COMMENT '累计规划'")
    private BigDecimal planTotal;

    /**
     * 累计预算
     */
    @ApiModelProperty("累计预算")
    @Column(name = "budget_total", columnDefinition = "decimal(20,6) COMMENT '累计预算'")
    private BigDecimal budgetTotal;

    /**
     * 累计实际&规划(当月)
     */
    @ApiModelProperty("累计实际&规划(当月)")
    @Column(name = "actual_plan", columnDefinition = "decimal(20,6) COMMENT '累计实际&规划(当月)'")
    private BigDecimal actualPlan;

    /**
     * 累计实际&规划(当月+上月)
     */
    @ApiModelProperty("累计实际&规划(当月+上月)")
    @Column(name = "actual_plan_month", columnDefinition = "decimal(20,6) COMMENT '累计实际&规划(当月+上月)'")
    private BigDecimal actualPlanMonth;

    /**
     * 累计实际&规划VS预算
     */
    @ApiModelProperty("累计实际&规划VS预算")
    @Column(name = "actual_plan_vs_budget", columnDefinition = "decimal(20,6) COMMENT '累计实际&规划VS预算'")
    private BigDecimal actualPlanVsBudget;

    /**
     * 年预算累计
     */
    @ApiModelProperty("年预算累计")
    @Column(name = "year_budget_total", columnDefinition = "decimal(20,6) COMMENT '年预算累计'")
    private BigDecimal yearBudgetTotal;


    /**
     * 使用进度
     */
    @ApiModelProperty("使用进度")
    @Column(name = "use_progress", columnDefinition = "decimal(20,6) COMMENT '使用进度'")
    private BigDecimal useProgress;
}
