package com.biz.crm.tpm.business.promotion.plan.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @author: yaoyongming
 * @date: 2023/8/29 15:41
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "PromotionFeeApportion", description = "促销费用分摊实体类")
@Entity
@org.hibernate.annotations.Table(appliesTo = "tpm_promotion_fee_apportion", comment = "促销费用分摊实体类")
@TableName("tpm_promotion_fee_apportion")
@Table(
        name = "tpm_promotion_fee_apportion",
        indexes = {
                @Index(name = "promotion_fee_apportion_idx1", columnList = "unique_key"),
                @Index(name = "promotion_fee_apportion_idx2", columnList = "business_format_code"),
                @Index(name = "promotion_fee_apportion_idx3", columnList = "channel_code"),
                @Index(name = "promotion_fee_apportion_idx4", columnList = "sales_institution_code"),
                @Index(name = "promotion_fee_apportion_idx5", columnList = "platform_code"),
                @Index(name = "promotion_fee_apportion_idx6", columnList = "customer_code"),
                @Index(name = "promotion_fee_apportion_idx7", columnList = "activity_form_code"),
                @Index(name = "promotion_fee_apportion_idx8", columnList = "sales_institution_erp_code"),
                @Index(name = "promotion_fee_apportion_idx9", columnList = "customer_erp_code"),
                @Index(name = "promotion_fee_apportion_idx10", columnList = "year_month_ly")
        })
public class PromotionFeeApportion extends TenantFlagOpEntity {


    /**
     * 唯一标识
     */
    @ApiModelProperty("唯一标识")
    @Column(name = "unique_key", length = 128, columnDefinition = "varchar(128) COMMENT '唯一标识'")
    private String uniqueKey;

    /**
     * 业态编码
     */
    @ApiModelProperty("业态编码")
    @Column(name = "business_format_code", length = 32, columnDefinition = "varchar(32) COMMENT '业态编码'")
    private String businessFormatCode;

    /**
     * 渠道编码
     */
    @Column(name = "channel_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '渠道编码'")
    private String channelCode;

    /**
     * 渠道名称
     */
    @Column(name = "channel_name", columnDefinition = "VARCHAR(255) COMMENT '渠道名称'")
    private String channelName;

    /**
     * 销售机构编码
     */
    @ApiModelProperty("销售机构编码")
    @Column(name = "sales_institution_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构编码'")
    private String salesInstitutionCode;

    /**
     * 销售机构ERP编码
     */
    @ApiModelProperty("销售机构ERP编码")
    @Column(name = "sales_institution_erp_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构ERP编码'")
    private String salesInstitutionErpCode;

    /**
     * 销售机构名称
     */
    @ApiModelProperty("销售机构名称")
    @Column(name = "sales_institution_name", columnDefinition = "VARCHAR(255) COMMENT '销售机构名称'")
    private String salesInstitutionName;

    /**
     * 平台编码
     */
    @ApiModelProperty("平台编码")
    @Column(name = "platform_code", length = 32, columnDefinition = "VARCHAR(64) COMMENT '平台编码'")
    private String platformCode;

    /**
     * 客户
     */
    @ApiModelProperty("客户")
    @Column(name = "customer_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户'")
    private String customerCode;

    /**
     * 客户编码
     */
    @ApiModelProperty("客户ERP编码")
    @Column(name = "customer_erp_code", length = 32, columnDefinition = "varchar(32) COMMENT '客户ERP编码'")
    private String customerErpCode;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    @Column(name = "customer_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户名称'")
    private String customerName;

    /**
     * 年月
     */
    @ApiModelProperty("年月")
    @Column(name = "year_month_ly", length = 32, columnDefinition = "VARCHAR(32) COMMENT '年月'")
    private String yearMonthLy;

    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    @Column(name = "activity_form_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动形式编码'")
    private String activityFormCode;

    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    @Column(name = "activity_form_name", columnDefinition = "VARCHAR(255) COMMENT '活动形式名称'")
    private String activityFormName;

    /**
     * 分摊比例
     */
    @ApiModelProperty("分摊比例")
    @Column(name = "ratio", columnDefinition = "decimal(20,6) COMMENT '分摊比例'")
    private BigDecimal ratio;

    /**
     * 促销费用分摊总额(元)
     */
    @ApiModelProperty("促销费用分摊总额(元)")
    @Column(name = "fee_apportion_total", columnDefinition = "decimal(20,6) COMMENT '促销费用分摊总额(元)'")
    private BigDecimal feeApportionTotal;

    /**
     * 分摊销售额
     */
    @ApiModelProperty("分摊销售额")
    @Column(name = "fee_apportion", columnDefinition = "decimal(20,6) COMMENT '分摊销售额'")
    private BigDecimal feeApportion;
}
