package com.biz.crm.tpm.business.promotion.plan.local.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 促销规划
 *
 * @author: yaoyongming
 * @date: 2022/11/1 17:36
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "PromotionPlanEntity", description = "促销规划实体类")
@Entity
@org.hibernate.annotations.Table(appliesTo = "tpm_promotion_plan", comment = "促销规划实体类")
@TableName("tpm_promotion_plan")
@Table(
        name = "tpm_promotion_plan",
        indexes = @Index(name = "uk_tpm_promotion_plan", columnList = "promotion_plan_code", unique = true))
public class PromotionPlanEntity extends TenantFlagOpEntity {

    /**
     * 促销规划编码
     */
    @ApiModelProperty("促销规划编码")
    @Column(name = "promotion_plan_code", length = 32, columnDefinition = "VARCHAR(64) COMMENT '促销规划编码'")
    private String promotionPlanCode;

    /**
     * 促销规划名称
     */
    @ApiModelProperty("促销规划名称")
    @Column(name = "promotion_plan_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '促销规划名称'")
    private String promotionPlanName;

    /**
     * 促销规划时间开始
     */
    @ApiModelProperty("促销规划时间开始")
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "start_date" , length = 10, columnDefinition = "datetime COMMENT '促销规划时间开始'")
    private Date startDate;

    /**
     * 促销规划时间结束
     */
    @ApiModelProperty("促销规划时间结束")
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "end_date" , length = 10, columnDefinition = "datetime COMMENT '促销规划时间结束'")
    private Date endDate;

    /**
     * 业务模式
     */
    @ApiModelProperty("业务模式")
    @Column(name = "business_model_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '业务模式'")
    private String businessModelCode;

    /**
     * 销售机构编码
     */
    @ApiModelProperty("销售机构编码")
    @Column(name = "sales_org_code", length = 32, columnDefinition = "VARCHAR(64) COMMENT '销售机构编码'")
    private String salesOrgCode;

    /**
     * 销售机构名称
     */
    @ApiModelProperty("销售机构名称")
    @Column(name = "sales_org_name", length = 200, columnDefinition = " varchar(200) COMMENT '销售机构名称'")
    private String salesOrgName;

    /**
     * 平台编码
     */
    @ApiModelProperty("平台编码")
    @Column(name = "platform_code", length = 32, columnDefinition = "VARCHAR(64) COMMENT '平台编码'")
    private String platformCode;

    /**
     * 平台名称
     */
    @ApiModelProperty("平台名称")
    @Column(name = "platform_name", columnDefinition = "VARCHAR(255) COMMENT '平台名称'")
    private String platformName;

    /**
     * 客户
     */
    @ApiModelProperty("客户")
    @Column(name = "customer_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户'")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    @Column(name = "customer_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户名称'")
    private String customerName;

    /**
     * 总申请金额
     */
    @ApiModelProperty("总申请金额")
    @TableField(value = "total_apply_amount")
    @Column(name = "total_apply_amount", columnDefinition = "decimal(20,6) COMMENT '总申请金额'")
    private BigDecimal totalApplyAmount;

    /**
     * MDG客户编码
     */
    @ApiModelProperty("MDG客户编码")
    @Column(name = "erp_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT 'MDG客户编码'")
    private String erpCode;

    /**
     * 预算所属客户编码
     */
    @ApiModelProperty("预算所属客户编码")
    @Column(name = "customer_profit_loss_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '预算所属客户编码'")
    private String customerProfitLossCode;

    /**
     * 预算所属客户ERP编码
     */
    @ApiModelProperty("预算所属客户ERP编码")
    @Column(name = "customer_profit_loss_erp_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '预算所属客户ERP编码'")
    private String customerProfitLossErpCode;

    /**
     * 预算所属客户名称
     */
    @ApiModelProperty("预算所属客户名称")
    @Column(name = "customer_profit_loss_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '预算所属客户名称'")
    private String customerProfitLossName;


    /**
     * 审批流程编码
     */
    @ApiModelProperty("审批流程编码")
    @Column(name = "process_no",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '审批流程编码'")
    private String processNo;
    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    @Column(name = "process_status", length = 10, columnDefinition = "varchar(10) COMMENT '审批状态'")
    private String processStatus;

    @ApiModelProperty(value = "业务单元编码")
    @Column(name = "business_unit_code", length = 32, columnDefinition = "varchar(32) COMMENT '业务单元编码'")
    private String businessUnitCode;

    @ApiModelProperty("业态编码")
    @Column(name = "business_format_code", length = 32, columnDefinition = "varchar(32) COMMENT '业态编码'")
    private String businessFormatCode;

    /**
     * 组织编码
     */
    @ApiModelProperty("组织编码")
    @Column(name = "org_code", length = 32, columnDefinition = "varchar(32) COMMENT '组织编码'")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty("组织名称")
    @Column(name = "org_name", length = 512, columnDefinition = "varchar(512) COMMENT '组织名称'")
    private String orgName;

    /**
     * 职位编码
     */
    @ApiModelProperty("职位编码")
    @Column(name = "position_code", length = 32, columnDefinition = "varchar(32) COMMENT '职位编码'")
    private String positionCode;

    /**
     * 职位名称
     */
    @ApiModelProperty("职位名称")
    @Column(name = "position_name", length = 512, columnDefinition = "varchar(512) COMMENT '职位名称'")
    private String positionName;

    /**
     * 销售部门编码
     */
    @ApiModelProperty("销售部门编码")
    @Column(name = "sales_department_code", length = 32, columnDefinition = "varchar(32) COMMENT '销售部门编码'")
    private String salesDepartmentCode;

    /**
     * 销售部门名称
     */
    @ApiModelProperty("销售部门名称")
    @Column(name = "sales_department_name", columnDefinition = "varchar(255) COMMENT '销售部门名称'")
    private String salesDepartmentName;

    /**
     * 销售组编码
     */
    @ApiModelProperty("销售组编码")
    @Column(name = "sales_group_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组编码'")
    private String salesGroupCode;

    /**
     * 销售组名称
     */
    @ApiModelProperty("销售组名称")
    @Column(name = "sales_group_name", columnDefinition = "VARCHAR(64) COMMENT '销售组名称'")
    private String salesGroupName;

    /**
     * 渠道编码
     */
    @ApiModelProperty("渠道编码")
    @Column(name = "channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '渠道编码'")
    private String channelCode;

    /**
     * 渠道名称
     */
    @ApiModelProperty("渠道名称")
    @Column(name = "channel_name", columnDefinition = "varchar(255) COMMENT '渠道名称'")
    private String channelName;
}
