package com.biz.crm.tpm.business.promotion.plan.local.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 促销规划结果呈现表
 *
 * @author: yaoyongming
 * @date: 2023/1/14 16:14
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "PromotionPlanResult", description = "促销规划结果呈现表")
@Entity
@org.hibernate.annotations.Table(appliesTo = "tpm_promotion_plan_result", comment = "促销规划结果呈现表")
@TableName("tpm_promotion_plan_result")
@Table(
        name = "tpm_promotion_plan_result",
        indexes = {
                @Index(name = "tpm_promotion_plan_result1", columnList = "promotion_plan_code"),
                @Index(name = "tpm_promotion_plan_result2", columnList = "start_date"),
                @Index(name = "tpm_promotion_plan_result3", columnList = "end_date"),
                @Index(name = "tpm_promotion_plan_result4", columnList = "project_code"),
                @Index(name = "tpm_promotion_plan_result5", columnList = "project_name"),
                @Index(name = "tpm_promotion_plan_result6", columnList = "type"),
        })
public class PromotionPlanResult extends TenantFlagOpEntity {

    /**
     * 促销规划编码
     */
    @ApiModelProperty("促销规划编码")
    @Column(name = "promotion_plan_code", length = 32, columnDefinition = "VARCHAR(64) COMMENT '促销规划编码'")
    private String promotionPlanCode;

    /**
     * 促销规划名称
     */
    @ApiModelProperty("促销规划名称")
    @Column(name = "promotion_plan_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '促销规划名称'")
    private String promotionPlanName;

    /**
     * 促销规划时间开始
     */
    @ApiModelProperty("促销规划时间开始")
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "start_date" , length = 10, columnDefinition = "datetime COMMENT '促销规划时间开始'")
    private Date startDate;

    /**
     * 促销规划时间结束
     */
    @ApiModelProperty("促销规划时间结束")
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "end_date" , length = 10, columnDefinition = "datetime COMMENT '促销规划时间结束'")
    private Date endDate;

    /**
     * 项目编码
     */
    @ApiModelProperty("项目编码")
    @Column(name = "project_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '项目编码'")
    private String projectCode;

    /**
     * 项目名称
     */
    @ApiModelProperty("项目名称")
    @Column(name = "project_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '项目名称'")
    private String projectName;

    /**
     * 同期
     */
    @ApiModelProperty("同期")
    @Column(name = "contemporaneous", columnDefinition = "decimal(20,6) COMMENT '同期'")
    private BigDecimal contemporaneous;

    /**
     * 预算
     */
    @ApiModelProperty("预算")
    @Column(name = "budget", columnDefinition = "decimal(20,6) COMMENT '预算'")
    private BigDecimal budget;

    /**
     * 规划
     */
    @ApiModelProperty("规划")
    @Column(name = "plan", columnDefinition = "decimal(20,6) COMMENT '规划'")
    private BigDecimal plan;

    /**
     * 累计同期
     */
    @ApiModelProperty("累计同期")
    @Column(name = "contemporaneous_total", columnDefinition = "decimal(20,6) COMMENT '累计同期'")
    private BigDecimal contemporaneousTotal;

    /**
     * 累计预算
     */
    @ApiModelProperty("累计预算")
    @Column(name = "budget_total", columnDefinition = "decimal(20,6) COMMENT '累计预算'")
    private BigDecimal budgetTotal;

    /**
     * 累计规划
     */
    @ApiModelProperty("累计规划")
    @Column(name = "plan_total", columnDefinition = "decimal(20,6) COMMENT '累计规划'")
    private BigDecimal planTotal;

    /**
     * 规划VS同期
     */
    @ApiModelProperty("规划VS同期")
    @Column(name = "plan_vs_contemporaneous", columnDefinition = "decimal(20,6) COMMENT '规划VS同期'")
    private BigDecimal planVsContemporaneous;

    /**
     * 规划VS预算
     */
    @ApiModelProperty("规划VS预算")
    @Column(name = "plan_vs_budget", columnDefinition = "decimal(20,6) COMMENT '规划VS预算'")
    private BigDecimal planVsBudget;

    /**
     * 累计实际&规划
     */
    @ApiModelProperty("累计实际&规划")
    @Column(name = "actual_plan", columnDefinition = "decimal(20,6) COMMENT '累计实际&规划'")
    private BigDecimal actualPlan;

    /**
     * 累计实际&规划VS预算
     */
    @ApiModelProperty("累计实际&规划VS预算")
    @Column(name = "actual_plan_vs_budget", columnDefinition = "decimal(20,6) COMMENT '累计实际&规划VS预算'")
    private BigDecimal actualPlanVsBudget;

    /**
     * 前台/账面
     */
    @ApiModelProperty("前台/账面")
    @Column(name = "type", length = 32, columnDefinition = "varchar(32) COMMENT '前台/账面'")
    private String type;
}
