package com.biz.crm.tpm.business.promotion.plan.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
/**
 * 平台维度电商的促销规划一览汇总表
 *
 * @author: cyj
 * @date: 2023/1/14 16:14
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "PromotionPlanTableForm", description = "平台维度电商的促销规划一览汇总表")
@Entity
@org.hibernate.annotations.Table(appliesTo = "tpm_promotion_plan_table_form", comment = "平台维度电商的促销规划一览汇总表")
@TableName("tpm_promotion_plan_table_form")
@Table(
        name = "tpm_promotion_plan_table_form",
        indexes = {
                @Index(name = "tpm_promotion_plan_table_form1", columnList = "only_key"),
        })
public class PromotionPlanTableForm extends TenantFlagOpEntity {

    @ApiModelProperty("销售部门编码")
    @Column(name = "sales_department_code", length = 32, columnDefinition = "varchar(32) COMMENT '销售部门编码'")
    private String salesDepartmentCode;

    @ApiModelProperty("销售部门名称")
    @Column(name = "sales_department_name", columnDefinition = "varchar(255) COMMENT '销售部门名称'")
    private String salesDepartmentName;

    @ApiModelProperty("hr部门编码")
    @Column(name = "org_code", length = 32, columnDefinition = "varchar(32) COMMENT 'hr部门编码'")
    private String orgCode;

    @ApiModelProperty("hr部门名称")
    @Column(name = "org_name", columnDefinition = "varchar(255) COMMENT 'hr部门名称'")
    private String orgName;

    @ApiModelProperty("平台编码")
    @Column(name = "platform_code", length = 32, columnDefinition = "VARCHAR(64) COMMENT '平台编码'")
    private String platformCode;

    @ApiModelProperty("平台名称")
    @Column(name = "platform_name", columnDefinition = "VARCHAR(255) COMMENT '平台名称'")
    private String platformName;

    @ApiModelProperty("同期净收入")
    @Column(name = "net_income_contemporaneous", columnDefinition = "decimal(20,6) COMMENT '同期净收入'")
    private BigDecimal netIncomeContemporaneous;

    @ApiModelProperty("预算净收入")
    @Column(name = "net_income_budget", columnDefinition = "decimal(20,6) COMMENT '预算净收入'")
    private BigDecimal netIncomeBudget;

    @ApiModelProperty("规划净收入")
    @Column(name = "net_income_plan", columnDefinition = "decimal(20,6) COMMENT '规划净收入'")
    private BigDecimal netIncomePlan;

    @ApiModelProperty("净收入达成")
    @Column(name = "income_achievement", columnDefinition = "decimal(20,6) COMMENT '净收入达成'")
    private BigDecimal incomeAchievement;

    @ApiModelProperty("VS同期（净收入）")
    @Column(name = "vs_contemporaneous", columnDefinition = "decimal(20,6) COMMENT 'VS同期（净收入）'")
    private BigDecimal vsContemporaneous;

    @ApiModelProperty("VS预算（净收入）")
    @Column(name = "vs_budget", columnDefinition = "decimal(20,6) COMMENT 'VS预算（净收入）'")
    private BigDecimal vsBudget;

    @ApiModelProperty("同期专项费用率")
    @Column(name = "contemporaneous_special_expense_rate", columnDefinition = "decimal(20,6) COMMENT '同期专项费用率'")
    private BigDecimal contemporaneousSpecialExpenseRate;

    @ApiModelProperty("预算专项费用率")
    @Column(name = "budget_special_expense_rate", columnDefinition = "decimal(20,6) COMMENT '预算专项费用率'")
    private BigDecimal budgetSpecialExpenseRate;

    @ApiModelProperty("规划专项费用率")
    @Column(name = "plan_special_expense_rate", columnDefinition = "decimal(20,6) COMMENT '规划专项费用率'")
    private BigDecimal planSpecialExpenseRate;

    @ApiModelProperty("VS同期（费用率）")
    @Column(name = "expense_rate_vs_contemporaneous", columnDefinition = "decimal(20,6) COMMENT 'VS同期（费用率）'")
    private BigDecimal expenseRateVsContemporaneous;

    @ApiModelProperty("VS预算（费用率）")
    @Column(name = "expense_rate_vs_budget", columnDefinition = "decimal(20,6) COMMENT 'VS预算（费用率）'")
    private BigDecimal expenseRateVsBudget;

    @ApiModelProperty("同期净利润")
    @Column(name = "contemporaneous_net_profit", columnDefinition = "decimal(20,6) COMMENT '同期净利润'")
    private BigDecimal contemporaneousNetProfit;

    @ApiModelProperty("预算净利润")
    @Column(name = "budget_net_profit", columnDefinition = "decimal(20,6) COMMENT '预算净利润'")
    private BigDecimal budgetNetProfit;

    @ApiModelProperty("规划净利润")
    @Column(name = "planned_net_profit", columnDefinition = "decimal(20,6) COMMENT '规划净利润'")
    private BigDecimal plannedNetProfit;

    @ApiModelProperty("预算净利率")
    @Column(name = "budget_profit_margin", columnDefinition = "decimal(20,6) COMMENT '预算净利率'")
    private BigDecimal budgetProfitMargin;

    @ApiModelProperty("规划净利率")
    @Column(name = "planned_profit_margin", columnDefinition = "decimal(20,6) COMMENT '规划净利率'")
    private BigDecimal plannedProfitMargin;

    @ApiModelProperty("净利率达成")
    @Column(name = "profit_margin_reached", columnDefinition = "decimal(20,6) COMMENT '净利率达成'")
    private BigDecimal profitMarginReached;

    @ApiModelProperty(name = "年月", notes = "年月")
    @Column(name = "year_and_month",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '年月'")
    private String yearAndMonth;

    @ApiModelProperty(name = "唯一键", notes = "唯一键")
    @Column(name = "only_key",  length = 255, columnDefinition = "VARCHAR(255) COMMENT '唯一键'")
    private String onlyKey;

    @ApiModelProperty(name = "层级", notes = "1=部门,2=平台")
    @Column(name = "level_code",  length = 8, columnDefinition = "VARCHAR(8) COMMENT '层级'")
    private String levelCode;


}
