package com.biz.crm.tpm.business.promotion.plan.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @author: yaoyongming
 * @date: 2023/9/11 15:15
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "PromotionPlanWholeSummary", description = "促销规划整体一览表")
@Entity
@org.hibernate.annotations.Table(appliesTo = "`tpm_promotion_plan_whole_summary`", comment = "促销规划整体一览表")
@TableName("tpm_promotion_plan_whole_summary")
@Table(
        name = "`tpm_promotion_plan_whole_summary`",
        indexes = {
                @Index(name = "promotion_plan_whole_summary_idx1", columnList = "year_month_ly"),
                @Index(name = "promotion_plan_whole_summary_idx2", columnList = "whole_summary_name")
        })
public class PromotionPlanWholeSummary extends TenantFlagOpEntity {

    /**
     * 年月
     */
    @ApiModelProperty("年月")
    @Column(name = "year_month_ly", length = 32, columnDefinition = "VARCHAR(32) COMMENT '年月 '")
    private String yearMonthLy;

    /**
     * 名称
     */
    @ApiModelProperty("名称")
    @Column(name = "whole_summary_name", length = 32, columnDefinition = "VARCHAR(32) COMMENT '名称 '")
    private String wholeSummaryName;

    /**
     * 流程编号
     */
    @ApiModelProperty("流程编号")
    @Column(name = "process_no", length = 64, columnDefinition = "varchar(64) COMMENT '流程编号'")
    private String processNo;

    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    @Column(name = "process_status", length = 10, columnDefinition = "varchar(10) COMMENT '审批状态'")
    private String processStatus;

    /**
     * 文件唯一识别号
     */
    @ApiModelProperty(value = "文件唯一识别号")
    @Column(name = "file_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '文件唯一识别号'")
    private String fileCode;

    /**
     * 原始文件名
     */
    @ApiModelProperty(name="originalFileName" , value="原始文件名")
    @Column(name = "original_file_name", columnDefinition = "varchar(255) COMMENT '原始文件名'")
    private String originalFileName;

}
