package com.biz.crm.tpm.business.promotion.plan.local.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 促销规划整体一览表明细
 *
 * @author: yaoyongming
 * @date: 2023/9/11 16:14
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "PromotionPlanWholeSummaryDetail", description = "促销规划整体一览表明细")
@Entity
@org.hibernate.annotations.Table(appliesTo = "`tpm_promotion_plan_whole_summary_detail`", comment = "促销规划整体一览表明细")
@TableName("tpm_promotion_plan_whole_summary_detail")
@Table(
        name = "`tpm_promotion_plan_whole_summary_detail`",
        indexes = {
                @Index(name = "promotion_plan_whole_summary_detail_idx1", columnList = "year_month_ly"),
                @Index(name = "promotion_plan_whole_summary_detail_idx2", columnList = "project_code"),
                @Index(name = "promotion_plan_whole_summary_detail_idx3", columnList = "project_name")
        })
public class PromotionPlanWholeSummaryDetail extends TenantFlagOpEntity {

    @ApiModelProperty("排序值(值越小越靠前)")
    @Column(name = "sort_index", nullable = false, columnDefinition = "int(8) COMMENT '排序值(值越小越靠前) '")
    private Integer sortIndex;

    /**
     * 年月
     */
    @ApiModelProperty("年月")
    @Column(name = "year_month_ly", length = 32, columnDefinition = "VARCHAR(32) COMMENT '年月 '")
    private String yearMonthLy;

    /**
     * 项目编码
     */
    @ApiModelProperty("项目编码")
    @Column(name = "project_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '项目编码'")
    private String projectCode;

    /**
     * 项目名称
     */
    @ApiModelProperty("项目名称")
    @Column(name = "project_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '项目名称'")
    private String projectName;

    /**
     * 同期
     */
    @ApiModelProperty("同期")
    @Column(name = "contemporaneous", columnDefinition = "decimal(20,6) COMMENT '同期'")
    private BigDecimal contemporaneous;

    /**
     * 预算
     */
    @ApiModelProperty("预算")
    @Column(name = "budget", columnDefinition = "decimal(20,6) COMMENT '预算'")
    private BigDecimal budget;

    /**
     * 规划
     */
    @ApiModelProperty("规划")
    @Column(name = "plan", columnDefinition = "decimal(20,6) COMMENT '规划'")
    private BigDecimal plan;

    /**
     * 累计同期
     */
    @ApiModelProperty("累计同期")
    @Column(name = "contemporaneous_total", columnDefinition = "decimal(20,6) COMMENT '累计同期'")
    private BigDecimal contemporaneousTotal;

    /**
     * 累计预算
     */
    @ApiModelProperty("累计预算")
    @Column(name = "budget_total", columnDefinition = "decimal(20,6) COMMENT '累计预算'")
    private BigDecimal budgetTotal;

    /**
     * 累计规划
     */
    @ApiModelProperty("累计规划")
    @Column(name = "plan_total", columnDefinition = "decimal(20,6) COMMENT '累计规划'")
    private BigDecimal planTotal;

    /**
     * 规划VS同期
     */
    @ApiModelProperty("规划VS同期")
    @Column(name = "plan_vs_contemporaneous", columnDefinition = "decimal(20,6) COMMENT '规划VS同期'")
    private BigDecimal planVsContemporaneous;

    /**
     * 规划VS预算
     */
    @ApiModelProperty("规划VS预算")
    @Column(name = "plan_vs_budget", columnDefinition = "decimal(20,6) COMMENT '规划VS预算'")
    private BigDecimal planVsBudget;

    /**
     * 累计实际（当月-1）
     */
    @ApiModelProperty("累计实际（当月-1）")
    @Column(name = "actual_sub1", columnDefinition = "decimal(20,6) COMMENT '累计实际（当月-1）'")
    private BigDecimal actualSub1;

    /**
     * 累计实际（当月-2）
     */
    @ApiModelProperty("累计实际（当月-2）")
    @Column(name = "actual_sub2", columnDefinition = "decimal(20,6) COMMENT '累计实际（当月-2）'")
    private BigDecimal actualSub2;

    /**
     * 累计实际&规划（当月）
     */
    @ApiModelProperty("累计实际&规划（当月）")
    @Column(name = "actual_plan", columnDefinition = "decimal(20,6) COMMENT '累计实际&规划（当月）'")
    private BigDecimal actualPlan;

    /**
     * 累计实际&规划（当月+上月）
     */
    @ApiModelProperty("累计实际&规划（当月+上月）")
    @Column(name = "actual_plan_last", columnDefinition = "decimal(20,6) COMMENT '累计实际&规划（当月+上月）'")
    private BigDecimal actualPlanLast;

    /**
     * 累计实际&规划VS预算
     */
    @ApiModelProperty("累计实际&规划VS预算")
    @Column(name = "actual_plan_vs_budget", columnDefinition = "decimal(20,6) COMMENT '累计实际&规划VS预算'")
    private BigDecimal actualPlanVsBudget;

    /**
     * 年累计预算
     */
    @ApiModelProperty("年累计预算")
    @Column(name = "budget_total_year", columnDefinition = "decimal(20,6) COMMENT '年累计预算'")
    private BigDecimal budgetTotalYear;

    /**
     * 使用进度
     */
    @ApiModelProperty("使用进度")
    @Column(name = "use_progress", columnDefinition = "decimal(20,6) COMMENT '使用进度'")
    private BigDecimal useProgress;
}
