package com.biz.crm.tpm.business.promotion.plan.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 采销库存
 *
 * @author: yaoyongming
 * @date: 2022/11/12 16:46
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "PurchaseSale", description = "采销库存")
@Entity
@org.hibernate.annotations.Table(appliesTo = "tpm_purchase_sale", comment = "采销库存")
@TableName("tpm_purchase_sale")
@Table(
        name = "tpm_purchase_sale",
        indexes = {
                @Index(name = "uk_tpm_expenses_code_index", columnList = "expenses_code", unique = true),
                @Index(name = "promotion_plan_code_index", columnList = "promotion_plan_code"),
        })
public class PurchaseSale extends TenantFlagOpEntity {

    /**
     * 促销规划编码
     */
    @ApiModelProperty("促销规划编码")
    @Column(name = "promotion_plan_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '促销规划编码'")
    private String promotionPlanCode;

    /**
     * 促销规划明细编码
     */
    @ApiModelProperty("促销规划明细编码")
    @Column(name = "expenses_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '促销规划明细编码'")
    private String expensesCode;

    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    @Column(name = "product_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '产品编码 '")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    @Column(name = "product_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '产品名称 '")
    private String productName;

    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    @Column(name = "product_brand_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '品牌编码 '")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    @Column(name = "product_brand_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '品牌名称 '")
    private String productBrandName;

    /**
     * 标准零售价
     */
    @ApiModelProperty("标准零售价")
    @Column(name = "standard_retail_price", length = 24, columnDefinition = "decimal(24,6) COMMENT '标准零售价'")
    private BigDecimal standardRetailPrice;

    /**
     * 供货价
     */
    @ApiModelProperty("供货价")
    @Column(name = "supply_price", length = 24, columnDefinition = "decimal(24,6) COMMENT '供货价'")
    private BigDecimal supplyPrice;

    /**
     * 促销售价（元）
     */
    @ApiModelProperty("促销售价（元）")
    @Column(name = "promotion_price", length = 24, columnDefinition = "decimal(24,6) COMMENT '促销售价（元）'")
    private BigDecimal promotionPrice;

    /**
     * 本月期末库存（箱）
     */
    @ApiModelProperty("本月期末库存（箱）")
    @Column(name = "month_inventory_end", length = 24, columnDefinition = "decimal(24,6) COMMENT '本月期末库存（箱）'")
    private BigDecimal monthInventoryEnd;

    /**
     * 费用池-补差
     */
    @ApiModelProperty("费用池-补差")
    @Column(name = "fee_pool_difference", length = 24, columnDefinition = "decimal(24,6) COMMENT '费用池-补差'")
    private BigDecimal feePoolDifference;

    /**
     * 费用池-销售返
     */
    @ApiModelProperty("费用池-销售返")
    @Column(name = "fee_pool_sale_commission", length = 24, columnDefinition = "decimal(24,6) COMMENT '费用池-销售返'")
    private BigDecimal feePoolSaleCommission;

    /**
     * 费用池-采购返
     */
    @ApiModelProperty("费用池-采购返")
    @Column(name = "fee_pool_purchase_rebate", length = 24, columnDefinition = "decimal(24,6) COMMENT '费用池-采购返'")
    private BigDecimal feePoolPurchaseRebate;

    /**
     * 费用池-投放
     */
    @ApiModelProperty("费用池-投放")
    @Column(name = "fee_pool_put", length = 24, columnDefinition = "decimal(24,6) COMMENT '费用池-投放'")
    private BigDecimal feePoolPut;

    /**
     * 费用池-毛保
     */
    @ApiModelProperty("费用池-毛保")
    @Column(name = "fee_pool_gross_protection", length = 24, columnDefinition = "decimal(24,6) COMMENT '费用池-毛保'")
    private BigDecimal feePoolGrossProtection;

    /**
     * MDG客户编码
     */
    @ApiModelProperty("MDG客户编码")
    @Column(name = "erp_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT 'MDG客户编码'")
    private String erpCode;

    /**
     * 红线价
     */
    @ApiModelProperty("红线价")
    @Column(name = "red_line_price", columnDefinition = "DECIMAL(20,6) COMMENT '红线价'")
    private BigDecimal redLinePrice;

    /**
     * 次月期末库存（箱）
     */
    @ApiModelProperty("次月期末库存（箱）")
    @Column(name = "next_month_end_inventory", columnDefinition = "DECIMAL(20,6) COMMENT '次月期末库存（箱）'")
    private BigDecimal nextMonthEndInventory;

    /**
     * 次月库存预估售价（元）
     */
    @ApiModelProperty("次月库存预估售价（元）")
    @Column(name = "next_month_inventory_amount", columnDefinition = "DECIMAL(20,6) COMMENT '次月库存预估售价（元）'")
    private BigDecimal nextMonthInventoryAmount;

    /**
     * 成本价
     */
    @ApiModelProperty("成本价")
    @Column(name = "cost_price", columnDefinition = "DECIMAL(20,6) COMMENT '成本价'")
    private BigDecimal costPrice;
}
