package com.biz.crm.tpm.business.promotion.plan.local.job;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionPlanTableFormService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionPlanWholeSummaryService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 报表 job
 *
 * @author cyj
 * @version 1.0
 * @date 2023/1/10 16:00
 * @description PromotionPlanTableFormXxJob
 */
@Slf4j
@Service
public class PromotionPlanXxlJob {

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private PromotionPlanTableFormService promotionPlanTableFormService;


    @Autowired(required = false)
    private PromotionPlanWholeSummaryService promotionPlanWholeSummaryService;

    /**
     * 平台维度电商的促销规划一览汇总表
     */
    @DynamicTaskService(cornExpression = "0 0 0 * * ? ", taskDesc = "平台维度电商的促销规划一览汇总表")
    public void createDataSummary() {
        loginUserService.refreshAuthentication(null);
        promotionPlanTableFormService.createDataSummary(null);
    }

    /**
     * 平台维度电商的促销规划一览汇总表
     */
    @DynamicTaskService(cornExpression = "0 30 2 1 * ?", taskDesc = "每月1号 02:30 执行一次生成促销规划整体一览表任务")
    public void createPromotionPlanWholeSummary() {
        loginUserService.refreshAuthentication(null);
        promotionPlanWholeSummaryService.createPromotionPlanWholeSummary(null);
    }
}
