package com.biz.crm.tpm.business.promotion.plan.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.tpm.business.promotion.plan.local.entity.CurrentMonthDeliveryEntity;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.CurrentMonthDeliveryDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.CurrentMonthDeliveryVo;
import org.apache.ibatis.annotations.Param;

/**
 * 当月送货实体类(CurrentMonthDeliveryEntity)表mybatis访问层
 *
 * @author yaoyongming
 * @since 2022-11-02 19:22:12
 */
public interface CurrentMonthDeliveryMapper extends BaseMapper<CurrentMonthDeliveryEntity> {

  /**
   * 分页查询所有数据
   *
   * @param page 分页对象
   * @param currentMonthDelivery 查询实体
   * @return 所有数据
  */
  public Page<CurrentMonthDeliveryVo> findByConditions(@Param("page") Page<CurrentMonthDeliveryVo> page, @Param("dto") CurrentMonthDeliveryDto currentMonthDelivery);
}

